/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.platform.serverconfig;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.lucko.spark.paper.common.platform.MetadataProvider;
import me.lucko.spark.paper.common.platform.serverconfig.ConfigParser;
import me.lucko.spark.paper.common.platform.serverconfig.ExcludedConfigFilter;

public abstract class ServerConfigProvider
implements MetadataProvider {
    protected static final Set<String> BASE_HIDDEN_PATHS = ImmutableSet.of((Object)"server-ip", (Object)"motd", (Object)"resource-pack", (Object)"rcon<dot>password", (Object)"rcon<dot>ip", (Object)"level-seed", (Object[])new String[]{"management-server-secret", "management-server-tls-keystore-password"});
    private final Map<String, ConfigParser> files;
    private final ExcludedConfigFilter hiddenPathFilters;

    protected ServerConfigProvider(Map<String, ConfigParser> files, Collection<String> hiddenPaths) {
        this.files = files;
        this.hiddenPathFilters = new ExcludedConfigFilter(hiddenPaths);
    }

    @Override
    public final Map<String, JsonElement> get() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.files.forEach((path, parser) -> {
            try {
                JsonElement json = parser.load((String)path, this.hiddenPathFilters);
                if (json == null) {
                    return;
                }
                builder.put(path, (Object)json);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return builder.build();
    }

    protected static List<String> getSystemPropertyList(String property) {
        String value = System.getProperty(property);
        return value == null ? Collections.emptyList() : Arrays.asList(value.split(","));
    }
}

