/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.arguments.parser.EntitySelectorParser;
import dev.jorel.commandapi.arguments.parser.RegistryParser;
import dev.jorel.commandapi.arguments.parser.function.ThrowingBiFunction;
import dev.jorel.commandapi.arguments.parser.function.ThrowingSupplier;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.nms.BundledNMS;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.nms.PaperNMS;
import dev.jorel.commandapi.wrappers.DoubleRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.AxisSet;
import io.papermc.paper.command.brigadier.argument.SignedMessageResolver;
import io.papermc.paper.command.brigadier.argument.position.ColumnBlockPosition;
import io.papermc.paper.command.brigadier.argument.position.ColumnFinePosition;
import io.papermc.paper.command.brigadier.argument.predicate.BlockInWorldPredicate;
import io.papermc.paper.command.brigadier.argument.predicate.ItemStackPredicate;
import io.papermc.paper.command.brigadier.argument.range.DoubleRangeProvider;
import io.papermc.paper.command.brigadier.argument.range.IntegerRangeProvider;
import io.papermc.paper.command.brigadier.argument.resolvers.AngleResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.ColumnBlockPositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.ColumnFinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.PlayerProfileListResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Rotation;
import io.papermc.paper.registry.RegistryKey;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class APITypeProvider
implements BundledNMS<CommandSourceStack> {
    private final PaperNMS<CommandSourceStack> paperNMS;
    private final SimpleCommandExceptionType noEntitiesFound;
    private final SimpleCommandExceptionType noPlayersFound;

    public APITypeProvider(PaperNMS<?> paperNMS) {
        this.paperNMS = paperNMS;
        this.bukkitNMS();
        GsonComponentSerializer gson = GsonComponentSerializer.gson();
        this.noEntitiesFound = new SimpleCommandExceptionType(paperNMS.bukkitNMS().generateMessageFromJson((String)gson.serialize((Component)Component.translatable((String)"argument.entity.notfound.entity"))));
        this.noPlayersFound = new SimpleCommandExceptionType(paperNMS.bukkitNMS().generateMessageFromJson((String)gson.serialize((Component)Component.translatable((String)"argument.entity.notfound.player"))));
    }

    private ArgumentType<?> getArgumentType(ThrowingSupplier<ArgumentType<?>> paper, Supplier<ArgumentType<?>> nms) {
        try {
            return paper.get();
        }
        catch (Throwable t) {
            return nms.get();
        }
    }

    private ArgumentType<?> getArgumentType(Supplier<ArgumentType<?>> nms) {
        return nms.get();
    }

    private <T> T parseT(CommandContext<CommandSourceStack> cmdCtx, String key, ThrowingBiFunction<CommandContext<CommandSourceStack>, String, T, Exception> api, ThrowingBiFunction<CommandContext<CommandSourceStack>, String, T, CommandSyntaxException> nms) throws CommandSyntaxException {
        try {
            return api.apply(cmdCtx, key);
        }
        catch (Throwable t) {
            return nms.apply(cmdCtx, key);
        }
    }

    private <T> T parse(CommandContext<CommandSourceStack> cmdCtx, String key, BiFunction<CommandContext<CommandSourceStack>, String, T> api, BiFunction<CommandContext<CommandSourceStack>, String, T> nms) {
        try {
            return api.apply(cmdCtx, key);
        }
        catch (Throwable t) {
            return nms.apply(cmdCtx, key);
        }
    }

    private <T> T parseT(CommandContext<CommandSourceStack> cmdCtx, String key, ThrowingBiFunction<CommandContext<CommandSourceStack>, String, T, CommandSyntaxException> nms) throws CommandSyntaxException {
        return nms.apply(cmdCtx, key);
    }

    private <T> T parse(CommandContext<CommandSourceStack> cmdCtx, String key, BiFunction<CommandContext<CommandSourceStack>, String, T> nms) {
        return nms.apply(cmdCtx, key);
    }

    @Override
    public ArgumentType<?> _ArgumentAdvancement() {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentAdvancement());
    }

    @Override
    public ArgumentType<?> _ArgumentAngle() {
        return this.getArgumentType(() -> ArgumentTypes.angle(), () -> this.paperNMS.bukkitNMS()._ArgumentAngle());
    }

    @Override
    public ArgumentType<?> _ArgumentAxis() {
        return this.getArgumentType(() -> ArgumentTypes.axes(), () -> this.paperNMS.bukkitNMS()._ArgumentAxis());
    }

    @Override
    public ArgumentType<?> _ArgumentBlockPredicate() {
        return this.getArgumentType(() -> ArgumentTypes.blockInWorldPredicate(), () -> this.paperNMS.bukkitNMS()._ArgumentBlockPredicate());
    }

    @Override
    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTypes.blockState();
    }

    @Override
    public ArgumentType<?> _ArgumentChat() {
        return ArgumentTypes.signedMessage();
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentTypes.component();
    }

    @Override
    public ArgumentType<?> _ArgumentChatFormat() {
        return ArgumentTypes.namedColor();
    }

    @Override
    public ArgumentType<?> _ArgumentDimension() {
        return ArgumentTypes.world();
    }

    @Override
    public ArgumentType<?> _ArgumentEnchantment() {
        return ArgumentTypes.resource((RegistryKey)RegistryKey.ENCHANTMENT);
    }

    @Override
    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentTypes.entity();
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentTypes.entities();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentTypes.player();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentTypes.players();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE);
    }

    @Override
    public ArgumentType<?> _ArgumentFloatRange() {
        return ArgumentTypes.doubleRange();
    }

    @Override
    public ArgumentType<?> _ArgumentIntRange() {
        return ArgumentTypes.integerRange();
    }

    @Override
    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentTypes.itemPredicate();
    }

    @Override
    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentTypes.itemStack();
    }

    @Override
    public ArgumentType<?> _ArgumentMathOperation() {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentMathOperation());
    }

    @Override
    public ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ArgumentTypes.namespacedKey();
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ArgumentTypes.resource((RegistryKey)RegistryKey.MOB_EFFECT);
    }

    @Override
    public ArgumentType<?> _ArgumentNBTCompound() {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentNBTCompound());
    }

    @Override
    public ArgumentType<?> _ArgumentParticle() {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentParticle());
    }

    @Override
    public ArgumentType<?> _ArgumentPosition() {
        return ArgumentTypes.blockPosition();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition2D() {
        return this.getArgumentType(() -> ArgumentTypes.columnBlockPosition(), () -> this.paperNMS.bukkitNMS()._ArgumentPosition2D());
    }

    @Override
    public ArgumentType<?> _ArgumentProfile() {
        return ArgumentTypes.playerProfiles();
    }

    @Override
    public ArgumentType<?> _ArgumentRecipe() {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentRecipe());
    }

    @Override
    public ArgumentType<?> _ArgumentRotation() {
        return this.getArgumentType(() -> ArgumentTypes.rotation(), () -> this.paperNMS.bukkitNMS()._ArgumentRotation());
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ArgumentTypes.objectiveCriteria();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardObjective() {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentScoreboardObjective());
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardSlot() {
        return ArgumentTypes.scoreboardDisplaySlot();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardTeam() {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentScoreboardTeam());
    }

    @Override
    public ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentScoreholder(subType));
    }

    @Override
    public ArgumentType<?> _ArgumentTag() {
        return this.getArgumentType(() -> this.paperNMS.bukkitNMS()._ArgumentTag());
    }

    @Override
    public ArgumentType<?> _ArgumentTime() {
        return ArgumentTypes.time();
    }

    @Override
    public ArgumentType<?> _ArgumentUUID() {
        return ArgumentTypes.uuid();
    }

    @Override
    public ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return this.getArgumentType(() -> ArgumentTypes.columnFinePosition((boolean)centerPosition), () -> this.paperNMS.bukkitNMS()._ArgumentVec2(centerPosition));
    }

    @Override
    public ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return this.getArgumentType(() -> ArgumentTypes.finePosition((boolean)centerPosition), () -> this.paperNMS.bukkitNMS()._ArgumentVec3(centerPosition));
    }

    @Override
    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return ArgumentTypes.resource((RegistryKey)RegistryKey.BIOME);
    }

    @Override
    public String[] compatibleVersions() {
        return this.paperNMS.bukkitNMS().compatibleVersions();
    }

    @Override
    public String convert(ItemStack is) {
        return this.paperNMS.bukkitNMS().convert(is);
    }

    @Override
    public String convert(ParticleData<?> particle) {
        return this.paperNMS.bukkitNMS().convert(particle);
    }

    @Override
    public String convert(PotionEffectType potion) {
        return this.paperNMS.bukkitNMS().convert(potion);
    }

    @Override
    public String convert(Sound sound) {
        return this.paperNMS.bukkitNMS().convert(sound);
    }

    @Override
    public Advancement getAdvancement(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getAdvancement((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public float getAngle(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> {
            AngleResolver resolver = (AngleResolver)ctx.getArgument(name, AngleResolver.class);
            return Float.valueOf(resolver.resolve((CommandSourceStack)ctx.getSource()));
        }, (ctx, name) -> Float.valueOf(this.paperNMS.bukkitNMS().getAngle((CommandContext<CommandSourceStack>)ctx, (String)name))).floatValue();
    }

    @Override
    public EnumSet<Axis> getAxis(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return this.parse(cmdCtx, key, (ctx, name) -> {
            AxisSet axisSet = (AxisSet)ctx.getArgument(name, AxisSet.class);
            return EnumSet.copyOf(axisSet);
        }, (ctx, name) -> this.paperNMS.bukkitNMS().getAxis((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public RegistryParser<Biome> getBiome(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return new RegistryParser<Biome>(() -> (Biome)cmdCtx.getArgument(key, Biome.class), () -> ((Biome)cmdCtx.getArgument(key, Biome.class)).getKey());
    }

    @Override
    public Predicate<Block> getBlockPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> {
            BlockInWorldPredicate predicate = (BlockInWorldPredicate)ctx.getArgument(key, BlockInWorldPredicate.class);
            return block -> predicate.testBlock(block).asBoolean();
        }, (ctx, name) -> this.paperNMS.bukkitNMS().getBlockPredicate((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public BlockState getBlockState(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return (BlockState)cmdCtx.getArgument(key, BlockState.class);
    }

    @Override
    public World getDimension(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return (World)cmdCtx.getArgument(key, World.class);
    }

    @Override
    public Enchantment getEnchantment(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return (Enchantment)cmdCtx.getArgument(key, Enchantment.class);
    }

    @Override
    public EntitySelectorParser getEntitySelector(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return new EntitySelectorParser(() -> (Player)((List)((PlayerSelectorArgumentResolver)cmdCtx.getArgument(key, PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)cmdCtx.getSource())).getFirst(), () -> (Entity)((List)((EntitySelectorArgumentResolver)cmdCtx.getArgument(key, EntitySelectorArgumentResolver.class)).resolve((CommandSourceStack)cmdCtx.getSource())).getFirst(), allowEmpty -> {
            List players = (List)((PlayerSelectorArgumentResolver)cmdCtx.getArgument(key, PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)cmdCtx.getSource());
            if (players.isEmpty() && !allowEmpty.booleanValue()) {
                throw this.noPlayersFound.create();
            }
            return players;
        }, allowEmpty -> {
            List entities = (List)((EntitySelectorArgumentResolver)cmdCtx.getArgument(key, EntitySelectorArgumentResolver.class)).resolve((CommandSourceStack)cmdCtx.getSource());
            if (entities.isEmpty() && !allowEmpty.booleanValue()) {
                throw this.noEntitiesFound.create();
            }
            return entities;
        });
    }

    @Override
    public EntityType getEntityType(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return (EntityType)cmdCtx.getArgument(key, EntityType.class);
    }

    @Override
    public DoubleRange getDoubleRange(CommandContext<CommandSourceStack> cmdCtx, String key) {
        DoubleRangeProvider rangeProvider = (DoubleRangeProvider)cmdCtx.getArgument(key, DoubleRangeProvider.class);
        double low = rangeProvider.range().hasLowerBound() ? (Double)rangeProvider.range().lowerEndpoint() : -1.7976931348623157E308;
        double high = rangeProvider.range().hasUpperBound() ? (Double)rangeProvider.range().upperEndpoint() : Double.MAX_VALUE;
        return new DoubleRange(low, high);
    }

    @Override
    public FunctionWrapper[] getFunction(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getFunction((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        return this.paperNMS.bukkitNMS().getFunction(key);
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        return this.paperNMS.bukkitNMS().getFunctions();
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandSourceStack> cmdCtx, String key) {
        IntegerRangeProvider rangeProvider = (IntegerRangeProvider)cmdCtx.getArgument(key, IntegerRangeProvider.class);
        int low = rangeProvider.range().hasLowerBound() ? (Integer)rangeProvider.range().lowerEndpoint() : Integer.MIN_VALUE;
        int high = rangeProvider.range().hasUpperBound() ? (Integer)rangeProvider.range().upperEndpoint() : Integer.MAX_VALUE;
        return new IntegerRange(low, high);
    }

    @Override
    public ItemStack getItemStack(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return (ItemStack)cmdCtx.getArgument(key, ItemStack.class);
    }

    @Override
    public Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return (Predicate)cmdCtx.getArgument(key, ItemStackPredicate.class);
    }

    @Override
    public Location2D getLocation2DBlock(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> {
            ColumnBlockPosition resolver = (ColumnBlockPosition)((ColumnBlockPositionResolver)ctx.getArgument(key, ColumnBlockPositionResolver.class)).resolve((CommandSourceStack)ctx.getSource());
            return new Location2D(this.getWorldForCSS((CommandSourceStack)ctx.getSource()), resolver.blockX(), resolver.blockZ());
        }, (ctx, name) -> this.paperNMS.bukkitNMS().getLocation2DBlock((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public Location2D getLocation2DPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> {
            ColumnFinePosition columnFinePosition = (ColumnFinePosition)((ColumnFinePositionResolver)ctx.getArgument(key, ColumnFinePositionResolver.class)).resolve((CommandSourceStack)ctx.getSource());
            return new Location2D(this.getWorldForCSS((CommandSourceStack)ctx.getSource()), columnFinePosition.x(), columnFinePosition.z());
        }, (ctx, name) -> this.paperNMS.bukkitNMS().getLocation2DPrecise((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public Location getLocationBlock(CommandContext<CommandSourceStack> cmdCtx, String str) throws CommandSyntaxException {
        BlockPosition blockPosition = (BlockPosition)((BlockPositionResolver)cmdCtx.getArgument(str, BlockPositionResolver.class)).resolve((CommandSourceStack)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)blockPosition.blockX(), (double)blockPosition.blockY(), (double)blockPosition.blockZ());
    }

    @Override
    public Location getLocationPrecise(CommandContext<CommandSourceStack> cmdCtx, String str) throws CommandSyntaxException {
        return this.parseT(cmdCtx, str, (ctx, name) -> {
            FinePosition finePosition = (FinePosition)((FinePositionResolver)ctx.getArgument(name, FinePositionResolver.class)).resolve((CommandSourceStack)ctx.getSource());
            return new Location(this.getWorldForCSS((CommandSourceStack)ctx.getSource()), finePosition.x(), finePosition.y(), finePosition.z());
        }, (ctx, name) -> this.paperNMS.bukkitNMS().getLocationPrecise((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public LootTable getLootTable(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return this.parse(cmdCtx, key, (ctx, name) -> Bukkit.getLootTable((NamespacedKey)((NamespacedKey)ctx.getArgument(name, NamespacedKey.class))), (ctx, name) -> this.paperNMS.bukkitNMS().getLootTable((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public MathOperation getMathOperation(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getMathOperation((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return (NamespacedKey)cmdCtx.getArgument(key, NamespacedKey.class);
    }

    @Override
    public <NBTContainer> Object getNBTCompound(CommandContext<CommandSourceStack> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return this.parse(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getNBTCompound((CommandContext<CommandSourceStack>)ctx, (String)name, nbtContainerConstructor));
    }

    @Override
    public Objective getObjective(CommandContext<CommandSourceStack> cmdCtx, String key) throws IllegalArgumentException, CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getObjective((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public String getObjectiveCriteria(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ((Criteria)cmdCtx.getArgument(key, Criteria.class)).getName();
    }

    @Override
    public ParticleData<?> getParticle(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return this.parse(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getParticle((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public RegistryParser<PotionEffectType> getPotionEffect(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return new RegistryParser<PotionEffectType>(() -> (PotionEffectType)cmdCtx.getArgument(key, PotionEffectType.class), () -> ((PotionEffectType)cmdCtx.getArgument(key, PotionEffectType.class)).getKey());
    }

    @Override
    public <T extends Recipe> T getRecipe(CommandContext<CommandSourceStack> cmdCtx, String key, BiFunction<NamespacedKey, Recipe, T> result) throws CommandSyntaxException {
        return (T)this.parseT(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getRecipe((CommandContext<CommandSourceStack>)ctx, (String)name, result));
    }

    @Override
    public dev.jorel.commandapi.wrappers.Rotation getRotation(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> {
            Rotation rotation = (Rotation)((RotationResolver)ctx.getArgument(name, RotationResolver.class)).resolve((CommandSourceStack)ctx.getSource());
            return new dev.jorel.commandapi.wrappers.Rotation(rotation.yaw(), rotation.pitch());
        }, (ctx, name) -> this.paperNMS.bukkitNMS().getRotation((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandSourceStack> cmdCtx, String key) {
        DisplaySlot displaySlot = (DisplaySlot)cmdCtx.getArgument(key, DisplaySlot.class);
        return ScoreboardSlot.of(displaySlot);
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getScoreHolderMultiple((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getScoreHolderSingle((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public Team getTeam(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return this.parseT(cmdCtx, key, (ctx, name) -> this.paperNMS.bukkitNMS().getTeam((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public int getTime(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    @Override
    public UUID getUUID(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return (UUID)cmdCtx.getArgument(key, UUID.class);
    }

    @Override
    public World getWorldForCSS(CommandSourceStack clw) {
        return this.paperNMS.bukkitNMS().getWorldForCSS(clw);
    }

    @Override
    public SimpleCommandMap getSimpleCommandMap() {
        return this.paperNMS.bukkitNMS().getSimpleCommandMap();
    }

    @Override
    public RegistryParser<Sound> getSound(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return this.parse(cmdCtx, key, (ctx, name) -> {
            NamespacedKey namespace = (NamespacedKey)ctx.getArgument(name, NamespacedKey.class);
            return new RegistryParser<Sound>(() -> (Sound)Registry.SOUND_EVENT.get(namespace), () -> namespace);
        }, (ctx, name) -> this.paperNMS.bukkitNMS().getSound((CommandContext<CommandSourceStack>)ctx, (String)name));
    }

    @Override
    public SuggestionProvider<CommandSourceStack> getSuggestionProvider(SuggestionProviders provider) {
        return this.paperNMS.bukkitNMS().getSuggestionProvider(provider);
    }

    @Override
    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        return this.paperNMS.bukkitNMS().getTag(key);
    }

    @Override
    public Set<NamespacedKey> getTags() {
        return this.paperNMS.bukkitNMS().getTags();
    }

    @Override
    public void reloadDataPacks() {
        this.paperNMS.bukkitNMS().reloadDataPacks();
    }

    @Override
    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return this.paperNMS.bukkitNMS().generateHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public Map<String, HelpTopic> getHelpMap() {
        return this.paperNMS.bukkitNMS().getHelpMap();
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return this.paperNMS.bukkitNMS().generateMessageFromJson(json);
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandSourceStack> cmdCtx, boolean forceNative) {
        return this.paperNMS.bukkitNMS().getSenderForCommand(cmdCtx, forceNative);
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandSourceStack css) {
        return this.paperNMS.bukkitNMS().getCommandSenderFromCommandSource(css);
    }

    @Override
    public CommandSourceStack getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return this.paperNMS.bukkitNMS().getBrigadierSourceFromCommandSender(sender);
    }

    @Override
    public void createDispatcherFile(File file, CommandDispatcher<CommandSourceStack> brigadierDispatcher) throws IOException {
        this.paperNMS.bukkitNMS().createDispatcherFile(file, brigadierDispatcher);
    }

    @Override
    public <T> T getMinecraftServer() {
        return this.paperNMS.bukkitNMS().getMinecraftServer();
    }

    @Override
    public NativeProxyCommandSender createNativeProxyCommandSender(CommandSender caller, CommandSender callee, Location location, World world) {
        return this.paperNMS.bukkitNMS().createNativeProxyCommandSender(caller, callee, location, world);
    }

    @Override
    public SignedMessage getChat(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return (SignedMessage)((SignedMessageResolver)cmdCtx.getArgument(key, SignedMessageResolver.class)).resolveSignedMessage(key, cmdCtx).join();
    }

    @Override
    public NamedTextColor getChatColor(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return (NamedTextColor)cmdCtx.getArgument(key, NamedTextColor.class);
    }

    @Override
    public Component getChatComponent(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return (Component)cmdCtx.getArgument(key, Component.class);
    }

    @Override
    public List<PlayerProfile> getProfile(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return new ArrayList<PlayerProfile>((Collection)((PlayerProfileListResolver)cmdCtx.getArgument(key, PlayerProfileListResolver.class)).resolve((CommandSourceStack)cmdCtx.getSource()));
    }

    @Override
    public NMS<CommandSourceStack> bukkitNMS() {
        return this.paperNMS.bukkitNMS();
    }

    @Override
    public CommandRegistrationStrategy<CommandSourceStack> createCommandRegistrationStrategy() {
        return this.paperNMS.createCommandRegistrationStrategy();
    }
}

