/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.yaml;

import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import net.kyori.option.Option;
import net.kyori.option.OptionSchema;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.loader.CommentHandler;
import org.spongepowered.configurate.loader.CommentHandlers;
import org.spongepowered.configurate.util.UnmodifiableCollections;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.internal.snakeyaml.DumperOptions;
import org.spongepowered.configurate.yaml.internal.snakeyaml.LoaderOptions;
import org.spongepowered.configurate.yaml.internal.snakeyaml.Yaml;
import org.spongepowered.configurate.yaml.internal.snakeyaml.constructor.BaseConstructor;
import org.spongepowered.configurate.yaml.internal.snakeyaml.constructor.Constructor;
import org.spongepowered.configurate.yaml.internal.snakeyaml.representer.Representer;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet((Object[])new Class[]{Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class});
    private final ThreadLocal<Yaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super((AbstractConfigurationLoader.Builder)builder, new CommentHandler[]{CommentHandlers.HASH});
        LoaderOptions loaderOpts = new LoaderOptions().setAcceptTabs(true).setProcessComments(false);
        loaderOpts.setCodePointLimit(Integer.MAX_VALUE);
        DumperOptions opts = builder.options;
        opts.setDefaultFlowStyle(NodeStyle.asSnakeYaml((NodeStyle)((Object)builder.optionState().value(Builder.NODE_STYLE))));
        opts.setIndent((Integer)builder.optionState().value(Builder.INDENT));
        this.yaml = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)new Constructor(loaderOpts), new Representer(opts), opts, loaderOpts));
    }

    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) {
        node.raw(this.yaml.get().load(reader));
    }

    protected void saveInternal(ConfigurationNode node, Writer writer) {
        this.yaml.get().dump(node.raw(), writer);
    }

    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root((ConfigurationOptions)options);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private static final OptionSchema.Mutable UNSAFE_SCHEMA = OptionSchema.childSchema((OptionSchema)AbstractConfigurationLoader.Builder.SCHEMA);
        public static final OptionSchema SCHEMA = UNSAFE_SCHEMA.frozenView();
        public static final Option<NodeStyle> NODE_STYLE = UNSAFE_SCHEMA.enumOption("yaml:node_style", NodeStyle.class, null);
        public static final Option<Integer> INDENT = UNSAFE_SCHEMA.intOption("yaml:indent", 4);
        private final DumperOptions options = new DumperOptions();

        Builder() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
        }

        protected OptionSchema optionSchema() {
            return SCHEMA;
        }

        public Builder indent(int indent) {
            this.optionStateBuilder().value(INDENT, (Object)indent);
            return this;
        }

        public int indent() {
            return (Integer)this.optionState().value(INDENT);
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.optionStateBuilder().value(NODE_STYLE, (Object)style);
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return (NodeStyle)((Object)this.optionState().value(NODE_STYLE));
        }

        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

