/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.math;

import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.BlockPositionImpl;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.FinePositionImpl;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
public interface Position {
    public static final FinePosition FINE_ZERO = new FinePositionImpl(0.0, 0.0, 0.0);
    public static final BlockPosition BLOCK_ZERO = new BlockPositionImpl(0, 0, 0);

    public int blockX();

    public int blockY();

    public int blockZ();

    public double x();

    public double y();

    public double z();

    public boolean isBlock();

    public boolean isFine();

    default public boolean isFinite() {
        return Double.isFinite(this.x()) && Double.isFinite(this.y()) && Double.isFinite(this.z());
    }

    public Position offset(int var1, int var2, int var3);

    public FinePosition offset(double var1, double var3, double var5);

    @Contract(value="-> new", pure=true)
    default public FinePosition toCenter() {
        return new FinePositionImpl((double)this.blockX() + 0.5, (double)this.blockY() + 0.5, (double)this.blockZ() + 0.5);
    }

    @Contract(pure=true)
    public BlockPosition toBlock();

    @Contract(value="-> new", pure=true)
    default public Vector toVector() {
        return new Vector(this.x(), this.y(), this.z());
    }

    @Contract(value="_ -> new", pure=true)
    default public Location toLocation(World world) {
        return new Location(world, this.x(), this.y(), this.z());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static BlockPosition block(int x, int y, int z) {
        return new BlockPositionImpl(x, y, z);
    }

    @Contract(value="_ -> new", pure=true)
    public static BlockPosition block(Location location) {
        return new BlockPositionImpl(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static FinePosition fine(double x, double y, double z) {
        return new FinePositionImpl(x, y, z);
    }

    @Contract(value="_ -> new", pure=true)
    public static FinePosition fine(Location location) {
        return new FinePositionImpl(location.getX(), location.getY(), location.getZ());
    }
}

