/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.input;

import io.papermc.paper.registry.data.dialog.DialogInstancesProvider;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public non-sealed interface SingleOptionDialogInput
extends DialogInput {
    @Contract(pure=true)
    public @Range(from=1L, to=1024L) int width();

    @Contract(pure=true)
    public @Unmodifiable List<OptionEntry> entries();

    @Contract(pure=true)
    public Component label();

    @Contract(pure=true)
    public boolean labelVisible();

    @ApiStatus.NonExtendable
    public static interface Builder {
        @Contract(value="_ -> this", mutates="this")
        public Builder width(@Range(from=1L, to=1024L) int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder labelVisible(boolean var1);

        @Contract(value="-> new", pure=true)
        public SingleOptionDialogInput build();
    }

    @ApiStatus.NonExtendable
    public static interface OptionEntry {
        @Contract(pure=true, value="_, _, _ -> new")
        public static OptionEntry create(String id, @Nullable Component display, boolean initial) {
            return DialogInstancesProvider.instance().singleOptionEntry(id, display, initial);
        }

        @Contract(pure=true)
        public String id();

        @Contract(pure=true)
        public @Nullable Component display();

        @Contract(pure=true)
        public boolean initial();
    }
}

