/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.tag;

import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.TagEntryImpl;
import net.kyori.adventure.key.Keyed;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface TagEntry<T>
extends Keyed {
    @Contract(value="_ -> new", pure=true)
    public static <T> TagEntry<T> valueEntry(TypedKey<T> entryKey) {
        return TagEntry.valueEntry(entryKey, true);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <T> TagEntry<T> valueEntry(TypedKey<T> entryKey, boolean isRequired) {
        return new TagEntryImpl(entryKey.key(), false, isRequired);
    }

    @Contract(value="_ -> new", pure=true)
    public static <T> TagEntry<T> tagEntry(TagKey<T> tagKey) {
        return TagEntry.tagEntry(tagKey, true);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <T> TagEntry<T> tagEntry(TagKey<T> tagKey, boolean isRequired) {
        return new TagEntryImpl(tagKey.key(), true, isRequired);
    }

    @Contract(pure=true)
    public boolean isTag();

    @Contract(pure=true)
    public boolean isRequired();
}

