/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentHolder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.inventory.ItemRarity;
import io.papermc.paper.inventory.tooltip.TooltipContext;
import io.papermc.paper.persistence.PersistentDataContainerView;
import io.papermc.paper.persistence.PersistentDataViewHolder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Translatable;
import org.bukkit.UndefinedNullability;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ItemStack
implements Cloneable,
ConfigurationSerializable,
Translatable,
HoverEventSource<HoverEvent.ShowItem>,
net.kyori.adventure.translation.Translatable,
PersistentDataViewHolder,
DataComponentHolder {
    private ItemStack craftDelegate;
    private MaterialData data = null;
    private static final byte ARRAY_SERIALIZATION_VERSION = 1;

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material type) {
        return ItemStack.of(type, 1);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material type, int amount) {
        Preconditions.checkArgument((type.asItemType() != null ? 1 : 0) != 0, (String)"%s isn't an item", (Object)type);
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"amount must be greater than 0");
        return Objects.requireNonNull(type.asItemType(), String.valueOf(type) + " is not an item").createItemStack(amount);
    }

    @Override
    public @NotNull PersistentDataContainerView getPersistentDataContainer() {
        return this.craftDelegate.getPersistentDataContainer();
    }

    public boolean editPersistentDataContainer(@NotNull Consumer<PersistentDataContainer> consumer) {
        return this.craftDelegate.editPersistentDataContainer(consumer);
    }

    protected ItemStack() {
    }

    @ApiStatus.Obsolete(since="1.21")
    public ItemStack(@NotNull Material type) {
        this(type, 1);
    }

    @ApiStatus.Obsolete(since="1.21")
    public ItemStack(@NotNull Material type, int amount) {
        this(type, amount, 0);
    }

    @Deprecated(since="1.20.5")
    public ItemStack(@NotNull Material type, int amount, short damage) {
        this(type, amount, damage, null);
    }

    @Deprecated(since="1.4.5", forRemoval=true)
    public ItemStack(@NotNull Material type, int amount, short damage, @Nullable Byte data) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        if (type.isLegacy()) {
            type = type.getMaxDurability() > 0 ? Bukkit.getUnsafe().fromLegacy(new MaterialData(type, data == null ? (byte)0 : data), true) : Bukkit.getUnsafe().fromLegacy(new MaterialData(type, data == null ? (byte)damage : data), true);
        }
        ItemStack itemStack = this.craftDelegate = type == Material.AIR ? ItemStack.empty() : ItemStack.of(type, amount);
        if (damage != 0) {
            this.setDurability(damage);
        }
        if (data != null) {
            this.createData(data);
        }
    }

    @ApiStatus.Obsolete(since="1.21")
    public ItemStack(@NotNull ItemStack stack) throws IllegalArgumentException {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"Cannot copy null stack");
        this.craftDelegate = stack.clone();
        if (stack.getType().isLegacy()) {
            this.data = stack.getData();
        }
    }

    @NotNull
    public Material getType() {
        return this.craftDelegate.getType();
    }

    @Deprecated
    public void setType(@NotNull Material type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        this.craftDelegate.setType(type);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public ItemStack withType(@NotNull Material type) {
        return this.craftDelegate.withType(type);
    }

    public int getAmount() {
        return this.craftDelegate.getAmount();
    }

    public void setAmount(int amount) {
        this.craftDelegate.setAmount(amount);
    }

    @Deprecated(forRemoval=true, since="1.13")
    @Nullable
    public MaterialData getData() {
        Material mat = Bukkit.getUnsafe().toLegacy(this.getType());
        if (this.data == null && mat != null && mat.getData() != null) {
            this.data = mat.getNewData((byte)this.getDurability());
        }
        return this.data;
    }

    @Deprecated(forRemoval=true, since="1.13")
    public void setData(@Nullable MaterialData data) {
        if (data == null) {
            this.data = data;
        } else {
            Material mat = Bukkit.getUnsafe().toLegacy(this.getType());
            if (data.getClass() == mat.getData() || data.getClass() == MaterialData.class) {
                this.data = data;
            } else {
                throw new IllegalArgumentException("Provided data is not of type " + mat.getData().getName() + ", found " + data.getClass().getName());
            }
        }
    }

    @Deprecated(since="1.13")
    public void setDurability(short durability) {
        this.craftDelegate.setDurability(durability);
    }

    @Deprecated(since="1.13")
    public short getDurability() {
        return this.craftDelegate.getDurability();
    }

    public int getMaxStackSize() {
        return this.craftDelegate.getMaxStackSize();
    }

    private void createData(byte data) {
        this.data = this.craftDelegate.getType().getNewData(data);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder("ItemStack{").append(this.getType().name()).append(" x ").append(this.getAmount());
        if (this.hasItemMeta()) {
            toString.append(", ").append(this.getItemMeta());
        }
        return toString.append('}').toString();
    }

    public boolean equals(Object obj) {
        return this.craftDelegate.equals(obj);
    }

    public boolean isSimilar(@Nullable ItemStack stack) {
        return this.craftDelegate.isSimilar(stack);
    }

    @NotNull
    public ItemStack clone() {
        return this.craftDelegate.clone();
    }

    public int hashCode() {
        return this.craftDelegate.hashCode();
    }

    public boolean containsEnchantment(@NotNull Enchantment enchant) {
        return this.craftDelegate.containsEnchantment(enchant);
    }

    public int getEnchantmentLevel(@NotNull Enchantment enchant) {
        return this.craftDelegate.getEnchantmentLevel(enchant);
    }

    @NotNull
    public Map<Enchantment, Integer> getEnchantments() {
        return this.craftDelegate.getEnchantments();
    }

    public void addEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        Preconditions.checkArgument((enchantments != null ? 1 : 0) != 0, (Object)"Enchantments cannot be null");
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            this.addEnchantment(entry.getKey(), entry.getValue());
        }
    }

    public void addEnchantment(@NotNull Enchantment enchant, int level) {
        Preconditions.checkArgument((enchant != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (level < enchant.getStartLevel() || level > enchant.getMaxLevel()) {
            throw new IllegalArgumentException("Enchantment level is either too low or too high (given " + level + ", bounds are " + enchant.getStartLevel() + " to " + enchant.getMaxLevel() + ")");
        }
        if (!enchant.canEnchantItem(this)) {
            throw new IllegalArgumentException("Specified enchantment cannot be applied to this itemstack");
        }
        this.addUnsafeEnchantment(enchant, level);
    }

    public void addUnsafeEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            this.addUnsafeEnchantment(entry.getKey(), entry.getValue());
        }
    }

    public void addUnsafeEnchantment(@NotNull Enchantment enchant, int level) {
        this.craftDelegate.addUnsafeEnchantment(enchant, level);
    }

    public int removeEnchantment(@NotNull Enchantment enchant) {
        return this.craftDelegate.removeEnchantment(enchant);
    }

    public void removeEnchantments() {
        this.craftDelegate.removeEnchantments();
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        return Bukkit.getUnsafe().serializeStack(this);
    }

    @NotNull
    public static ItemStack deserialize(@NotNull Map<String, Object> args) {
        Object raw;
        Material type;
        if (args.containsKey("schema_version")) {
            return Bukkit.getUnsafe().deserializeStack(args);
        }
        int version = args.containsKey("v") ? ((Number)args.get("v")).intValue() : -1;
        short damage = 0;
        int amount = 1;
        if (args.containsKey("damage")) {
            damage = ((Number)args.get("damage")).shortValue();
        }
        if (version < 0) {
            type = Material.getMaterial("LEGACY_" + (String)args.get("type"));
            byte dataVal = type != null && type.getMaxDurability() == 0 ? (byte)damage : (byte)0;
            type = Bukkit.getUnsafe().fromLegacy(new MaterialData(type, dataVal), true);
            if (dataVal != 0) {
                damage = 0;
            }
        } else {
            type = Bukkit.getUnsafe().getMaterial((String)args.get("type"), version);
        }
        if (args.containsKey("amount")) {
            amount = ((Number)args.get("amount")).intValue();
        }
        ItemStack result = new ItemStack(type, amount, damage);
        if (args.containsKey("enchantments")) {
            Object raw2 = args.get("enchantments");
            if (raw2 instanceof Map) {
                Map map = (Map)raw2;
                for (Map.Entry entry : map.entrySet()) {
                    String stringKey = entry.getKey().toString();
                    stringKey = Bukkit.getUnsafe().get(Enchantment.class, stringKey);
                    NamespacedKey key = NamespacedKey.fromString(stringKey.toLowerCase(Locale.ROOT));
                    Enchantment enchantment = Bukkit.getUnsafe().get(RegistryKey.ENCHANTMENT, key);
                    if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
                    result.addUnsafeEnchantment(enchantment, (Integer)entry.getValue());
                }
            }
        } else if (args.containsKey("meta") && (raw = args.get("meta")) instanceof ItemMeta) {
            ((ItemMeta)raw).setVersion(version);
            if (version < 3837 && ((ItemMeta)raw).hasItemFlag(ItemFlag.HIDE_ADDITIONAL_TOOLTIP)) {
                ((ItemMeta)raw).addItemFlags(ItemFlag.HIDE_STORED_ENCHANTS);
            }
            result.setItemMeta((ItemMeta)raw);
        }
        if (version < 0 && args.containsKey("damage")) {
            result.setDurability(damage);
        }
        return result.ensureServerConversions();
    }

    public boolean editMeta(@NotNull Consumer<? super ItemMeta> consumer) {
        return this.editMeta(ItemMeta.class, consumer);
    }

    public <M extends ItemMeta> boolean editMeta(@NotNull Class<M> metaClass, @NotNull @NotNull Consumer<@NotNull ? super M> consumer) {
        @Nullable ItemMeta meta = this.getItemMeta();
        if (metaClass.isInstance(meta)) {
            consumer.accept(meta);
            this.setItemMeta(meta);
            return true;
        }
        return false;
    }

    @UndefinedNullability
    public ItemMeta getItemMeta() {
        return this.craftDelegate.getItemMeta();
    }

    public boolean hasItemMeta() {
        return this.craftDelegate.hasItemMeta();
    }

    public boolean setItemMeta(@Nullable ItemMeta itemMeta) {
        return this.craftDelegate.setItemMeta(itemMeta);
    }

    @Override
    @Deprecated(forRemoval=true)
    @NotNull
    public String getTranslationKey() {
        return Bukkit.getUnsafe().getTranslationKey(this);
    }

    @NotNull
    public ItemStack enchantWithLevels(int levels, boolean allowTreasure, @NotNull Random random) {
        return Bukkit.getServer().getItemFactory().enchantWithLevels(this, levels, allowTreasure, random);
    }

    @NotNull
    public ItemStack enchantWithLevels(int levels, @NotNull @NotNull RegistryKeySet<@NotNull Enchantment> keySet, @NotNull Random random) {
        return Bukkit.getItemFactory().enchantWithLevels(this, levels, keySet, random);
    }

    @NotNull
    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowItem> op) {
        return Bukkit.getServer().getItemFactory().asHoverEvent(this, op);
    }

    public @NotNull Component displayName() {
        return Bukkit.getServer().getItemFactory().displayName(this);
    }

    @NotNull
    public Component effectiveName() {
        return this.craftDelegate.effectiveName();
    }

    @NotNull
    public ItemStack ensureServerConversions() {
        return Bukkit.getServer().getItemFactory().ensureServerConversions(this);
    }

    @NotNull
    public static ItemStack deserializeBytes(byte @NotNull [] bytes) {
        return Bukkit.getUnsafe().deserializeItem(bytes);
    }

    public byte @NotNull [] serializeAsBytes() {
        return Bukkit.getUnsafe().serializeItem(this);
    }

    public static byte @NotNull [] serializeItemsAsBytes(@NotNull Collection<ItemStack> items) {
        Object object;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeByte(1);
            output.writeInt(items.size());
            for (ItemStack item : items) {
                if (item == null || item.isEmpty()) {
                    output.writeInt(0);
                    continue;
                }
                byte[] itemBytes = item.serializeAsBytes();
                output.writeInt(itemBytes.length);
                output.write(itemBytes);
            }
            object = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error while writing itemstack", e);
            }
        }
        outputStream.close();
        return object;
    }

    public static byte @NotNull [] serializeItemsAsBytes(@Nullable ItemStack @NotNull [] items) {
        return ItemStack.serializeItemsAsBytes(Arrays.asList(items));
    }

    @NotNull
    public static @NotNull ItemStack @NotNull [] deserializeItemsFromBytes(byte @NotNull [] bytes) {
        ItemStack[] itemStackArray;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            DataInputStream input = new DataInputStream(inputStream);
            byte version = input.readByte();
            if (version != 1) {
                throw new IllegalArgumentException("Unsupported version or bad data: " + version);
            }
            int count = input.readInt();
            ItemStack[] items = new ItemStack[count];
            for (int i = 0; i < count; ++i) {
                int length = input.readInt();
                if (length == 0) {
                    items[i] = ItemStack.empty();
                    continue;
                }
                byte[] itemBytes = new byte[length];
                input.read(itemBytes);
                items[i] = ItemStack.deserializeBytes(itemBytes);
            }
            itemStackArray = items;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading itemstack", e);
            }
        }
        inputStream.close();
        return itemStackArray;
    }

    @Deprecated
    @Nullable
    public String getI18NDisplayName() {
        return Bukkit.getServer().getItemFactory().getI18NDisplayName(this);
    }

    @Deprecated(forRemoval=true)
    public int getMaxItemUseDuration() {
        return this.getMaxItemUseDuration(null);
    }

    public int getMaxItemUseDuration(@NotNull LivingEntity entity) {
        return this.craftDelegate.getMaxItemUseDuration(entity);
    }

    @NotNull
    public ItemStack asOne() {
        return this.asQuantity(1);
    }

    @NotNull
    public ItemStack asQuantity(int qty) {
        ItemStack clone = this.clone();
        clone.setAmount(qty);
        return clone;
    }

    @NotNull
    public ItemStack add() {
        return this.add(1);
    }

    @NotNull
    public ItemStack add(int qty) {
        this.setAmount(Math.min(this.getMaxStackSize(), this.getAmount() + qty));
        return this;
    }

    @NotNull
    public ItemStack subtract() {
        return this.subtract(1);
    }

    @NotNull
    public ItemStack subtract(int qty) {
        this.setAmount(Math.max(0, this.getAmount() - qty));
        return this;
    }

    @Deprecated
    @Nullable
    public List<String> getLore() {
        if (!this.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = this.getItemMeta();
        if (!itemMeta.hasLore()) {
            return null;
        }
        return itemMeta.getLore();
    }

    @Nullable
    public List<Component> lore() {
        if (!this.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = this.getItemMeta();
        if (!itemMeta.hasLore()) {
            return null;
        }
        return itemMeta.lore();
    }

    @Deprecated
    public void setLore(@Nullable List<String> lore) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            throw new IllegalStateException("Cannot set lore on " + String.valueOf(this.getType()));
        }
        itemMeta.setLore(lore);
        this.setItemMeta(itemMeta);
    }

    public void lore(@Nullable List<? extends Component> lore) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            throw new IllegalStateException("Cannot set lore on " + String.valueOf(this.getType()));
        }
        itemMeta.lore(lore);
        this.setItemMeta(itemMeta);
    }

    public void addItemFlags(ItemFlag ... itemFlags) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            throw new IllegalStateException("Cannot add flags on " + String.valueOf(this.getType()));
        }
        itemMeta.addItemFlags(itemFlags);
        this.setItemMeta(itemMeta);
    }

    public void removeItemFlags(ItemFlag ... itemFlags) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            throw new IllegalStateException("Cannot remove flags on " + String.valueOf(this.getType()));
        }
        itemMeta.removeItemFlags(itemFlags);
        this.setItemMeta(itemMeta);
    }

    @NotNull
    public Set<ItemFlag> getItemFlags() {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            return Collections.emptySet();
        }
        return itemMeta.getItemFlags();
    }

    public boolean hasItemFlag(@NotNull ItemFlag flag) {
        ItemMeta itemMeta = this.getItemMeta();
        return itemMeta != null && itemMeta.hasItemFlag(flag);
    }

    @NotNull
    public String translationKey() {
        return Bukkit.getUnsafe().getTranslationKey(this);
    }

    @Deprecated(forRemoval=true, since="1.20.5")
    @NotNull
    public ItemRarity getRarity() {
        return ItemRarity.valueOf(this.getItemMeta().getRarity().name());
    }

    public boolean isRepairableBy(@NotNull ItemStack repairMaterial) {
        return Bukkit.getUnsafe().isValidRepairItemStack(this, repairMaterial);
    }

    public boolean canRepair(@NotNull ItemStack toBeRepaired) {
        return Bukkit.getUnsafe().isValidRepairItemStack(toBeRepaired, this);
    }

    @NotNull
    public ItemStack damage(int amount, @NotNull LivingEntity livingEntity) {
        return livingEntity.damageItemStack(this, amount);
    }

    @NotNull
    public static ItemStack empty() {
        return Bukkit.getUnsafe().createEmptyStack();
    }

    public boolean isEmpty() {
        return this.craftDelegate.isEmpty();
    }

    public @NotNull @Unmodifiable List<Component> computeTooltipLines(@NotNull TooltipContext tooltipContext, @Nullable Player player) {
        return Bukkit.getUnsafe().computeTooltipLines(this, tooltipContext, player);
    }

    @Override
    @Contract(pure=true)
    @ApiStatus.Experimental
    @Nullable
    public <T> T getData(@NotNull DataComponentType.Valued<T> type) {
        return this.craftDelegate.getData(type);
    }

    @Override
    @Contract(value="_, !null -> !null", pure=true)
    @ApiStatus.Experimental
    @Nullable
    public <T> T getDataOrDefault(@NotNull DataComponentType.Valued<? extends T> type, @Nullable T fallback) {
        T object = this.getData(type);
        return object != null ? object : fallback;
    }

    @Override
    @Contract(pure=true)
    @ApiStatus.Experimental
    public boolean hasData(@NotNull DataComponentType type) {
        return this.craftDelegate.hasData(type);
    }

    @Contract(value="-> new")
    @ApiStatus.Experimental
    public @Unmodifiable Set<@NotNull DataComponentType> getDataTypes() {
        return this.craftDelegate.getDataTypes();
    }

    @Override
    @ApiStatus.Experimental
    public <T> void setData(@NotNull DataComponentType.Valued<T> type, @NotNull DataComponentBuilder<T> valueBuilder) {
        this.setData(type, valueBuilder.build());
    }

    @Override
    @ApiStatus.Experimental
    public <T> void setData(@NotNull DataComponentType.Valued<T> type, @NotNull T value) {
        this.craftDelegate.setData(type, value);
    }

    @Override
    @ApiStatus.Experimental
    public void setData(@NotNull DataComponentType.NonValued type) {
        this.craftDelegate.setData(type);
    }

    @ApiStatus.Experimental
    public void unsetData(@NotNull DataComponentType type) {
        this.craftDelegate.unsetData(type);
    }

    @ApiStatus.Experimental
    public void resetData(@NotNull DataComponentType type) {
        this.craftDelegate.resetData(type);
    }

    @ApiStatus.Experimental
    public void copyDataFrom(@NotNull ItemStack source, @NotNull @NotNull Predicate<@NotNull DataComponentType> filter) {
        this.craftDelegate.copyDataFrom(source, filter);
    }

    @ApiStatus.Experimental
    public boolean isDataOverridden(@NotNull DataComponentType type) {
        return this.craftDelegate.isDataOverridden(type);
    }

    @ApiStatus.Experimental
    public boolean matchesWithoutData(@NotNull ItemStack item, @NotNull @NotNull Set<@NotNull DataComponentType> excludeTypes) {
        return this.matchesWithoutData(item, excludeTypes, false);
    }

    @ApiStatus.Experimental
    public boolean matchesWithoutData(@NotNull ItemStack item, @NotNull @NotNull Set<@NotNull DataComponentType> excludeTypes, boolean ignoreCount) {
        return this.craftDelegate.matchesWithoutData(item, excludeTypes, ignoreCount);
    }

    @NotNull
    public String getDisplayName() {
        return this.craftDelegate.getDisplayName();
    }

    public void setDisplayName(@Nullable String name) {
        this.craftDelegate.setDisplayName(name);
    }

    public boolean hasDisplayName() {
        return this.craftDelegate.hasDisplayName();
    }

    @NotNull
    public String getLocalizedName() {
        return this.craftDelegate.getLocalizedName();
    }

    public void setLocalizedName(@Nullable String name) {
        this.craftDelegate.setLocalizedName(name);
    }

    public boolean hasLocalizedName() {
        return this.craftDelegate.hasLocalizedName();
    }

    public boolean hasLore() {
        return this.craftDelegate.hasLore();
    }

    public boolean hasEnchant(@NotNull Enchantment ench) {
        return this.craftDelegate.hasEnchant(ench);
    }

    public int getEnchantLevel(@NotNull Enchantment ench) {
        return this.craftDelegate.getEnchantLevel(ench);
    }

    @NotNull
    public Map<Enchantment, Integer> getEnchants() {
        return this.craftDelegate.getEnchants();
    }

    public boolean addEnchant(@NotNull Enchantment ench, int level, boolean ignoreLevelRestriction) {
        return this.craftDelegate.addEnchant(ench, level, ignoreLevelRestriction);
    }

    public boolean removeEnchant(@NotNull Enchantment ench) {
        return this.craftDelegate.removeEnchant(ench);
    }

    public boolean hasEnchants() {
        return this.craftDelegate.hasEnchants();
    }

    public boolean hasConflictingEnchant(@NotNull Enchantment ench) {
        return this.craftDelegate.hasConflictingEnchant(ench);
    }

    public void setCustomModelData(@Nullable Integer data) {
        this.craftDelegate.setCustomModelData(data);
    }

    public int getCustomModelData() {
        return this.craftDelegate.getCustomModelData();
    }

    public boolean hasCustomModelData() {
        return this.craftDelegate.hasCustomModelData();
    }

    public boolean hasBlockData() {
        return this.craftDelegate.hasBlockData();
    }

    @NotNull
    public BlockData getBlockData(@NotNull Material material) {
        return this.craftDelegate.getBlockData(material);
    }

    public void setBlockData(@NotNull BlockData blockData) {
        this.craftDelegate.setBlockData(blockData);
    }

    public int getRepairCost() {
        return this.craftDelegate.getRepairCost();
    }

    public void setRepairCost(int cost) {
        this.craftDelegate.setRepairCost(cost);
    }

    public boolean hasRepairCost() {
        return this.craftDelegate.hasRepairCost();
    }

    public boolean isUnbreakable() {
        return this.craftDelegate.isUnbreakable();
    }

    public void setUnbreakable(boolean unbreakable) {
        this.craftDelegate.setUnbreakable(unbreakable);
    }

    public boolean hasAttributeModifiers() {
        return this.craftDelegate.hasAttributeModifiers();
    }

    @Nullable
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.craftDelegate.getAttributeModifiers();
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nullable EquipmentSlot slot) {
        return this.craftDelegate.getAttributeModifiers(slot);
    }

    @Nullable
    public Collection<AttributeModifier> getAttributeModifiers(@NotNull Attribute attribute) {
        return this.craftDelegate.getAttributeModifiers(attribute);
    }

    public boolean addAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        return this.craftDelegate.addAttributeModifier(attribute, modifier);
    }

    public void setAttributeModifiers(@Nullable Multimap<Attribute, AttributeModifier> attributeModifiers) {
        this.craftDelegate.setAttributeModifiers(attributeModifiers);
    }

    public boolean removeAttributeModifier(@NotNull Attribute attribute) {
        return this.craftDelegate.removeAttributeModifier(attribute);
    }

    public boolean removeAttributeModifier(@Nullable EquipmentSlot slot) {
        return this.craftDelegate.removeAttributeModifier(slot);
    }

    public boolean removeAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        return this.craftDelegate.removeAttributeModifier(attribute, modifier);
    }

    public boolean hasDamage() {
        return this.craftDelegate.hasDamage();
    }

    public int getDamage() {
        return this.craftDelegate.getDamage();
    }

    public void setDamage(int damage) {
        this.craftDelegate.setDamage(damage);
    }

    public void repair() {
        this.repair(1);
    }

    public boolean damage() {
        return this.damage(1);
    }

    public void repair(int amount) {
        this.damage(-amount);
    }

    public boolean damage(int amount) {
        return this.damage(amount, false);
    }

    public boolean damage(int amount, boolean ignoreUnbreaking) {
        return this.craftDelegate.damage(amount, ignoreUnbreaking);
    }
}

