/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.persistence;

import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.persistence.ListPersistentDataType;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class ListPersistentDataTypeProvider {
    private static final ListPersistentDataType<Byte, Byte> BYTE = new ListPersistentDataTypeImpl<Byte, Byte>(PersistentDataType.BYTE);
    private static final ListPersistentDataType<Short, Short> SHORT = new ListPersistentDataTypeImpl<Short, Short>(PersistentDataType.SHORT);
    private static final ListPersistentDataType<Integer, Integer> INTEGER = new ListPersistentDataTypeImpl<Integer, Integer>(PersistentDataType.INTEGER);
    private static final ListPersistentDataType<Long, Long> LONG = new ListPersistentDataTypeImpl<Long, Long>(PersistentDataType.LONG);
    private static final ListPersistentDataType<Float, Float> FLOAT = new ListPersistentDataTypeImpl<Float, Float>(PersistentDataType.FLOAT);
    private static final ListPersistentDataType<Double, Double> DOUBLE = new ListPersistentDataTypeImpl<Double, Double>(PersistentDataType.DOUBLE);
    private static final ListPersistentDataType<Byte, Boolean> BOOLEAN = new ListPersistentDataTypeImpl<Byte, Boolean>(PersistentDataType.BOOLEAN);
    private static final ListPersistentDataType<String, String> STRING = new ListPersistentDataTypeImpl<String, String>(PersistentDataType.STRING);
    private static final ListPersistentDataType<byte[], byte[]> BYTE_ARRAY = new ListPersistentDataTypeImpl<byte[], byte[]>(PersistentDataType.BYTE_ARRAY);
    private static final ListPersistentDataType<int[], int[]> INTEGER_ARRAY = new ListPersistentDataTypeImpl<int[], int[]>(PersistentDataType.INTEGER_ARRAY);
    private static final ListPersistentDataType<long[], long[]> LONG_ARRAY = new ListPersistentDataTypeImpl<long[], long[]>(PersistentDataType.LONG_ARRAY);
    private static final ListPersistentDataType<PersistentDataContainer, PersistentDataContainer> DATA_CONTAINER = new ListPersistentDataTypeImpl<PersistentDataContainer, PersistentDataContainer>(PersistentDataType.TAG_CONTAINER);

    ListPersistentDataTypeProvider() {
    }

    @NotNull
    public ListPersistentDataType<Byte, Byte> bytes() {
        return BYTE;
    }

    @NotNull
    public ListPersistentDataType<Short, Short> shorts() {
        return SHORT;
    }

    @NotNull
    public ListPersistentDataType<Integer, Integer> integers() {
        return INTEGER;
    }

    @NotNull
    public ListPersistentDataType<Long, Long> longs() {
        return LONG;
    }

    @NotNull
    public ListPersistentDataType<Float, Float> floats() {
        return FLOAT;
    }

    @NotNull
    public ListPersistentDataType<Double, Double> doubles() {
        return DOUBLE;
    }

    @NotNull
    public ListPersistentDataType<Byte, Boolean> booleans() {
        return BOOLEAN;
    }

    @NotNull
    public ListPersistentDataType<String, String> strings() {
        return STRING;
    }

    @NotNull
    public ListPersistentDataType<byte[], byte[]> byteArrays() {
        return BYTE_ARRAY;
    }

    @NotNull
    public ListPersistentDataType<int[], int[]> integerArrays() {
        return INTEGER_ARRAY;
    }

    @NotNull
    public ListPersistentDataType<long[], long[]> longArrays() {
        return LONG_ARRAY;
    }

    @NotNull
    public ListPersistentDataType<PersistentDataContainer, PersistentDataContainer> dataContainers() {
        return DATA_CONTAINER;
    }

    @NotNull
    public <P, C> ListPersistentDataType<P, C> listTypeFrom(@NotNull PersistentDataType<P, C> elementType) {
        return new ListPersistentDataTypeImpl<P, C>(elementType);
    }

    private static final class ListPersistentDataTypeImpl<P, C>
    implements ListPersistentDataType<P, C> {
        @NotNull
        private final PersistentDataType<P, C> innerType;

        private ListPersistentDataTypeImpl(@NotNull PersistentDataType<P, C> innerType) {
            this.innerType = innerType;
        }

        @Override
        @NotNull
        public Class<List<P>> getPrimitiveType() {
            return List.class;
        }

        @Override
        @NotNull
        public Class<List<C>> getComplexType() {
            return List.class;
        }

        @Override
        @NotNull
        public List<P> toPrimitive(@NotNull List<C> complex, @NotNull PersistentDataAdapterContext context) {
            return Lists.transform(complex, s -> this.innerType.toPrimitive(s, context));
        }

        @Override
        @NotNull
        public List<C> fromPrimitive(@NotNull List<P> primitive, @NotNull PersistentDataAdapterContext context) {
            return Lists.transform(primitive, s -> this.innerType.fromPrimitive(s, context));
        }

        @Override
        @NotNull
        public PersistentDataType<P, C> elementType() {
            return this.innerType;
        }
    }
}

