/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.executor.thread;

import ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.executor.thread.PrioritisedQueueExecutorThread;
import ca.spottedleaf.concurrentutil.list.COWArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamOrderedThreadPool {
    public static final long DEFAULT_DIVISION_TIME_SLICE = 15000000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamOrderedThreadPool.class);
    private final Consumer<Thread> threadModifier;
    private final COWArrayList<Division> divisions = new COWArrayList<Division>(Division.class);
    private final COWArrayList<WorkerThread> threads = new COWArrayList<WorkerThread>(WorkerThread.class);
    private final COWArrayList<WorkerThread> aliveThreads = new COWArrayList<WorkerThread>(WorkerThread.class);
    private final long groupTimeSliceNS;
    private boolean shutdown;

    public StreamOrderedThreadPool(long groupTimeSliceNS, Consumer<Thread> threadModifier) {
        this.threadModifier = threadModifier;
        if (threadModifier == null) {
            throw new NullPointerException("Thread factory may not be null");
        }
        this.groupTimeSliceNS = groupTimeSliceNS;
    }

    public Division createDivision() {
        throw new UnsupportedOperationException();
    }

    public Thread[] getAliveThreads() {
        WorkerThread[] threads = this.aliveThreads.getArray();
        return (Thread[])Arrays.copyOf(threads, threads.length, Thread[].class);
    }

    public Thread[] getCoreThreads() {
        WorkerThread[] threads = this.threads.getArray();
        return (Thread[])Arrays.copyOf(threads, threads.length, Thread[].class);
    }

    private void die(WorkerThread thread) {
        this.aliveThreads.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustThreadCount(int threads) {
        StreamOrderedThreadPool streamOrderedThreadPool = this;
        synchronized (streamOrderedThreadPool) {
            if (this.shutdown) {
                return;
            }
            WorkerThread[] currentThreads = this.threads.getArray();
            if (threads == currentThreads.length) {
                return;
            }
            if (threads < currentThreads.length) {
                int difference = currentThreads.length - threads;
                for (int i = 0; i < difference; ++i) {
                    WorkerThread remove = currentThreads[currentThreads.length - i - 1];
                    remove.halt(false);
                    this.threads.remove(remove);
                }
            } else {
                int difference = threads - currentThreads.length;
                for (int i = 0; i < difference; ++i) {
                    WorkerThread thread = new WorkerThread();
                    this.threadModifier.accept(thread);
                    this.aliveThreads.add(thread);
                    this.threads.add(thread);
                    thread.start();
                }
            }
        }
    }

    public boolean join(long msToWait) {
        try {
            return this.join(msToWait, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean joinInterruptable(long msToWait) throws InterruptedException {
        return this.join(msToWait, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean join(long msToWait, boolean interruptable) throws InterruptedException {
        long nsToWait = msToWait * 1000000L;
        long start = System.nanoTime();
        long deadline = start + nsToWait;
        boolean interrupted = false;
        try {
            for (WorkerThread thread : this.aliveThreads.getArray()) {
                while (thread.isAlive()) {
                    long current = System.nanoTime();
                    if (current - deadline >= 0L && msToWait > 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        thread.join(msToWait <= 0L ? 0L : Math.max(1L, (deadline - current) / 1000000L));
                    }
                    catch (InterruptedException ex) {
                        if (interruptable) {
                            throw ex;
                        }
                        interrupted = true;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final class Division {
        public Division(StreamOrderedThreadPool this$0) {
        }
    }

    private final class WorkerThread
    extends PrioritisedQueueExecutorThread {
        public WorkerThread() {
            super((PrioritisedExecutor)null);
        }

        @Override
        protected boolean pollTasks() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void die() {
            StreamOrderedThreadPool.this.die(this);
        }
    }
}

