/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.map;

import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.HashUtil;
import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;

public class ConcurrentLong2LongChainedHashTable
implements Iterable<TableEntry> {
    private static final TableEntry RESIZE_NODE = new TableEntry(0L, 0L);
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected final AtomicLong size = new AtomicLong();
    protected final float loadFactor;
    protected volatile TableEntry[] table;
    protected volatile TableEntry[] nextTable;
    protected static final int THRESHOLD_NO_RESIZE = -1;
    protected static final int THRESHOLD_RESIZING = -2;
    protected volatile int threshold;
    protected static final VarHandle THRESHOLD_HANDLE = ConcurrentUtil.getVarHandle(ConcurrentLong2LongChainedHashTable.class, "threshold", Integer.TYPE);

    protected final int getThresholdAcquire() {
        return THRESHOLD_HANDLE.getAcquire(this);
    }

    protected final int getThresholdVolatile() {
        return THRESHOLD_HANDLE.getVolatile(this);
    }

    protected final void setThresholdPlain(int threshold) {
        THRESHOLD_HANDLE.set(this, threshold);
    }

    protected final void setThresholdRelease(int threshold) {
        THRESHOLD_HANDLE.setRelease(this, threshold);
    }

    protected final void setThresholdVolatile(int threshold) {
        THRESHOLD_HANDLE.setVolatile(this, threshold);
    }

    protected final int compareExchangeThresholdVolatile(int expect, int update) {
        return THRESHOLD_HANDLE.compareAndExchange(this, expect, update);
    }

    public ConcurrentLong2LongChainedHashTable() {
        this(16, 0.75f);
    }

    protected static int getTargetThreshold(int capacity, float loadFactor) {
        double ret = (double)capacity * (double)loadFactor;
        if (Double.isInfinite(ret) || ret >= 2.147483646E9) {
            return -1;
        }
        return (int)Math.ceil(ret);
    }

    protected static int getCapacityFor(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
        if (capacity >= 0x40000000) {
            return 0x40000000;
        }
        return IntegerUtil.roundCeilLog2(capacity);
    }

    protected ConcurrentLong2LongChainedHashTable(int capacity, float loadFactor) {
        int tableSize = ConcurrentLong2LongChainedHashTable.getCapacityFor(capacity);
        if ((double)loadFactor <= 0.0 || !Float.isFinite(loadFactor)) {
            throw new IllegalArgumentException("Invalid load factor: " + loadFactor);
        }
        if (tableSize == 0x40000000) {
            this.setThresholdPlain(-1);
        } else {
            this.setThresholdPlain(ConcurrentLong2LongChainedHashTable.getTargetThreshold(tableSize, loadFactor));
        }
        this.loadFactor = loadFactor;
        this.table = new TableEntry[tableSize];
        this.nextTable = this.table;
    }

    public static ConcurrentLong2LongChainedHashTable createWithCapacity(int capacity) {
        return ConcurrentLong2LongChainedHashTable.createWithCapacity(capacity, 0.75f);
    }

    public static ConcurrentLong2LongChainedHashTable createWithCapacity(int capacity, float loadFactor) {
        return new ConcurrentLong2LongChainedHashTable(capacity, loadFactor);
    }

    public static ConcurrentLong2LongChainedHashTable createWithExpected(int expected) {
        return ConcurrentLong2LongChainedHashTable.createWithExpected(expected, 0.75f);
    }

    public static ConcurrentLong2LongChainedHashTable createWithExpected(int expected, float loadFactor) {
        double capacity = Math.ceil((double)expected / (double)loadFactor);
        if (!Double.isFinite(capacity)) {
            throw new IllegalArgumentException("Invalid load factor");
        }
        if (capacity > 2.147483647E9) {
            capacity = 2.147483647E9;
        }
        return ConcurrentLong2LongChainedHashTable.createWithCapacity((int)capacity, loadFactor);
    }

    protected static int getHash(long key) {
        return (int)HashUtil.mix(key);
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    protected static TableEntry getAtIndexAcquire(TableEntry[] table, int index) {
        return TableEntry.TABLE_ENTRY_ARRAY_HANDLE.getVolatile(table, index);
    }

    protected static void setAtIndexRelease(TableEntry[] table, int index, TableEntry value) {
        TableEntry.TABLE_ENTRY_ARRAY_HANDLE.setRelease(table, index, value);
    }

    protected static void setAtIndexVolatile(TableEntry[] table, int index, TableEntry value) {
        TableEntry.TABLE_ENTRY_ARRAY_HANDLE.setVolatile(table, index, value);
    }

    protected static TableEntry compareAndExchangeAtIndexVolatile(TableEntry[] table, int index, TableEntry expect, TableEntry update) {
        return TableEntry.TABLE_ENTRY_ARRAY_HANDLE.compareAndExchange(table, index, expect, update);
    }

    protected TableEntry[] fetchNewTable(TableEntry[] expectedCurr) {
        TableEntry[] candidate = this.nextTable;
        TableEntry[] current = this.table;
        return expectedCurr == current ? candidate : current;
    }

    protected final TableEntry getNode(long key) {
        TableEntry node;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        while (true) {
            if ((node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, hash & table.length - 1)) == null) {
                return node;
            }
            if (node != RESIZE_NODE) break;
            table = this.fetchNewTable(table);
        }
        while (node != null) {
            if (node.key == key) {
                return node;
            }
            node = node.getNextVolatile();
        }
        return node;
    }

    public long get(long key) {
        TableEntry node = this.getNode(key);
        return node == null ? 0L : node.getValueVolatile();
    }

    public long getOrDefault(long key, long defaultValue) {
        TableEntry node = this.getNode(key);
        return node == null ? defaultValue : node.getValueVolatile();
    }

    public boolean containsKey(long key) {
        return this.getNode(key) != null;
    }

    public boolean containsValue(long value) {
        TableEntry node;
        NodeIterator iterator = new NodeIterator(this);
        while ((node = iterator.findNext()) != null) {
            if (node.getValueAcquire() != value) continue;
            return true;
        }
        return false;
    }

    public int size() {
        long ret = this.size.get();
        if (ret < 0L) {
            return 0;
        }
        if (ret > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)ret;
    }

    public boolean isEmpty() {
        return this.size.get() <= 0L;
    }

    protected final void addSize(long count) {
        long sum = this.size.addAndGet(count);
        int threshold = this.getThresholdAcquire();
        if ((long)threshold < 0L) {
            return;
        }
        if (sum < (long)threshold) {
            return;
        }
        if (threshold != this.compareExchangeThresholdVolatile(threshold, -2)) {
            return;
        }
        this.resize(sum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(long sum) {
        int capacity;
        double targetD = (double)sum / (double)this.loadFactor + 1.0;
        if (targetD >= 1.073741824E9) {
            capacity = 0x40000000;
        } else {
            capacity = (int)Math.ceil(targetD);
            capacity = IntegerUtil.roundCeilLog2(capacity);
            capacity = Math.min(capacity, 0x40000000);
        }
        TableEntry[] newTable = new TableEntry[capacity];
        TableEntry[] oldTable = this.table;
        this.nextTable = newTable;
        int capOldShift = IntegerUtil.floorLog2(oldTable.length);
        int capDiffShift = IntegerUtil.floorLog2(capacity) - capOldShift;
        if (capDiffShift == 0) {
            throw new IllegalStateException("Resizing to same size");
        }
        Object[] work = new TableEntry[1 << capDiffShift];
        int len = oldTable.length;
        block3: for (int i = 0; i < len; ++i) {
            TableEntry binNode = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(oldTable, i);
            while (binNode != null || null != (binNode = ConcurrentLong2LongChainedHashTable.compareAndExchangeAtIndexVolatile(oldTable, i, null, RESIZE_NODE))) {
                TableEntry tableEntry = binNode;
                synchronized (tableEntry) {
                    TableEntry tableEntry2 = binNode;
                    binNode = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(oldTable, i);
                    if (tableEntry2 != binNode) {
                        continue;
                    }
                    TableEntry next = binNode.getNextPlain();
                    if (next == null) {
                        newTable[ConcurrentLong2LongChainedHashTable.getHash((long)binNode.key) & capacity - 1] = binNode;
                    } else {
                        Arrays.fill(work, null);
                        for (TableEntry curr = binNode; curr != null; curr = curr.getNextPlain()) {
                            int newTableIdx = ConcurrentLong2LongChainedHashTable.getHash(curr.key) & capacity - 1;
                            int workIdx = newTableIdx >>> capOldShift;
                            TableEntry replace = new TableEntry(curr.key, curr.getValuePlain());
                            Object workNode = work[workIdx];
                            work[workIdx] = replace;
                            if (workNode == null) {
                                newTable[newTableIdx] = replace;
                                continue;
                            }
                            ((TableEntry)workNode).setNextPlain(replace);
                        }
                    }
                    ConcurrentLong2LongChainedHashTable.setAtIndexRelease(oldTable, i, RESIZE_NODE);
                    continue block3;
                }
            }
        }
        int newThreshold = capacity == 0x40000000 ? -1 : ConcurrentLong2LongChainedHashTable.getTargetThreshold(capacity, this.loadFactor);
        this.table = newTable;
        this.setThresholdVolatile(newThreshold);
    }

    protected final void subSize(long count) {
        this.size.getAndAdd(-count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long put(long key, long value) {
        TableEntry node;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null && null == (node = ConcurrentLong2LongChainedHashTable.compareAndExchangeAtIndexVolatile(table, index, null, new TableEntry(key, value)))) {
                    this.addSize(1L);
                    return 0L;
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                TableEntry tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry tableEntry2 = node;
                    node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            TableEntry prev = null;
            while (true) {
                if (node == null) {
                    prev.setNextRelease(new TableEntry(key, value));
                    // MONITOREXIT @DISABLED, blocks:[1, 4, 6] lbl24 : MonitorExitStatement: MONITOREXIT : var9_7
                    this.addSize(1L);
                    return 0L;
                }
                if (node.key == key) {
                    long ret = node.getValuePlain();
                    node.setValueVolatile(value);
                    return ret;
                }
                prev = node;
                node = node.getNextPlain();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long putIfAbsent(long key, long value) {
        TableEntry node;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null && null == (node = ConcurrentLong2LongChainedHashTable.compareAndExchangeAtIndexVolatile(table, index, null, new TableEntry(key, value)))) {
                    this.addSize(1L);
                    return 0L;
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                if (node.key == key) {
                    return node.getValueVolatile();
                }
                TableEntry tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry tableEntry2 = node;
                    node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            TableEntry prev = null;
            while (true) {
                if (node == null) {
                    prev.setNextRelease(new TableEntry(key, value));
                    // MONITOREXIT @DISABLED, blocks:[1, 4, 6] lbl26 : MonitorExitStatement: MONITOREXIT : var9_7
                    this.addSize(1L);
                    return 0L;
                }
                if (node.key == key) {
                    return node.getValuePlain();
                }
                prev = node;
                node = node.getNextPlain();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long replace(long key, long value) {
        TableEntry node;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null) {
                    return 0L;
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                TableEntry tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry tableEntry2 = node;
                    node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            while (node != null) {
                if (node.key == key) {
                    long ret = node.getValuePlain();
                    node.setValueVolatile(value);
                    return ret;
                }
                node = node.getNextPlain();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long replace(long key, long expect, long update) {
        TableEntry node;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null) {
                    return 0L;
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                TableEntry tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry tableEntry2 = node;
                    node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            while (node != null) {
                if (node.key == key) {
                    long ret = node.getValuePlain();
                    if (ret != expect) {
                        return ret;
                    }
                    node.setValueVolatile(update);
                    return ret;
                }
                node = node.getNextPlain();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long remove(long key) {
        long ret;
        boolean removed;
        TableEntry node;
        int index;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null) {
                    return 0L;
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                removed = false;
                ret = 0L;
                TableEntry tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry prev = null;
        for (node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                ret = node.getValuePlain();
                removed = true;
                if (prev == null) {
                    ConcurrentLong2LongChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                    break;
                }
                prev.setNextRelease(node.getNextPlain());
                break;
            }
            prev = node;
        }
        // MONITOREXIT : tableEntry
        if (!removed) return ret;
        this.subSize(1L);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long remove(long key, long expect) {
        long ret;
        boolean removed;
        TableEntry node;
        int index;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null) {
                    return 0L;
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                removed = false;
                ret = 0L;
                TableEntry tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry prev = null;
        for (node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                ret = node.getValuePlain();
                if (ret != expect) break;
                removed = true;
                if (prev == null) {
                    ConcurrentLong2LongChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                    break;
                }
                prev.setNextRelease(node.getNextPlain());
                break;
            }
            prev = node;
        }
        // MONITOREXIT : tableEntry
        if (!removed) return ret;
        this.subSize(1L);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long removeIf(long key, LongPredicate predicate) {
        long ret;
        boolean removed;
        TableEntry node;
        int index;
        Objects.requireNonNull(predicate, "Predicate may not be null");
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null) {
                    return 0L;
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                removed = false;
                ret = 0L;
                TableEntry tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry prev = null;
        for (node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                ret = node.getValuePlain();
                if (!predicate.test(ret)) break;
                removed = true;
                if (prev == null) {
                    ConcurrentLong2LongChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                    break;
                }
                prev.setNextRelease(node.getNextPlain());
                break;
            }
            prev = node;
        }
        // MONITOREXIT : tableEntry
        if (!removed) return ret;
        this.subSize(1L);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long addTo(long key, long increment, long defaultValue) {
        TableEntry node;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null && null == (node = ConcurrentLong2LongChainedHashTable.compareAndExchangeAtIndexVolatile(table, index, null, new TableEntry(key, defaultValue)))) {
                    this.addSize(1L);
                    return defaultValue;
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                TableEntry tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry tableEntry2 = node;
                    node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            TableEntry prev = null;
            while (true) {
                if (node == null) {
                    prev.setNextRelease(new TableEntry(key, defaultValue));
                    // MONITOREXIT @DISABLED, blocks:[1, 4, 6] lbl24 : MonitorExitStatement: MONITOREXIT : var11_8
                    this.addSize(1L);
                    return defaultValue;
                }
                if (node.key == key) {
                    long ret = node.getValuePlain() + increment;
                    node.setValueVolatile(ret);
                    return ret;
                }
                prev = node;
                node = node.getNextPlain();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long decFrom(long key, long decrement, long threshold) {
        long ret;
        boolean found;
        boolean removed;
        TableEntry node;
        int index;
        int hash = ConcurrentLong2LongChainedHashTable.getHash(key);
        TableEntry[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index);
            while (true) {
                if (node == null) {
                    throw new IllegalStateException();
                }
                if (node == RESIZE_NODE) {
                    table = this.fetchNewTable(table);
                    continue block2;
                }
                removed = false;
                found = false;
                ret = 0L;
                TableEntry tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry prev = null;
        for (node = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                found = true;
                ret = node.getValuePlain() - decrement;
                if (ret <= threshold) {
                    removed = true;
                    if (prev == null) {
                        ConcurrentLong2LongChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                        break;
                    }
                    prev.setNextRelease(node.getNextPlain());
                    break;
                }
                node.setValueRelease(ret);
                break;
            }
            prev = node;
        }
        // MONITOREXIT : tableEntry
        if (!found) {
            throw new IllegalStateException();
        }
        if (!removed) return ret;
        this.subSize(1L);
        return ret;
    }

    public void clear() {
        TableEntry node;
        NodeIterator nodeIterator = new NodeIterator(this);
        while ((node = nodeIterator.findNext()) != null) {
            this.remove(node.key);
        }
    }

    public Iterator<TableEntry> entryIterator() {
        return new EntryIterator(this);
    }

    @Override
    public final Iterator<TableEntry> iterator() {
        return this.entryIterator();
    }

    public PrimitiveIterator.OfLong keyIterator() {
        return new KeyIterator(this);
    }

    public PrimitiveIterator.OfLong valueIterator() {
        return new ValueIterator(this);
    }

    public static final class TableEntry {
        private static final VarHandle TABLE_ENTRY_ARRAY_HANDLE = ConcurrentUtil.getArrayHandle(TableEntry[].class);
        private final long key;
        private volatile long value;
        private static final VarHandle VALUE_HANDLE = ConcurrentUtil.getVarHandle(TableEntry.class, "value", Long.TYPE);
        private volatile TableEntry next;
        private static final VarHandle NEXT_HANDLE = ConcurrentUtil.getVarHandle(TableEntry.class, "next", TableEntry.class);

        private long getValuePlain() {
            return VALUE_HANDLE.get(this);
        }

        private long getValueAcquire() {
            return VALUE_HANDLE.getAcquire(this);
        }

        private long getValueVolatile() {
            return VALUE_HANDLE.getVolatile(this);
        }

        private void setValuePlain(long value) {
            VALUE_HANDLE.set(this, value);
        }

        private void setValueRelease(long value) {
            VALUE_HANDLE.setRelease(this, value);
        }

        private void setValueVolatile(long value) {
            VALUE_HANDLE.setVolatile(this, value);
        }

        private TableEntry getNextPlain() {
            return NEXT_HANDLE.get(this);
        }

        private TableEntry getNextVolatile() {
            return NEXT_HANDLE.getVolatile(this);
        }

        private void setNextPlain(TableEntry next) {
            NEXT_HANDLE.set(this, next);
        }

        private void setNextRelease(TableEntry next) {
            NEXT_HANDLE.setRelease(this, next);
        }

        private void setNextVolatile(TableEntry next) {
            NEXT_HANDLE.setVolatile(this, next);
        }

        public TableEntry(long key, long value) {
            this.key = key;
            this.setValuePlain(value);
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.getValueVolatile();
        }
    }

    protected static class NodeIterator {
        protected ConcurrentLong2LongChainedHashTable map;
        protected TableEntry[] currentTable;
        protected ResizeChain resizeChain;
        protected TableEntry last;
        protected int nextBin;
        protected int increment;

        protected NodeIterator(ConcurrentLong2LongChainedHashTable map) {
            this.map = map;
            this.currentTable = map.table;
            this.increment = 1;
        }

        private TableEntry[] pullResizeChain(int index) {
            ResizeChain prevChain;
            ResizeChain resizeChain = this.resizeChain;
            if (resizeChain == null) {
                this.currentTable = null;
                return null;
            }
            this.resizeChain = prevChain = resizeChain.prev;
            if (prevChain == null) {
                this.currentTable = null;
                return null;
            }
            TableEntry[] newTable = prevChain.table;
            int newIdx = index & newTable.length - 1;
            ResizeChain nextPrevChain = prevChain.prev;
            int increment = nextPrevChain == null ? 1 : nextPrevChain.table.length;
            this.increment = increment;
            this.nextBin = newIdx += increment;
            this.currentTable = newTable;
            return newTable;
        }

        private TableEntry[] pushResizeChain(TableEntry[] table) {
            ResizeChain chain = this.resizeChain;
            if (chain == null) {
                ResizeChain currChain;
                TableEntry[] nextTable = this.map.fetchNewTable(table);
                ResizeChain oldChain = new ResizeChain(table, null, null);
                oldChain.next = currChain = new ResizeChain(nextTable, oldChain, null);
                this.increment = table.length;
                this.resizeChain = currChain;
                this.currentTable = nextTable;
                return nextTable;
            }
            ResizeChain currChain = chain.next;
            if (currChain == null) {
                TableEntry[] ret = this.map.fetchNewTable(table);
                chain.next = currChain = new ResizeChain(ret, chain, null);
                this.increment = table.length;
                this.resizeChain = currChain;
                this.currentTable = ret;
                return ret;
            }
            this.increment = table.length;
            this.resizeChain = currChain;
            this.currentTable = currChain.table;
            return currChain.table;
        }

        protected final TableEntry findNext() {
            TableEntry entry;
            TableEntry next;
            TableEntry last = this.last;
            if (last != null && (next = last.getNextVolatile()) != null) {
                this.last = next;
                return next;
            }
            TableEntry[] table = this.currentTable;
            if (table == null) {
                return null;
            }
            int idx = this.nextBin;
            int increment = this.increment;
            while (true) {
                if (idx >= table.length) {
                    table = this.pullResizeChain(idx);
                    idx = this.nextBin;
                    increment = this.increment;
                    if (table != null) continue;
                    this.last = null;
                    return null;
                }
                entry = ConcurrentLong2LongChainedHashTable.getAtIndexAcquire(table, idx);
                if (entry == null) {
                    idx += increment;
                    continue;
                }
                if (entry != RESIZE_NODE) break;
                table = this.pushResizeChain(table);
                increment = this.increment;
            }
            this.last = entry;
            this.nextBin = idx + increment;
            return entry;
        }

        protected static final class ResizeChain {
            public final TableEntry[] table;
            public final ResizeChain prev;
            public ResizeChain next;

            public ResizeChain(TableEntry[] table, ResizeChain prev, ResizeChain next) {
                this.table = table;
                this.prev = prev;
                this.next = next;
            }
        }
    }

    protected static final class EntryIterator
    extends BaseIteratorImpl<TableEntry> {
        public EntryIterator(ConcurrentLong2LongChainedHashTable map) {
            super(map);
        }

        @Override
        public TableEntry next() throws NoSuchElementException {
            return this.nextNode();
        }

        @Override
        public void forEachRemaining(Consumer<? super TableEntry> action) {
            Objects.requireNonNull(action, "Action may not be null");
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }
    }

    protected static final class KeyIterator
    extends BaseLongIteratorImpl {
        public KeyIterator(ConcurrentLong2LongChainedHashTable map) {
            super(map);
        }

        @Override
        public long nextLong() {
            return this.nextNode().key;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            Objects.requireNonNull(action, "Action may not be null");
            while (this.hasNext()) {
                action.accept(this.nextLong());
            }
        }
    }

    protected static final class ValueIterator
    extends BaseLongIteratorImpl {
        public ValueIterator(ConcurrentLong2LongChainedHashTable map) {
            super(map);
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            return this.nextNode().getValueVolatile();
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            Objects.requireNonNull(action, "Action may not be null");
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }
    }

    protected static abstract class BaseIteratorImpl<T>
    extends NodeIterator
    implements Iterator<T> {
        protected final ConcurrentLong2LongChainedHashTable map;
        protected TableEntry lastReturned;
        protected TableEntry nextToReturn;

        protected BaseIteratorImpl(ConcurrentLong2LongChainedHashTable map) {
            super(map);
            this.map = map;
        }

        @Override
        public final boolean hasNext() {
            if (this.nextToReturn != null) {
                return true;
            }
            this.nextToReturn = this.findNext();
            return this.nextToReturn != null;
        }

        protected final TableEntry nextNode() throws NoSuchElementException {
            TableEntry ret = this.nextToReturn;
            if (ret != null) {
                this.lastReturned = ret;
                this.nextToReturn = null;
                return ret;
            }
            ret = this.findNext();
            if (ret != null) {
                this.lastReturned = ret;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            TableEntry lastReturned = this.lastReturned;
            if (lastReturned == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = null;
            this.map.remove(lastReturned.key);
        }

        @Override
        public abstract T next() throws NoSuchElementException;

        @Override
        public abstract void forEachRemaining(Consumer<? super T> var1);
    }

    protected static abstract class BaseLongIteratorImpl
    extends BaseIteratorImpl<Long>
    implements PrimitiveIterator.OfLong {
        protected BaseLongIteratorImpl(ConcurrentLong2LongChainedHashTable map) {
            super(map);
        }

        @Override
        public final Long next() {
            return this.nextLong();
        }

        @Override
        public final void forEachRemaining(Consumer<? super Long> action) {
            Objects.requireNonNull(action, "Action may not be null");
            if (action instanceof LongConsumer) {
                LongConsumer longConsumer = (LongConsumer)((Object)action);
                this.forEachRemaining(longConsumer);
                return;
            }
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }

        @Override
        public abstract long nextLong() throws NoSuchElementException;

        @Override
        public abstract void forEachRemaining(LongConsumer var1);
    }
}

