/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.bedrock.model;

import com.google.gson.JsonObject;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.util.Expirable;
import net.raphimc.minecraftauth.util.jwt.Jwt;

public final class MinecraftCertificateChain
implements Expirable {
    private final String mojangJwt;
    private final String identityJwt;
    private final AtomicReference<Object> parsedMojangJwt = new AtomicReference();
    private final AtomicReference<Object> parsedIdentityJwt = new AtomicReference();

    public static MinecraftCertificateChain fromJson(JsonObject json) {
        return MinecraftCertificateChain.fromJson(new GsonObject(json));
    }

    public static MinecraftCertificateChain fromJson(GsonObject json) {
        return new MinecraftCertificateChain(json.reqString("mojangJwt"), json.reqString("identityJwt"));
    }

    public static JsonObject toJson(MinecraftCertificateChain certificateChain) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", (Number)1);
        json.addProperty("mojangJwt", certificateChain.mojangJwt);
        json.addProperty("identityJwt", certificateChain.identityJwt);
        return json;
    }

    @Override
    public long getExpireTimeMs() {
        return Math.min(this.getParsedMojangJwt().getExpireTimeMs(), this.getParsedIdentityJwt().getExpireTimeMs());
    }

    public String getIdentityDisplayName() {
        return this.getParsedIdentityJwt().getPayload().reqObject("extraData").reqString("displayName");
    }

    public String getIdentityXuid() {
        return this.getParsedIdentityJwt().getPayload().reqObject("extraData").reqString("XUID");
    }

    public UUID getIdentityUuid() {
        return UUID.fromString(this.getParsedIdentityJwt().getPayload().reqObject("extraData").reqString("identity"));
    }

    @Generated
    public MinecraftCertificateChain(String mojangJwt, String identityJwt) {
        this.mojangJwt = mojangJwt;
        this.identityJwt = identityJwt;
    }

    @Generated
    public String getMojangJwt() {
        return this.mojangJwt;
    }

    @Generated
    public String getIdentityJwt() {
        return this.identityJwt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinecraftCertificateChain)) {
            return false;
        }
        MinecraftCertificateChain other = (MinecraftCertificateChain)o;
        String this$mojangJwt = this.getMojangJwt();
        String other$mojangJwt = other.getMojangJwt();
        if (this$mojangJwt == null ? other$mojangJwt != null : !this$mojangJwt.equals(other$mojangJwt)) {
            return false;
        }
        String this$identityJwt = this.getIdentityJwt();
        String other$identityJwt = other.getIdentityJwt();
        return !(this$identityJwt == null ? other$identityJwt != null : !this$identityJwt.equals(other$identityJwt));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mojangJwt = this.getMojangJwt();
        result = result * 59 + ($mojangJwt == null ? 43 : $mojangJwt.hashCode());
        String $identityJwt = this.getIdentityJwt();
        result = result * 59 + ($identityJwt == null ? 43 : $identityJwt.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MinecraftCertificateChain(mojangJwt=" + this.getMojangJwt() + ", identityJwt=" + this.getIdentityJwt() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Jwt getParsedMojangJwt() {
        Object $value = this.parsedMojangJwt.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.parsedMojangJwt;
            synchronized (atomicReference) {
                $value = this.parsedMojangJwt.get();
                if ($value == null) {
                    Jwt actualValue = Jwt.parse(this.mojangJwt);
                    $value = actualValue == null ? this.parsedMojangJwt : actualValue;
                    this.parsedMojangJwt.set($value);
                }
            }
        }
        return (Jwt)($value == this.parsedMojangJwt ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Jwt getParsedIdentityJwt() {
        Object $value = this.parsedIdentityJwt.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.parsedIdentityJwt;
            synchronized (atomicReference) {
                $value = this.parsedIdentityJwt.get();
                if ($value == null) {
                    Jwt actualValue = Jwt.parse(this.identityJwt);
                    $value = actualValue == null ? this.parsedIdentityJwt : actualValue;
                    this.parsedIdentityJwt.set($value);
                }
            }
        }
        return (Jwt)($value == this.parsedIdentityJwt ? null : $value);
    }
}

