/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.imaginary;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.imaginary.Complexf;

@ParametersAreNonnullByDefault
public class ImmutableComplexf
extends Complexf {
    private static final long serialVersionUID = 1L;
    private final float x;
    private final float y;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableComplexf(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    @Nonnull
    public Complexf add(float x, float y) {
        return Complexf.from(this.x + x, this.y + y);
    }

    @Override
    @Nonnull
    public Complexf sub(float x, float y) {
        return Complexf.from(this.x - x, this.y - y);
    }

    @Override
    @Nonnull
    public Complexf mul(float a) {
        return Complexf.from(this.x * a, this.y * a);
    }

    @Override
    @Nonnull
    public Complexf mul(float x, float y) {
        return Complexf.from(this.x * x - this.y * y, this.x * y + this.y * x);
    }

    @Override
    @Nonnull
    public Complexf div(float a) {
        return Complexf.from(this.x / a, this.y / a);
    }

    @Override
    @Nonnull
    public Complexf div(float x, float y) {
        float d = x * x + y * y;
        return Complexf.from((this.x * x + this.y * y) / d, (this.y * x - this.x * y) / d);
    }

    @Override
    public float dot(Complexf c) {
        return this.dot(c.getX(), c.getY());
    }

    @Override
    public float dot(double x, double y) {
        return this.dot((float)x, (float)y);
    }

    @Override
    public float dot(float x, float y) {
        return this.x * x + this.y * y;
    }

    @Override
    @Nonnull
    public Complexf conjugate() {
        return Complexf.from(this.x, -this.y);
    }

    @Override
    @Nonnull
    public Complexf invert() {
        float lengthSquared = this.lengthSquared();
        if (Math.abs(lengthSquared) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot invert a complex of length zero");
        }
        return this.conjugate().div(lengthSquared);
    }

    @Override
    @Nonnull
    public Complexf normalize() {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero complex");
        }
        return Complexf.from(this.x / length, this.y / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Complexf)) {
            return false;
        }
        Complexf complex = (Complexf)o;
        if (Float.compare(complex.getX(), this.x) != 0) {
            return false;
        }
        return Float.compare(complex.getY(), this.y) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0f ? Float.hashCode(this.x) : 0;
            this.hashCode = 31 * result + (this.y != 0.0f ? Float.hashCode(this.y) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

