/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.v818.Bedrock_v818;
import org.cloudburstmc.protocol.bedrock.codec.v819.Bedrock_v819;
import org.cloudburstmc.protocol.bedrock.codec.v827.Bedrock_v827;
import org.cloudburstmc.protocol.bedrock.codec.v844.Bedrock_v844;
import org.cloudburstmc.protocol.bedrock.codec.v859.Bedrock_v859;
import org.geysermc.geyser.api.util.MinecraftVersion;
import org.geysermc.geyser.impl.MinecraftVersionImpl;
import org.geysermc.geyser.network.CodecProcessor;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntList;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodec;
import org.geysermc.mcprotocollib.protocol.codec.PacketCodec;

public final class GameProtocol {
    private static final List<BedrockCodec> SUPPORTED_BEDROCK_CODECS = new ArrayList<BedrockCodec>();
    public static final IntList SUPPORTED_BEDROCK_PROTOCOLS = new IntArrayList();
    public static final List<MinecraftVersion> SUPPORTED_BEDROCK_VERSIONS = new ArrayList<MinecraftVersion>();
    public static final int DEFAULT_BEDROCK_PROTOCOL;
    public static final String DEFAULT_BEDROCK_VERSION;
    private static final PacketCodec DEFAULT_JAVA_CODEC;

    private static void register(BedrockCodec codec, String ... minecraftVersions) {
        codec = CodecProcessor.processCodec(codec);
        SUPPORTED_BEDROCK_CODECS.add(codec);
        SUPPORTED_BEDROCK_PROTOCOLS.add(codec.getProtocolVersion());
        for (String version : minecraftVersions) {
            SUPPORTED_BEDROCK_VERSIONS.add(new MinecraftVersionImpl(version, codec.getProtocolVersion()));
        }
    }

    private static void register(BedrockCodec codec) {
        GameProtocol.register(codec, codec.getMinecraftVersion());
    }

    public static @Nullable BedrockCodec getBedrockCodec(int protocolVersion) {
        for (BedrockCodec packetCodec : SUPPORTED_BEDROCK_CODECS) {
            if (packetCodec.getProtocolVersion() != protocolVersion) continue;
            return packetCodec;
        }
        return null;
    }

    public static boolean is1_21_100(GeyserSession session) {
        return session.protocolVersion() == Bedrock_v827.CODEC.getProtocolVersion();
    }

    public static boolean is1_21_110orHigher(GeyserSession session) {
        return GameProtocol.is1_21_110orHigher(session.protocolVersion());
    }

    public static boolean is1_21_110orHigher(int protocolVersion) {
        return protocolVersion >= Bedrock_v844.CODEC.getProtocolVersion();
    }

    public static List<String> getJavaVersions() {
        return List.of(DEFAULT_JAVA_CODEC.getMinecraftVersion());
    }

    public static int getJavaProtocolVersion() {
        return DEFAULT_JAVA_CODEC.getProtocolVersion();
    }

    public static String getJavaMinecraftVersion() {
        return "1.21.10";
    }

    public static String getAllSupportedBedrockVersions() {
        return SUPPORTED_BEDROCK_VERSIONS.stream().map(MinecraftVersion::versionString).collect(Collectors.joining(", "));
    }

    public static String getAllSupportedJavaVersions() {
        return String.join((CharSequence)", ", GameProtocol.getJavaVersions());
    }

    private GameProtocol() {
    }

    static {
        DEFAULT_JAVA_CODEC = MinecraftCodec.CODEC;
        GameProtocol.register(Bedrock_v818.CODEC, "1.21.90", "1.21.91", "1.21.92");
        GameProtocol.register(Bedrock_v819.CODEC, "1.21.93", "1.21.94");
        GameProtocol.register(Bedrock_v827.CODEC, "1.21.100", "1.21.101");
        GameProtocol.register(Bedrock_v844.CODEC, "1.21.111", "1.21.112", "1.21.113", "1.21.114");
        GameProtocol.register(Bedrock_v859.CODEC, "1.21.120", "1.21.121", "1.21.122", "1.21.123");
        GameProtocol.register(Bedrock_v859.CODEC.toBuilder().protocolVersion(860).minecraftVersion("1.21.124").build());
        MinecraftVersion latestBedrock = SUPPORTED_BEDROCK_VERSIONS.get(SUPPORTED_BEDROCK_VERSIONS.size() - 1);
        DEFAULT_BEDROCK_VERSION = latestBedrock.versionString();
        DEFAULT_BEDROCK_PROTOCOL = latestBedrock.protocolVersion();
    }
}

