/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolException;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.GeyserBedrockPeer;
import org.geysermc.geyser.network.netty.proxy.ProxyProtocolDecoder;

@ChannelHandler.Sharable
public class ProxyServerHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ProxyServerHandler.class);
    public static final String NAME = "rak-proxy-server-handler";

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) {
        ByteBuf content = (ByteBuf)packet.content();
        GeyserBedrockPeer peer = (GeyserBedrockPeer)ctx.pipeline().get("bedrock-peer");
        int detectedVersion = peer != null ? -1 : ProxyProtocolDecoder.findVersion(content);
        InetSocketAddress presentAddress = GeyserImpl.getInstance().getGeyserServer().getProxiedAddresses().get(packet.sender());
        if (presentAddress == null && detectedVersion == -1) {
            return;
        }
        if (presentAddress == null) {
            HAProxyMessage decoded;
            try {
                decoded = ProxyProtocolDecoder.decode(content, detectedVersion);
                if (decoded == null) {
                    return;
                }
            }
            catch (HAProxyProtocolException e) {
                log.debug("{} sent malformed PROXY header", (Object)packet.sender(), (Object)e);
                return;
            }
            presentAddress = new InetSocketAddress(decoded.sourceAddress(), decoded.sourcePort());
            log.debug("Got PROXY header: (from {}) {}", (Object)packet.sender(), (Object)presentAddress);
            GeyserImpl.getInstance().getGeyserServer().getProxiedAddresses().put((InetSocketAddress)packet.sender(), presentAddress);
        } else {
            log.trace("Reusing PROXY header: (from {}) {}", (Object)packet.sender(), (Object)presentAddress);
        }
        ctx.fireChannelRead((Object)packet.retain());
    }
}

