/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.skin.ImageData;
import org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerSkinPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.skin.Cape;
import org.geysermc.geyser.api.skin.Skin;
import org.geysermc.geyser.api.skin.SkinData;
import org.geysermc.geyser.api.skin.SkinGeometry;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.JsonUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.ResolvableProfile;

public class SkinManager {
    private static final Cache<ResolvableProfile, GameProfile> RESOLVED_PROFILES_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    public static final GameProfile EMPTY_PROFILE = new GameProfile((UUID)null, null);
    public static final ResolvableProfile EMPTY_RESOLVABLE_PROFILE = new ResolvableProfile(EMPTY_PROFILE, null, null, null, null, false);
    static final String GEOMETRY = new String(FileUtils.readAllBytes("bedrock/geometries/geo.json"), StandardCharsets.UTF_8);

    public static PlayerListPacket.Entry buildCachedEntry(GeyserSession session, AvatarEntity playerEntity) {
        GameProfileData data = GameProfileData.from(playerEntity);
        Skin skin = null;
        Cape cape = null;
        SkinGeometry geometry = SkinGeometry.WIDE;
        if (data != null) {
            skin = SkinProvider.getCachedSkin(data.skinUrl());
            cape = SkinProvider.getCachedCape(data.capeUrl());
            SkinGeometry skinGeometry = geometry = data.isAlex() ? SkinGeometry.SLIM : SkinGeometry.WIDE;
        }
        if (skin == null || cape == null) {
            SkinData fallbackSkinData = SkinProvider.determineFallbackSkinData(playerEntity.getUuid());
            if (skin == null) {
                skin = fallbackSkinData.skin();
                geometry = fallbackSkinData.geometry();
            }
            if (cape == null) {
                cape = fallbackSkinData.cape();
            }
        }
        Color color = session.getWaypointCache().getWaypointColor(playerEntity.getUuid()).orElse(Color.WHITE);
        return SkinManager.buildEntryManually(session, playerEntity.getUuid(), playerEntity.getUsername(), playerEntity.getGeyserId(), skin, cape, geometry, color);
    }

    public static PlayerListPacket.Entry buildEntryManually(GeyserSession session, UUID uuid, String username, long geyserId, Skin skin, Cape cape, SkinGeometry geometry, Color color) {
        SerializedSkin serializedSkin = SkinManager.getSkin(session, skin.textureUrl(), skin, cape, geometry);
        String xuid = "";
        GeyserSession playerSession = GeyserImpl.getInstance().connectionByUuid(uuid);
        if (playerSession != null) {
            xuid = playerSession.getAuthData().xuid();
        } else if (uuid.version() == 0) {
            xuid = Long.toString(uuid.getLeastSignificantBits());
        }
        PlayerListPacket.Entry entry = session.getPlayerEntity().getUuid().equals(uuid) ? new PlayerListPacket.Entry(session.getAuthData().uuid()) : new PlayerListPacket.Entry(uuid);
        entry.setName(username);
        entry.setEntityId(geyserId);
        entry.setSkin(serializedSkin);
        entry.setXuid(xuid);
        entry.setPlatformChatId("");
        entry.setTeacher(false);
        entry.setTrustedSkin(true);
        entry.setColor(color);
        return entry;
    }

    public static void sendSkinPacket(GeyserSession session, AvatarEntity entity, SkinData skinData) {
        Skin skin = skinData.skin();
        Cape cape = skinData.cape();
        SkinGeometry geometry = skinData.geometry();
        Color color = session.getWaypointCache().getWaypointColor(entity.getUuid()).orElse(Color.WHITE);
        if (entity.getUuid().equals(session.getPlayerEntity().getUuid())) {
            PlayerListPacket.Entry updatedEntry = SkinManager.buildEntryManually(session, entity.getUuid(), entity.getUsername(), entity.getGeyserId(), skin, cape, geometry, color);
            PlayerListPacket playerAddPacket = new PlayerListPacket();
            playerAddPacket.setAction(PlayerListPacket.Action.ADD);
            playerAddPacket.getEntries().add(updatedEntry);
            session.sendUpstreamPacket(playerAddPacket);
        } else {
            PlayerSkinPacket packet = new PlayerSkinPacket();
            packet.setUuid(entity.getUuid());
            packet.setOldSkinName("");
            packet.setNewSkinName(skin.textureUrl());
            packet.setSkin(SkinManager.getSkin(session, skin.textureUrl(), skin, cape, geometry));
            packet.setTrustedSkin(true);
            session.sendUpstreamPacket(packet);
        }
    }

    private static SerializedSkin getSkin(GeyserSession session, String skinId, Skin skin, Cape cape, SkinGeometry geometry) {
        return SerializedSkin.builder().skinId(skinId).skinResourcePatch(geometry.geometryName()).skinData(ImageData.of(skin.skinData())).capeData(ImageData.of(cape.capeData())).geometryData(geometry.geometryData().isBlank() ? GEOMETRY : geometry.geometryData()).premium(true).capeId(cape.capeId()).fullSkinId(skinId).geometryDataEngineVersion(session.getClientData().getGameVersion()).build();
    }

    public static CompletableFuture<GameProfile> resolveProfile(ResolvableProfile profile) {
        GameProfile partial = profile.getProfile();
        if (!profile.isDynamic()) {
            return CompletableFuture.completedFuture(partial);
        }
        if (!partial.getProperties().isEmpty() || partial.getId() == null && partial.getName() == null) {
            String name2 = partial.getName() == null ? "" : partial.getName();
            UUID uuid2 = partial.getName() == null ? EMPTY_UUID : SkinManager.createOfflinePlayerUUID(partial.getName());
            GameProfile completed = new GameProfile(uuid2, name2);
            completed.setProperties(partial.getProperties());
            return CompletableFuture.completedFuture(completed);
        }
        GameProfile cached = (GameProfile)RESOLVED_PROFILES_CACHE.getIfPresent((Object)profile);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        CompletionStage completedProfileFuture = partial.getName() != null ? SkinProvider.requestUUIDFromUsername(partial.getName()).thenApply(uuid -> new GameProfile((UUID)uuid, partial.getName())) : SkinProvider.requestUsernameFromUUID(partial.getId()).thenApply(name -> new GameProfile(partial.getId(), (String)name));
        return ((CompletableFuture)((CompletableFuture)completedProfileFuture).thenCompose(nameAndUUID -> {
            if (nameAndUUID.getId() == null || nameAndUUID.getName() == null) {
                return CompletableFuture.completedFuture(partial);
            }
            return SkinProvider.requestTexturesFromUUID(nameAndUUID.getId()).thenApply(encoded -> {
                if (encoded == null) {
                    return partial;
                }
                ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>();
                properties.add(new GameProfile.Property("textures", (String)encoded));
                nameAndUUID.setProperties(properties);
                return nameAndUUID;
            });
        })).thenApply(resolved -> {
            RESOLVED_PROFILES_CACHE.put((Object)profile, resolved);
            return resolved;
        });
    }

    public static @Nullable GameProfile.Texture getTextureDataFromProfile(GameProfile profile, GameProfile.TextureType type) {
        Map<GameProfile.TextureType, GameProfile.Texture> textures;
        try {
            textures = profile.getTextures(false);
        }
        catch (IllegalStateException e) {
            GeyserImpl.getInstance().getLogger().debug("Could not decode textures from game profile %s, got: %s".formatted(profile, e.getMessage()));
            return null;
        }
        if (textures == null) {
            return null;
        }
        return textures.get((Object)type);
    }

    public static void requestAndHandleSkinAndCape(AvatarEntity entity, GeyserSession session, Consumer<SkinProvider.SkinAndCape> skinAndCapeConsumer) {
        SkinProvider.requestSkinData(entity, session).whenCompleteAsync((skinData, throwable) -> {
            if (skinData == null) {
                if (skinAndCapeConsumer != null) {
                    skinAndCapeConsumer.accept(null);
                }
                return;
            }
            if (skinData.geometry() != null) {
                SkinManager.sendSkinPacket(session, entity, skinData);
            }
            if (skinAndCapeConsumer != null) {
                skinAndCapeConsumer.accept(new SkinProvider.SkinAndCape(skinData.skin(), skinData.cape()));
            }
        });
    }

    public static void handleBedrockSkin(AvatarEntity playerEntity, BedrockClientData clientData) {
        GeyserImpl geyser = GeyserImpl.getInstance();
        if (geyser.config().debugMode()) {
            geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.register", playerEntity.getUsername(), playerEntity.getUuid()));
        }
        try {
            byte[] skinBytes = Base64.getDecoder().decode(clientData.getSkinData().getBytes(StandardCharsets.UTF_8));
            byte[] capeBytes = clientData.getCapeData();
            byte[] geometryNameBytes = Base64.getDecoder().decode(clientData.getGeometryName().getBytes(StandardCharsets.UTF_8));
            byte[] geometryBytes = Base64.getDecoder().decode(clientData.getGeometryData().getBytes(StandardCharsets.UTF_8));
            if (skinBytes.length <= 65536 && !clientData.isPersonaSkin()) {
                SkinProvider.storeBedrockSkin(playerEntity.getUuid(), clientData.getSkinId(), skinBytes);
                SkinProvider.storeBedrockGeometry(playerEntity.getUuid(), geometryNameBytes, geometryBytes);
            } else if (geyser.config().debugMode()) {
                geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.fail", playerEntity.getUsername()));
                geyser.getLogger().debug("The size of '" + playerEntity.getUsername() + "' skin is: " + clientData.getSkinImageWidth() + "x" + clientData.getSkinImageHeight());
            }
            if (!clientData.getCapeId().equals("")) {
                SkinProvider.storeBedrockCape(clientData.getCapeId(), capeBytes);
            }
        }
        catch (Exception e) {
            throw new AssertionError("Failed to cache skin for bedrock user (" + playerEntity.getUsername() + "): ", e);
        }
    }

    public static UUID createOfflinePlayerUUID(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }

    public record GameProfileData(String skinUrl, String capeUrl, boolean isAlex) {
        private static final String DEFAULT_FLOODGATE_STEVE = "https://textures.minecraft.net/texture/31f477eb1a7beee631c2ca64d06f8f68fa93a3386d04452ab27f43acdf1b60cb";

        public static @Nullable GameProfileData from(NbtMap tag) {
            NbtMap properties = tag.getCompound("Properties", null);
            if (properties == null) {
                return null;
            }
            List<NbtMap> textures = properties.getList("textures", NbtType.COMPOUND);
            if (textures.isEmpty()) {
                return null;
            }
            String skinDataValue = textures.get(0).getString("Value", null);
            if (skinDataValue == null) {
                return null;
            }
            try {
                return GameProfileData.loadFromJson(skinDataValue);
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for tag " + String.valueOf(tag));
                if (GeyserImpl.getInstance().config().debugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        public static @Nullable GameProfileData from(AvatarEntity entity) {
            String texturesProperty = entity.getTexturesProperty();
            if (texturesProperty == null) {
                return null;
            }
            try {
                return GameProfileData.loadFromJson(texturesProperty);
            }
            catch (Exception exception) {
                if (entity instanceof SkullPlayerEntity) {
                    SkullPlayerEntity skullEntity = (SkullPlayerEntity)entity;
                    GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for skull at " + String.valueOf(skullEntity.getSkullPosition()) + " with Value: " + texturesProperty);
                } else {
                    GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for " + entity.getUsername() + " with Value: " + texturesProperty);
                }
                if (GeyserImpl.getInstance().config().debugMode()) {
                    exception.printStackTrace();
                }
                return null;
            }
        }

        public static @Nullable GameProfileData loadFromJson(String encodedJson) throws IOException, IllegalArgumentException {
            JsonPrimitive capeUrlNode;
            JsonObject capeTexture;
            JsonElement jsonElement;
            JsonPrimitive skinUrlNode;
            JsonObject skinObject;
            try {
                skinObject = JsonUtils.parseJson(new String(Base64.getDecoder().decode(encodedJson), StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException e) {
                GeyserImpl.getInstance().getLogger().debug("Invalid base64 encoded skin entry: " + encodedJson);
                return null;
            }
            JsonElement jsonElement2 = skinObject.get("textures");
            if (!(jsonElement2 instanceof JsonObject)) {
                return null;
            }
            JsonObject textures = (JsonObject)jsonElement2;
            JsonElement jsonElement3 = textures.get("SKIN");
            if (!(jsonElement3 instanceof JsonObject)) {
                return null;
            }
            JsonObject skinTexture = (JsonObject)jsonElement3;
            JsonElement jsonElement4 = skinTexture.get("url");
            if (!(jsonElement4 instanceof JsonPrimitive) || !(skinUrlNode = (JsonPrimitive)jsonElement4).isString()) {
                return null;
            }
            String skinUrl = skinUrlNode.getAsString().replace("http://", "https://");
            if (DEFAULT_FLOODGATE_STEVE.equals(skinUrl)) {
                return null;
            }
            boolean isAlex = skinTexture.has("metadata");
            String capeUrl = null;
            JsonElement jsonElement5 = textures.get("CAPE");
            if (jsonElement5 instanceof JsonObject && (jsonElement = (capeTexture = (JsonObject)jsonElement5).get("url")) instanceof JsonPrimitive && (capeUrlNode = (JsonPrimitive)jsonElement).isString()) {
                capeUrl = capeUrlNode.getAsString().replace("http://", "https://");
            }
            return new GameProfileData(skinUrl, capeUrl, isAlex);
        }
    }
}

