/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class WeightedList<T> {
    private final List<Entry<T>> entries;

    public WeightedList(ByteBuf in, Function<ByteBuf, T> reader) {
        this.entries = MinecraftTypes.readList(in, input -> new Entry((ByteBuf)input, reader));
    }

    public void write(ByteBuf out, BiConsumer<T, ByteBuf> writer) {
        MinecraftTypes.writeList(out, this.entries, (output, entry) -> entry.write(out, writer));
    }

    public WeightedList<T> with(T value, @NonNegative int weight) {
        this.add(value, weight);
        return this;
    }

    public void add(T value, @NonNegative int weight) {
        this.add(new Entry<T>(value, weight));
    }

    public void add(Entry<T> entry) {
        this.entries.add(entry);
    }

    public Entry<T> get(int index) {
        return this.entries.get(index);
    }

    public boolean contains(T value) {
        for (Entry<T> entry : this.entries) {
            if (!entry.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Entry<T>> getEntries() {
        return this.entries;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightedList)) {
            return false;
        }
        WeightedList other = (WeightedList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Entry<T>> this$entries = this.getEntries();
        List<Entry<T>> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof WeightedList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Entry<T>> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "WeightedList(entries=" + String.valueOf(this.getEntries()) + ")";
    }

    public WeightedList(List<Entry<T>> entries) {
        this.entries = entries;
    }

    public record Entry<T>(T value, @NonNegative int weight) {
        public Entry(ByteBuf in, Function<ByteBuf, T> reader) {
            this(reader.apply(in), MinecraftTypes.readVarInt(in));
        }

        public void write(ByteBuf out, BiConsumer<T, ByteBuf> writer) {
            writer.accept(this.value, out);
            MinecraftTypes.writeVarInt(out, this.weight);
        }
    }
}

