/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatCompletionAction;

public class ClientboundCustomChatCompletionsPacket
implements MinecraftPacket {
    private final ChatCompletionAction action;
    private final String[] entries;

    public ClientboundCustomChatCompletionsPacket(ByteBuf in) {
        this.action = ChatCompletionAction.from(MinecraftTypes.readVarInt(in));
        this.entries = new String[MinecraftTypes.readVarInt(in)];
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = MinecraftTypes.readString(in);
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.action.ordinal());
        MinecraftTypes.writeVarInt(out, this.entries.length);
        for (String entry : this.entries) {
            MinecraftTypes.writeString(out, entry);
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public ChatCompletionAction getAction() {
        return this.action;
    }

    public String[] getEntries() {
        return this.entries;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCustomChatCompletionsPacket)) {
            return false;
        }
        ClientboundCustomChatCompletionsPacket other = (ClientboundCustomChatCompletionsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChatCompletionAction this$action = this.getAction();
        ChatCompletionAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        return Arrays.deepEquals(this.getEntries(), other.getEntries());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundCustomChatCompletionsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChatCompletionAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEntries());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundCustomChatCompletionsPacket(action=" + String.valueOf((Object)this.getAction()) + ", entries=" + Arrays.deepToString(this.getEntries()) + ")";
    }

    public @NonNull ClientboundCustomChatCompletionsPacket withAction(ChatCompletionAction action) {
        return this.action == action ? this : new ClientboundCustomChatCompletionsPacket(action, this.entries);
    }

    public @NonNull ClientboundCustomChatCompletionsPacket withEntries(String[] entries) {
        return this.entries == entries ? this : new ClientboundCustomChatCompletionsPacket(this.action, entries);
    }

    public ClientboundCustomChatCompletionsPacket(ChatCompletionAction action, String[] entries) {
        this.action = action;
        this.entries = entries;
    }
}

