/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundMoveVehiclePacket
implements MinecraftPacket {
    private final Vector3d position;
    private final float yRot;
    private final float xRot;

    public ClientboundMoveVehiclePacket(ByteBuf in) {
        this.position = Vector3d.from(in.readDouble(), in.readDouble(), in.readDouble());
        this.yRot = in.readFloat();
        this.xRot = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeDouble(this.position.getX());
        out.writeDouble(this.position.getY());
        out.writeDouble(this.position.getZ());
        out.writeFloat(this.yRot);
        out.writeFloat(this.xRot);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMoveVehiclePacket)) {
            return false;
        }
        ClientboundMoveVehiclePacket other = (ClientboundMoveVehiclePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getYRot(), other.getYRot()) != 0) {
            return false;
        }
        if (Float.compare(this.getXRot(), other.getXRot()) != 0) {
            return false;
        }
        Vector3d this$position = this.getPosition();
        Vector3d other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundMoveVehiclePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYRot());
        result = result * 59 + Float.floatToIntBits(this.getXRot());
        Vector3d $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundMoveVehiclePacket(position=" + String.valueOf(this.getPosition()) + ", yRot=" + this.getYRot() + ", xRot=" + this.getXRot() + ")";
    }

    public @NonNull ClientboundMoveVehiclePacket withPosition(Vector3d position) {
        return this.position == position ? this : new ClientboundMoveVehiclePacket(position, this.yRot, this.xRot);
    }

    public @NonNull ClientboundMoveVehiclePacket withYRot(float yRot) {
        return this.yRot == yRot ? this : new ClientboundMoveVehiclePacket(this.position, yRot, this.xRot);
    }

    public @NonNull ClientboundMoveVehiclePacket withXRot(float xRot) {
        return this.xRot == xRot ? this : new ClientboundMoveVehiclePacket(this.position, this.yRot, xRot);
    }

    public ClientboundMoveVehiclePacket(Vector3d position, float yRot, float xRot) {
        this.position = position;
        this.yRot = yRot;
        this.xRot = xRot;
    }
}

