/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundSetSimulationDistancePacket
implements MinecraftPacket {
    private final int simulationDistance;

    public ClientboundSetSimulationDistancePacket(ByteBuf in) {
        this.simulationDistance = MinecraftTypes.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.simulationDistance);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetSimulationDistancePacket)) {
            return false;
        }
        ClientboundSetSimulationDistancePacket other = (ClientboundSetSimulationDistancePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSimulationDistance() == other.getSimulationDistance();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetSimulationDistancePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSimulationDistance();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetSimulationDistancePacket(simulationDistance=" + this.getSimulationDistance() + ")";
    }

    public @NonNull ClientboundSetSimulationDistancePacket withSimulationDistance(int simulationDistance) {
        return this.simulationDistance == simulationDistance ? this : new ClientboundSetSimulationDistancePacket(simulationDistance);
    }

    public ClientboundSetSimulationDistancePacket(int simulationDistance) {
        this.simulationDistance = simulationDistance;
    }
}

