/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.veinminer.config;

import de.miraculixx.veinminer.config.ConfigSerializer;
import de.miraculixx.veinminer.config.NamespacedKeySerializer;
import de.miraculixx.veinminer.config.data.BlockGroup;
import de.miraculixx.veinminer.config.data.VeinminerSettings;
import de.miraculixx.veinminer.config.utils.GlobalsKt;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.LinkedHashSetSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModuleBuilder;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u001eJ\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020\u000bH\u0002J\b\u0010%\u001a\u00020\u001eH\u0002J\b\u0010&\u001a\u00020\u001eH\u0002J\b\u0010'\u001a\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R6\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00180\u000f2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00180\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R6\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00180\u00142\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00180\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006("}, d2={"Lde/miraculixx/veinminer/config/ConfigManager;", "", "<init>", "()V", "settingsFile", "Ljava/nio/file/Path;", "blocksFile", "groupsFile", "json", "Lkotlinx/serialization/json/Json;", "value", "Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "settings", "getSettings", "()Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "", "", "veinBlocksRaw", "getVeinBlocksRaw", "()Ljava/util/Set;", "", "Lorg/bukkit/NamespacedKey;", "veinBlocks", "getVeinBlocks", "Lde/miraculixx/veinminer/config/data/BlockGroup;", "groupsRaw", "getGroupsRaw", "groups", "getGroups", "reload", "", "fromDisc", "", "save", "loadBlocks", "loadGroups", "loadSettings", "saveBlocks", "saveGroups", "saveSettings", "veinminer-paper"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nde/miraculixx/veinminer/config/ConfigManager\n+ 2 PathExtensions.kt\nde/miraculixx/veinminer/config/extensions/PathExtensionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SerializersModuleBuilders.kt\nkotlinx/serialization/modules/SerializersModuleBuildersKt\n*L\n1#1,112:1\n15#2,3:113\n18#2,7:117\n25#2,3:125\n15#2,3:129\n18#2,7:133\n25#2,3:141\n14#2,4:146\n18#2,7:151\n25#2,3:159\n205#3:116\n222#3:124\n222#3:128\n205#3:132\n222#3:140\n205#3:150\n222#3:158\n205#3:162\n205#3:163\n205#3:164\n1869#4,2:144\n31#5,3:165\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nde/miraculixx/veinminer/config/ConfigManager\n*L\n73#1:113,3\n73#1:117,7\n73#1:125,3\n87#1:129,3\n87#1:133,7\n87#1:141,3\n107#1:146,4\n107#1:151,7\n107#1:159,3\n73#1:116\n73#1:124\n86#1:128\n87#1:132\n87#1:140\n107#1:150\n107#1:158\n109#1:162\n110#1:163\n111#1:164\n92#1:144,2\n22#1:165,3\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    private static final Path settingsFile;
    @NotNull
    private static final Path blocksFile;
    @NotNull
    private static final Path groupsFile;
    @NotNull
    private static final Json json;
    @NotNull
    private static VeinminerSettings settings;
    @NotNull
    private static Set<String> veinBlocksRaw;
    @NotNull
    private static Set<NamespacedKey> veinBlocks;
    @NotNull
    private static Set<BlockGroup<String>> groupsRaw;
    @NotNull
    private static Set<BlockGroup<NamespacedKey>> groups;

    private ConfigManager() {
    }

    @NotNull
    public final VeinminerSettings getSettings() {
        return settings;
    }

    @NotNull
    public final Set<String> getVeinBlocksRaw() {
        return veinBlocksRaw;
    }

    @NotNull
    public final Set<NamespacedKey> getVeinBlocks() {
        return veinBlocks;
    }

    @NotNull
    public final Set<BlockGroup<String>> getGroupsRaw() {
        return groupsRaw;
    }

    @NotNull
    public final Set<BlockGroup<NamespacedKey>> getGroups() {
        return groups;
    }

    public final void reload(boolean fromDisc) {
        if (fromDisc) {
            settings = this.loadSettings();
        }
        if (this.loadBlocks(fromDisc)) {
            this.saveBlocks();
        }
        if (this.loadGroups(fromDisc)) {
            this.saveGroups();
        }
    }

    public final void save() {
        this.loadBlocks(false);
        this.loadGroups(false);
        this.saveSettings();
        this.saveBlocks();
        this.saveGroups();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean loadBlocks(boolean fromDisc) {
        boolean bl;
        if (fromDisc) {
            void v1;
            void $this$load$iv;
            Path path = blocksFile;
            Set set = new LinkedHashSet();
            Json instance$iv = json;
            boolean $i$f$load = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)$this$load$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PathsKt.createParentDirectories((Path)$this$load$iv, (FileAttribute[])new FileAttribute[0]);
                Json this_$iv$iv = instance$iv;
                boolean $i$f$encodeToString = false;
                this_$iv$iv.getSerializersModule();
                String string$iv = this_$iv$iv.encodeToString((SerializationStrategy)new LinkedHashSetSerializer((KSerializer)StringSerializer.INSTANCE), (Object)default$iv);
                PathsKt.writeText$default((Path)$this$load$iv, (CharSequence)string$iv, null, (OpenOption[])new OpenOption[0], (int)2, null);
                System.out.println((Object)("[Veinminer] Created " + $this$load$iv.getFileName() + " default config"));
                if (GlobalsKt.getDebug()) {
                    System.out.println((Object)("[Veinminer] Content: " + string$iv));
                }
                v1 = default$iv;
            } else {
                Object object;
                try {
                    void this_$iv$iv;
                    Json string$iv = instance$iv;
                    String string$iv$iv = PathsKt.readText$default((Path)$this$load$iv, null, (int)1, null);
                    boolean $i$f$decodeFromString = false;
                    this_$iv$iv.getSerializersModule();
                    object = this_$iv$iv.decodeFromString((DeserializationStrategy)new LinkedHashSetSerializer((KSerializer)StringSerializer.INSTANCE), string$iv$iv);
                }
                catch (Exception e$iv) {
                    System.out.println((Object)("[Veinminer] Failed to load " + $this$load$iv.getFileName() + " config: Reason: " + e$iv.getMessage()));
                    object = default$iv;
                }
                v1 = object;
            }
            veinBlocksRaw = (Set)v1;
        }
        ConfigSerializer.ParsedData parsed = ConfigSerializer.INSTANCE.parseList(veinBlocksRaw, ConfigSerializer.MaterialType.BLOCK);
        veinBlocks = parsed.getParsed();
        if (!((Collection)parsed.getInvalid()).isEmpty()) {
            veinBlocksRaw.removeAll((Collection)parsed.getInvalid());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean loadGroups(boolean fromDisc) {
        Set set;
        block10: {
            Set set2;
            void $this$load$iv;
            Object object;
            block12: {
                block11: {
                    if (!fromDisc) break block10;
                    object = this.getClass().getClassLoader().getResourceAsStream("default_groups.json");
                    if (object == null) break block11;
                    byte[] byArray = ((InputStream)object).readAllBytes();
                    object = byArray;
                    if (byArray != null && (object = StringsKt.decodeToString((byte[])object)) != null) break block12;
                }
                object = "[]";
            }
            Object defaultSource = object;
            Object this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            Set defaultGroups = (Set)this_$iv.decodeFromString((DeserializationStrategy)new LinkedHashSetSerializer(BlockGroup.Companion.serializer(StringSerializer.INSTANCE)), (String)defaultSource);
            this_$iv = groupsFile;
            Json instance$iv = json;
            boolean $i$f$load = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)$this$load$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PathsKt.createParentDirectories((Path)$this$load$iv, (FileAttribute[])new FileAttribute[0]);
                Json this_$iv$iv = instance$iv;
                boolean $i$f$encodeToString = false;
                this_$iv$iv.getSerializersModule();
                string$iv = this_$iv$iv.encodeToString((SerializationStrategy)new LinkedHashSetSerializer(BlockGroup.Companion.serializer(StringSerializer.INSTANCE)), (Object)defaultGroups);
                PathsKt.writeText$default((Path)$this$load$iv, (CharSequence)((CharSequence)string$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
                System.out.println((Object)("[Veinminer] Created " + $this$load$iv.getFileName() + " default config"));
                if (GlobalsKt.getDebug()) {
                    System.out.println((Object)("[Veinminer] Content: " + (String)string$iv));
                }
                set2 = defaultGroups;
            } else {
                Object this_$iv$iv;
                try {
                    string$iv = instance$iv;
                    String string$iv$iv = PathsKt.readText$default((Path)$this$load$iv, null, (int)1, null);
                    boolean $i$f$decodeFromString2 = false;
                    this_$iv$iv.getSerializersModule();
                    this_$iv$iv = this_$iv$iv.decodeFromString((DeserializationStrategy)new LinkedHashSetSerializer(BlockGroup.Companion.serializer(StringSerializer.INSTANCE)), string$iv$iv);
                }
                catch (Exception e$iv) {
                    System.out.println((Object)("[Veinminer] Failed to load " + $this$load$iv.getFileName() + " config: Reason: " + e$iv.getMessage()));
                    this_$iv$iv = defaultGroups;
                }
                set2 = this_$iv$iv;
            }
            groupsRaw = set2;
        }
        boolean save = false;
        Set $this$loadGroups_u24lambda_u243 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = groupsRaw;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockGroup groupRaw = (BlockGroup)element$iv;
            boolean bl2 = false;
            ConfigSerializer.ParsedData parsedBlocks = ConfigSerializer.INSTANCE.parseList(groupRaw.getBlocks(), ConfigSerializer.MaterialType.BLOCK);
            ConfigSerializer.ParsedData parsedTools = ConfigSerializer.INSTANCE.parseList(groupRaw.getTools(), ConfigSerializer.MaterialType.ITEM);
            $this$loadGroups_u24lambda_u243.add(new BlockGroup(groupRaw.getName(), CollectionsKt.toMutableSet((Iterable)parsedBlocks.getParsed()), CollectionsKt.toMutableSet((Iterable)parsedTools.getParsed())));
            if (!(!((Collection)parsedBlocks.getInvalid()).isEmpty()) && !(!((Collection)parsedTools.getInvalid()).isEmpty())) continue;
            groupRaw.getBlocks().removeAll((Collection)parsedBlocks.getInvalid());
            groupRaw.getTools().removeAll((Collection)parsedTools.getInvalid());
            save = true;
        }
        groups = SetsKt.build((Set)set);
        return save;
    }

    /*
     * WARNING - void declaration
     */
    private final VeinminerSettings loadSettings() {
        VeinminerSettings veinminerSettings;
        void $this$load_u24default$iv;
        Path path = settingsFile;
        VeinminerSettings default$iv = new VeinminerSettings(0, false, 0, 0, false, 0, false, false, false, false, null, 2047, null);
        Json instance$iv = GlobalsKt.getJson();
        boolean $i$f$load = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)$this$load_u24default$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.createParentDirectories((Path)$this$load_u24default$iv, (FileAttribute[])new FileAttribute[0]);
            Json this_$iv$iv = instance$iv;
            boolean $i$f$encodeToString = false;
            this_$iv$iv.getSerializersModule();
            String string$iv = this_$iv$iv.encodeToString((SerializationStrategy)VeinminerSettings.Companion.serializer(), (Object)default$iv);
            PathsKt.writeText$default((Path)$this$load_u24default$iv, (CharSequence)string$iv, null, (OpenOption[])new OpenOption[0], (int)2, null);
            System.out.println((Object)("[Veinminer] Created " + $this$load_u24default$iv.getFileName() + " default config"));
            if (GlobalsKt.getDebug()) {
                System.out.println((Object)("[Veinminer] Content: " + string$iv));
            }
            veinminerSettings = default$iv;
        } else {
            Object object;
            try {
                void this_$iv$iv;
                Json string$iv = instance$iv;
                String string$iv$iv = PathsKt.readText$default((Path)$this$load_u24default$iv, null, (int)1, null);
                boolean $i$f$decodeFromString = false;
                this_$iv$iv.getSerializersModule();
                object = this_$iv$iv.decodeFromString((DeserializationStrategy)VeinminerSettings.Companion.serializer(), string$iv$iv);
            }
            catch (Exception e$iv) {
                System.out.println((Object)("[Veinminer] Failed to load " + $this$load_u24default$iv.getFileName() + " config: Reason: " + e$iv.getMessage()));
                object = default$iv;
            }
            veinminerSettings = object;
        }
        return veinminerSettings;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveBlocks() {
        void this_$iv;
        Json json = ConfigManager.json;
        Set<String> value$iv = veinBlocksRaw;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        PathsKt.writeText$default((Path)blocksFile, (CharSequence)this_$iv.encodeToString((SerializationStrategy)new LinkedHashSetSerializer((KSerializer)StringSerializer.INSTANCE), value$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveGroups() {
        void this_$iv;
        Json json = ConfigManager.json;
        Set<BlockGroup<String>> value$iv = groupsRaw;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        PathsKt.writeText$default((Path)groupsFile, (CharSequence)this_$iv.encodeToString((SerializationStrategy)new LinkedHashSetSerializer(BlockGroup.Companion.serializer(StringSerializer.INSTANCE)), value$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveSettings() {
        void this_$iv;
        Json json = ConfigManager.json;
        VeinminerSettings value$iv = settings;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        PathsKt.writeText$default((Path)settingsFile, (CharSequence)this_$iv.encodeToString((SerializationStrategy)VeinminerSettings.Companion.serializer(), (Object)value$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit json$lambda$1(JsonBuilder $this$Json) {
        void $this$json_u24lambda_u241_u24lambda_u240;
        SerializersModuleBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setEncodeDefaults(true);
        boolean $i$f$SerializersModule = false;
        SerializersModuleBuilder serializersModuleBuilder = builder$iv = new SerializersModuleBuilder();
        JsonBuilder jsonBuilder = $this$Json;
        boolean bl = false;
        $this$json_u24lambda_u241_u24lambda_u240.contextual(Reflection.getOrCreateKotlinClass(NamespacedKey.class), (KSerializer)NamespacedKeySerializer.INSTANCE);
        jsonBuilder.setSerializersModule(builder$iv.build());
        return Unit.INSTANCE;
    }

    static {
        Path path = Paths.get("plugins/Veinminer/settings.json", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        settingsFile = path;
        Path path2 = Paths.get("plugins/Veinminer/blocks.json", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        blocksFile = path2;
        Path path3 = Paths.get("plugins/Veinminer/groups.json", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        groupsFile = path3;
        json = JsonKt.Json$default(null, ConfigManager::json$lambda$1, (int)1, null);
        settings = INSTANCE.loadSettings();
        veinBlocksRaw = new LinkedHashSet();
        veinBlocks = SetsKt.emptySet();
        groupsRaw = new LinkedHashSet();
        groups = SetsKt.emptySet();
        INSTANCE.reload(true);
    }
}

