/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.veinminer.config;

import de.miraculixx.veinminer.Veinminer;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lde/miraculixx/veinminer/config/ConfigSerializer;", "", "<init>", "()V", "parseList", "Lde/miraculixx/veinminer/config/ConfigSerializer$ParsedData;", "rawList", "", "", "type", "Lde/miraculixx/veinminer/config/ConfigSerializer$MaterialType;", "parseEntry", "Lorg/bukkit/NamespacedKey;", "raw", "MaterialType", "ParsedData", "veinminer-paper"})
@SourceDebugExtension(value={"SMAP\nConfigSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigSerializer.kt\nde/miraculixx/veinminer/config/ConfigSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1869#2,2:68\n1563#2:70\n1634#2,3:71\n*S KotlinDebug\n*F\n+ 1 ConfigSerializer.kt\nde/miraculixx/veinminer/config/ConfigSerializer\n*L\n22#1:68,2\n49#1:70\n49#1:71,3\n*E\n"})
public final class ConfigSerializer {
    @NotNull
    public static final ConfigSerializer INSTANCE = new ConfigSerializer();

    private ConfigSerializer() {
    }

    @NotNull
    public final ParsedData parseList(@NotNull Set<String> rawList, @NotNull MaterialType type) {
        Intrinsics.checkNotNullParameter(rawList, (String)"rawList");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Set parsed = new LinkedHashSet();
        Set invalid = new LinkedHashSet();
        Iterable $this$forEach$iv = rawList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String raw = (String)element$iv;
            boolean bl = false;
            Set<NamespacedKey> entries = INSTANCE.parseEntry(raw, type);
            if (entries == null) {
                Veinminer.Companion.getLOGGER().warn("Failed to access server registry! Cannot parse config, Veinminer will be inactive!");
                continue;
            }
            if (entries.isEmpty()) {
                invalid.add(raw);
                Logger logger = Veinminer.Companion.getLOGGER();
                String string = type.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                logger.warn("Invalid " + string + " entry in config: " + raw);
                continue;
            }
            parsed.addAll((Collection)entries);
        }
        return new ParsedData(parsed, invalid);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<NamespacedKey> parseEntry(String raw, MaterialType type) {
        Set set;
        String string;
        boolean isTag = StringsKt.startsWith$default((String)raw, (String)"#", (boolean)false, (int)2, null);
        if (isTag) {
            String string2 = raw.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = raw;
        }
        String name = string;
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)name);
        if (namespacedKey == null) {
            return SetsKt.emptySet();
        }
        NamespacedKey key = namespacedKey;
        if (isTag) {
            void $this$mapTo$iv$iv;
            Tag tag = Bukkit.getTag((String)type.getRegis(), (NamespacedKey)key, Material.class);
            if (tag == null) {
                return SetsKt.emptySet();
            }
            Tag tag2 = tag;
            Set set2 = tag2.getValues();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getValues(...)");
            Iterable $this$map$iv = set2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Material material = (Material)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            Registry registry;
            RegistryAccess registryAccess = RegistryAccess.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            RegistryAccess regAccess = registryAccess;
            if (type == MaterialType.BLOCK) {
                Registry registry2 = regAccess.getRegistry(RegistryKey.BLOCK);
                registry = registry2;
                Intrinsics.checkNotNullExpressionValue((Object)registry2, (String)"getRegistry(...)");
            } else {
                Registry registry3 = regAccess.getRegistry(RegistryKey.ITEM);
                registry = registry3;
                Intrinsics.checkNotNullExpressionValue((Object)registry3, (String)"getRegistry(...)");
            }
            Registry reg = registry;
            set = reg.get(key) != null ? SetsKt.setOf((Object)key) : SetsKt.emptySet();
        }
        return set;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lde/miraculixx/veinminer/config/ConfigSerializer$MaterialType;", "", "regis", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getRegis", "()Ljava/lang/String;", "ITEM", "BLOCK", "veinminer-paper"})
    public static final class MaterialType
    extends Enum<MaterialType> {
        @NotNull
        private final String regis;
        public static final /* enum */ MaterialType ITEM = new MaterialType("items");
        public static final /* enum */ MaterialType BLOCK = new MaterialType("blocks");
        private static final /* synthetic */ MaterialType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MaterialType(String regis) {
            this.regis = regis;
        }

        @NotNull
        public final String getRegis() {
            return this.regis;
        }

        public static MaterialType[] values() {
            return (MaterialType[])$VALUES.clone();
        }

        public static MaterialType valueOf(String value) {
            return Enum.valueOf(MaterialType.class, value);
        }

        @NotNull
        public static EnumEntries<MaterialType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = materialTypeArray = new MaterialType[]{MaterialType.ITEM, MaterialType.BLOCK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"Lde/miraculixx/veinminer/config/ConfigSerializer$ParsedData;", "", "parsed", "", "Lorg/bukkit/NamespacedKey;", "invalid", "", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "getParsed", "()Ljava/util/Set;", "getInvalid", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "veinminer-paper"})
    public static final class ParsedData {
        @NotNull
        private final Set<NamespacedKey> parsed;
        @NotNull
        private final Set<String> invalid;

        public ParsedData(@NotNull Set<NamespacedKey> parsed, @NotNull Set<String> invalid) {
            Intrinsics.checkNotNullParameter(parsed, (String)"parsed");
            Intrinsics.checkNotNullParameter(invalid, (String)"invalid");
            this.parsed = parsed;
            this.invalid = invalid;
        }

        @NotNull
        public final Set<NamespacedKey> getParsed() {
            return this.parsed;
        }

        @NotNull
        public final Set<String> getInvalid() {
            return this.invalid;
        }

        @NotNull
        public final Set<NamespacedKey> component1() {
            return this.parsed;
        }

        @NotNull
        public final Set<String> component2() {
            return this.invalid;
        }

        @NotNull
        public final ParsedData copy(@NotNull Set<NamespacedKey> parsed, @NotNull Set<String> invalid) {
            Intrinsics.checkNotNullParameter(parsed, (String)"parsed");
            Intrinsics.checkNotNullParameter(invalid, (String)"invalid");
            return new ParsedData(parsed, invalid);
        }

        public static /* synthetic */ ParsedData copy$default(ParsedData parsedData, Set set, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                set = parsedData.parsed;
            }
            if ((n & 2) != 0) {
                set2 = parsedData.invalid;
            }
            return parsedData.copy(set, set2);
        }

        @NotNull
        public String toString() {
            return "ParsedData(parsed=" + this.parsed + ", invalid=" + this.invalid + ")";
        }

        public int hashCode() {
            int result = ((Object)this.parsed).hashCode();
            result = result * 31 + ((Object)this.invalid).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedData)) {
                return false;
            }
            ParsedData parsedData = (ParsedData)other;
            if (!Intrinsics.areEqual(this.parsed, parsedData.parsed)) {
                return false;
            }
            return Intrinsics.areEqual(this.invalid, parsedData.invalid);
        }
    }
}

