/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.veinminer.config;

import de.miraculixx.veinminer.config.data.ModrinthFile;
import de.miraculixx.veinminer.config.data.ModrinthVersion;
import de.miraculixx.veinminer.config.utils.GlobalsKt;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lde/miraculixx/veinminer/config/UpdateManager;", "", "<init>", "()V", "Lde/miraculixx/veinminer/config/UpdateManager$Module;", "module", "", "platform", "serverVersion", "modVersion", "Lde/miraculixx/veinminer/config/UpdateManager$VersionInfo;", "checkForUpdates", "(Lde/miraculixx/veinminer/config/UpdateManager$Module;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lde/miraculixx/veinminer/config/UpdateManager$VersionInfo;", "Lde/miraculixx/veinminer/config/data/ModrinthFile;", "file", "", "update", "(Lde/miraculixx/veinminer/config/UpdateManager$Module;Lde/miraculixx/veinminer/config/data/ModrinthFile;Ljava/lang/String;)V", "", "DEBUG", "Z", "Module", "VersionInfo", "core"})
@SourceDebugExtension(value={"SMAP\nUpdateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateManager.kt\nde/miraculixx/veinminer/config/UpdateManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n222#2:59\n1#3:60\n*S KotlinDebug\n*F\n+ 1 UpdateManager.kt\nde/miraculixx/veinminer/config/UpdateManager\n*L\n17#1:59\n*E\n"})
public final class UpdateManager {
    @NotNull
    public static final UpdateManager INSTANCE = new UpdateManager();
    private static final boolean DEBUG = true;

    private UpdateManager() {
    }

    @NotNull
    public final VersionInfo checkForUpdates(@NotNull Module module, @NotNull String platform, @NotNull String serverVersion, @Nullable String modVersion) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)module), (String)"module");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)serverVersion, (String)"serverVersion");
        URL target = new URI("https://api.modrinth.com/v2/project/" + module.getId() + "/version?loaders=%5B%22" + platform + "%22%5D&game_versions=%5B%22" + serverVersion + "%22%5D").toURL();
        URLConnection uRLConnection = target.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection con = (HttpURLConnection)uRLConnection;
        byte[] byArray = con.getInputStream().readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        String content = StringsKt.decodeToString((byte[])byArray);
        Json this_$iv = GlobalsKt.getJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        ModrinthVersion latest = (ModrinthVersion)CollectionsKt.firstOrNull((List)((List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(ModrinthVersion.Companion.serializer()), content)));
        if (latest == null) {
            System.out.println((Object)("[VeinminerUpdater] No version found for " + module.getModID() + (" (" + target.getPath() + ")")));
            String string = modVersion;
            if (string == null) {
                string = "unknown";
            }
            return new VersionInfo(false, string, "unknown", module);
        }
        if (Intrinsics.areEqual((Object)latest.getVersion_number(), (Object)modVersion)) {
            System.out.println((Object)("[VeinminerUpdater] " + module.getModID() + " is up to date"));
            bl = false;
        } else if (modVersion != null) {
            System.out.println((Object)("[VeinminerUpdater] " + module.getModID() + " is outdated (" + serverVersion + "). Installed: " + modVersion + " -> Latest: " + latest.getVersion_number()));
            bl = true;
        } else {
            bl = false;
        }
        boolean outdated = bl;
        this.update(module, (ModrinthFile)CollectionsKt.first(latest.getFiles()), platform);
        String string = modVersion;
        if (string == null) {
            string = "unknown";
        }
        return new VersionInfo(outdated, string, latest.getVersion_number(), module);
    }

    private final void update(Module module, ModrinthFile file, String platform) {
        File file2;
        URL target = new URI(file.getUrl()).toURL();
        URLConnection uRLConnection = target.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection con = (HttpURLConnection)uRLConnection;
        byte[] content = con.getInputStream().readAllBytes();
        File configFolder = new File(Intrinsics.areEqual((Object)platform, (Object)"fabric") ? "config/veinminer" : "plugins/Veinminer");
        File $this$update_u24lambda_u240 = file2 = new File(configFolder, "update");
        boolean bl = false;
        $this$update_u24lambda_u240.mkdirs();
        File targetFolder = file2;
        File targetFile = new File(targetFolder, file.getFilename());
        Intrinsics.checkNotNull((Object)content);
        FilesKt.writeBytes((File)targetFile, (byte[])content);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\n\u0010\tj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lde/miraculixx/veinminer/config/UpdateManager$Module;", "", "", "id", "modID", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "Ljava/lang/String;", "getId", "()Ljava/lang/String;", "getModID", "VEINMINER", "VEINMINER_ENCHANTMENT", "VEINMINER_CLIENT", "core"})
    public static final class Module
    extends Enum<Module> {
        @NotNull
        private final String id;
        @NotNull
        private final String modID;
        public static final /* enum */ Module VEINMINER = new Module("OhduvhIc", "veinminer");
        public static final /* enum */ Module VEINMINER_ENCHANTMENT = new Module("4sP0LXxp", "veinminer-enchantment");
        public static final /* enum */ Module VEINMINER_CLIENT = new Module("dxa0Bm8m", "veinminer-client");
        private static final /* synthetic */ Module[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Module(String id, String modID) {
            this.id = id;
            this.modID = modID;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getModID() {
            return this.modID;
        }

        public static Module[] values() {
            return (Module[])$VALUES.clone();
        }

        public static Module valueOf(String value) {
            return Enum.valueOf(Module.class, value);
        }

        @NotNull
        public static EnumEntries<Module> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = moduleArray = new Module[]{Module.VEINMINER, Module.VEINMINER_ENCHANTMENT, Module.VEINMINER_CLIENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0015\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001f\u0010\u000eR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b!\u0010\u0011\u00a8\u0006\""}, d2={"Lde/miraculixx/veinminer/config/UpdateManager$VersionInfo;", "", "", "outdated", "", "currentVersion", "latestVersion", "Lde/miraculixx/veinminer/config/UpdateManager$Module;", "module", "<init>", "(ZLjava/lang/String;Ljava/lang/String;Lde/miraculixx/veinminer/config/UpdateManager$Module;)V", "component1", "()Z", "component2", "()Ljava/lang/String;", "component3", "component4", "()Lde/miraculixx/veinminer/config/UpdateManager$Module;", "copy", "(ZLjava/lang/String;Ljava/lang/String;Lde/miraculixx/veinminer/config/UpdateManager$Module;)Lde/miraculixx/veinminer/config/UpdateManager$VersionInfo;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Z", "getOutdated", "Ljava/lang/String;", "getCurrentVersion", "getLatestVersion", "Lde/miraculixx/veinminer/config/UpdateManager$Module;", "getModule", "core"})
    public static final class VersionInfo {
        private final boolean outdated;
        @NotNull
        private final String currentVersion;
        @NotNull
        private final String latestVersion;
        @NotNull
        private final Module module;

        public VersionInfo(boolean outdated, @NotNull String currentVersion, @NotNull String latestVersion, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
            Intrinsics.checkNotNullParameter((Object)latestVersion, (String)"latestVersion");
            Intrinsics.checkNotNullParameter((Object)((Object)module), (String)"module");
            this.outdated = outdated;
            this.currentVersion = currentVersion;
            this.latestVersion = latestVersion;
            this.module = module;
        }

        public final boolean getOutdated() {
            return this.outdated;
        }

        @NotNull
        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @NotNull
        public final String getLatestVersion() {
            return this.latestVersion;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        public final boolean component1() {
            return this.outdated;
        }

        @NotNull
        public final String component2() {
            return this.currentVersion;
        }

        @NotNull
        public final String component3() {
            return this.latestVersion;
        }

        @NotNull
        public final Module component4() {
            return this.module;
        }

        @NotNull
        public final VersionInfo copy(boolean outdated, @NotNull String currentVersion, @NotNull String latestVersion, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
            Intrinsics.checkNotNullParameter((Object)latestVersion, (String)"latestVersion");
            Intrinsics.checkNotNullParameter((Object)((Object)module), (String)"module");
            return new VersionInfo(outdated, currentVersion, latestVersion, module);
        }

        public static /* synthetic */ VersionInfo copy$default(VersionInfo versionInfo, boolean bl, String string, String string2, Module module, int n, Object object) {
            if ((n & 1) != 0) {
                bl = versionInfo.outdated;
            }
            if ((n & 2) != 0) {
                string = versionInfo.currentVersion;
            }
            if ((n & 4) != 0) {
                string2 = versionInfo.latestVersion;
            }
            if ((n & 8) != 0) {
                module = versionInfo.module;
            }
            return versionInfo.copy(bl, string, string2, module);
        }

        @NotNull
        public String toString() {
            return "VersionInfo(outdated=" + this.outdated + ", currentVersion=" + this.currentVersion + ", latestVersion=" + this.latestVersion + ", module=" + this.module + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.outdated);
            result = result * 31 + this.currentVersion.hashCode();
            result = result * 31 + this.latestVersion.hashCode();
            result = result * 31 + this.module.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionInfo)) {
                return false;
            }
            VersionInfo versionInfo = (VersionInfo)other;
            if (this.outdated != versionInfo.outdated) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.currentVersion, (Object)versionInfo.currentVersion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.latestVersion, (Object)versionInfo.latestVersion)) {
                return false;
            }
            return this.module == versionInfo.module;
        }
    }
}

