/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.kpaper.extensions.bukkit;

import de.miraculixx.kpaper.extensions.GeneralExtensionsKt;
import de.miraculixx.kpaper.main.KSpigotKt;
import de.miraculixx.kpaper.pluginmessages.PluginMessageConnect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u000f*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u000f*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u000f*\u00020\u0013\u001a\u0019\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0002*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018\u001aD\u0010\u0019\u001a#\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00160\u00160\u001a\u00a2\u0006\u0002\b\u0002*\u00020\u00112\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u001e\"\u00020\u0016\u00a2\u0006\u0002\u0010\u001f\u001a\n\u0010 \u001a\u00020\u000f*\u00020\n\u001a\n\u0010!\u001a\u00020\u000f*\u00020\u0011\u001a\n\u0010\"\u001a\u00020\u000f*\u00020\u0011\u001a\n\u0010#\u001a\u00020\u000f*\u00020$\u001a\u0012\u0010%\u001a\u00020\u000f*\u00020\u00112\u0006\u0010&\u001a\u00020'\u001a\n\u0010(\u001a\u00020\u000f*\u00020\u0011\u001a\n\u0010)\u001a\u00020\u000f*\u00020\u0011\"\u001a\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0015\u0010\t\u001a\u00020\u0007*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0015\u0010\f\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0015\u0010\r\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\u00a8\u0006*"}, d2={"groundMaterial", "Lorg/bukkit/Material;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/bukkit/entity/Entity;", "getGroundMaterial", "(Lorg/bukkit/entity/Entity;)Lorg/bukkit/Material;", "isFeetInWater", "", "(Lorg/bukkit/entity/Entity;)Z", "isHeadInWater", "Lorg/bukkit/entity/LivingEntity;", "(Lorg/bukkit/entity/LivingEntity;)Z", "isStandingInMidAir", "isStandingOnBlock", "hideEveryone", "", "feed", "Lorg/bukkit/entity/Player;", "fullLock", "Lorg/bukkit/entity/ArmorStand;", "fullUnlock", "getHandItem", "Lorg/bukkit/inventory/ItemStack;", "hand", "Lorg/bukkit/inventory/EquipmentSlot;", "give", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "itemStacks", "", "(Lorg/bukkit/entity/Player;[Lorg/bukkit/inventory/ItemStack;)Ljava/util/HashMap;", "heal", "hideOnlinePlayers", "hideSelf", "kill", "Lorg/bukkit/entity/Damageable;", "sendToServer", "servername", "", "showOnlinePlayers", "showSelf", "KPaper"})
@SourceDebugExtension(value={"SMAP\nEntityExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityExtensions.kt\nde/miraculixx/kpaper/extensions/bukkit/EntityExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n766#2:148\n857#2,2:149\n1855#2,2:151\n766#2:153\n857#2,2:154\n1855#2,2:156\n766#2:158\n857#2,2:159\n1855#2,2:161\n766#2:163\n857#2,2:164\n1855#2,2:166\n1855#2,2:168\n*S KotlinDebug\n*F\n+ 1 EntityExtensions.kt\nde/miraculixx/kpaper/extensions/bukkit/EntityExtensionsKt\n*L\n72#1:148\n72#1:149,2\n72#1:151,2\n79#1:153\n79#1:154,2\n79#1:156,2\n86#1:158\n86#1:159,2\n86#1:161,2\n93#1:163\n93#1:164,2\n93#1:166,2\n100#1:168,2\n*E\n"})
public final class EntityExtensionsKt {
    public static final boolean isHeadInWater(@NotNull LivingEntity $this$isHeadInWater) {
        Intrinsics.checkNotNullParameter((Object)$this$isHeadInWater, (String)"<this>");
        return $this$isHeadInWater.getEyeLocation().getBlock().getType() == Material.WATER;
    }

    public static final boolean isFeetInWater(@NotNull Entity $this$isFeetInWater) {
        Intrinsics.checkNotNullParameter((Object)$this$isFeetInWater, (String)"<this>");
        return $this$isFeetInWater.getLocation().getBlock().getType() == Material.WATER;
    }

    @NotNull
    public static final Material getGroundMaterial(@NotNull Entity $this$groundMaterial) {
        Intrinsics.checkNotNullParameter((Object)$this$groundMaterial, (String)"<this>");
        Material material = $this$groundMaterial.getLocation().add(0.0, -0.01, 0.0).getBlock().getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"this.location.add(0.0, -0.01, 0.0).block.type");
        return material;
    }

    public static final boolean isStandingOnBlock(@NotNull Entity $this$isStandingOnBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$isStandingOnBlock, (String)"<this>");
        return EntityExtensionsKt.getGroundMaterial($this$isStandingOnBlock).isSolid();
    }

    public static final boolean isStandingInMidAir(@NotNull Entity $this$isStandingInMidAir) {
        Intrinsics.checkNotNullParameter((Object)$this$isStandingInMidAir, (String)"<this>");
        return !EntityExtensionsKt.isStandingOnBlock($this$isStandingInMidAir) && $this$isStandingInMidAir.getVehicle() == null && !$this$isStandingInMidAir.getLocation().clone().add(0.0, 0.1, 0.0).getBlock().getType().isSolid() && !$this$isStandingInMidAir.getLocation().getBlock().getType().isSolid();
    }

    public static final void kill(@NotNull Damageable $this$kill) {
        Intrinsics.checkNotNullParameter((Object)$this$kill, (String)"<this>");
        $this$kill.damage(0.1);
        if ($this$kill.getHealth() > 0.0) {
            $this$kill.setHealth(0.0);
        }
    }

    public static final void heal(@NotNull LivingEntity $this$heal) {
        Intrinsics.checkNotNullParameter((Object)$this$heal, (String)"<this>");
        AttributeInstance attributeInstance = $this$heal.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attributeInstance == null) {
            throw new NullPointerException("The entity does not have a max health value!");
        }
        $this$heal.setHealth(attributeInstance.getValue());
    }

    public static final void feed(@NotNull Player $this$feed) {
        Intrinsics.checkNotNullParameter((Object)$this$feed, (String)"<this>");
        $this$feed.setFoodLevel(20);
        $this$feed.setSaturation(20.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static final void hideSelf(@NotNull Player $this$hideSelf) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hideSelf, (String)"<this>");
        Iterable $this$filter$iv = GeneralExtensionsKt.getOnlinePlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)$this$hideSelf))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            it.hidePlayer((Plugin)KSpigotKt.getPluginInstance(), $this$hideSelf);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void showSelf(@NotNull Player $this$showSelf) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$showSelf, (String)"<this>");
        Iterable $this$filter$iv = GeneralExtensionsKt.getOnlinePlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)$this$showSelf))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            it.showPlayer((Plugin)KSpigotKt.getPluginInstance(), $this$showSelf);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void hideOnlinePlayers(@NotNull Player $this$hideOnlinePlayers) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hideOnlinePlayers, (String)"<this>");
        Iterable $this$filter$iv = GeneralExtensionsKt.getOnlinePlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)$this$hideOnlinePlayers))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            $this$hideOnlinePlayers.hidePlayer((Plugin)KSpigotKt.getPluginInstance(), it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void showOnlinePlayers(@NotNull Player $this$showOnlinePlayers) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$showOnlinePlayers, (String)"<this>");
        Iterable $this$filter$iv = GeneralExtensionsKt.getOnlinePlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)$this$showOnlinePlayers))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            $this$showOnlinePlayers.showPlayer((Plugin)KSpigotKt.getPluginInstance(), it);
        }
    }

    public static final void hideEveryone() {
        Iterable $this$forEach$iv = GeneralExtensionsKt.getOnlinePlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            EntityExtensionsKt.hideOnlinePlayers(it);
        }
    }

    @Nullable
    public static final ItemStack getHandItem(@NotNull Player $this$getHandItem, @NotNull EquipmentSlot hand) {
        Intrinsics.checkNotNullParameter((Object)$this$getHandItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        return switch (WhenMappings.$EnumSwitchMapping$0[hand.ordinal()]) {
            case 1 -> $this$getHandItem.getInventory().getItemInMainHand();
            case 2 -> $this$getHandItem.getInventory().getItemInOffHand();
            default -> null;
        };
    }

    public static final void sendToServer(@NotNull Player $this$sendToServer, @NotNull String servername) {
        Intrinsics.checkNotNullParameter((Object)$this$sendToServer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)servername, (String)"servername");
        new PluginMessageConnect(servername).sendWithPlayer($this$sendToServer);
    }

    @NotNull
    public static final HashMap<Integer, ItemStack> give(@NotNull Player $this$give, ItemStack ... itemStacks) {
        Intrinsics.checkNotNullParameter((Object)$this$give, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)itemStacks, (String)"itemStacks");
        HashMap hashMap = $this$give.getInventory().addItem(Arrays.copyOf(itemStacks, itemStacks.length));
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"inventory.addItem(*itemStacks)");
        return hashMap;
    }

    public static final void fullLock(@NotNull ArmorStand $this$fullLock) {
        Intrinsics.checkNotNullParameter((Object)$this$fullLock, (String)"<this>");
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            for (ArmorStand.LockType lock : ArmorStand.LockType.values()) {
                $this$fullLock.addEquipmentLock(slot, lock);
            }
        }
    }

    public static final void fullUnlock(@NotNull ArmorStand $this$fullUnlock) {
        Intrinsics.checkNotNullParameter((Object)$this$fullUnlock, (String)"<this>");
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            for (ArmorStand.LockType lock : ArmorStand.LockType.values()) {
                $this$fullUnlock.removeEquipmentLock(slot, lock);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquipmentSlot.values().length];
            try {
                nArray[EquipmentSlot.HAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.OFF_HAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

