/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.kpaper.localization;

import de.miraculixx.kpaper.extensions.GeneralExtensionsKt;
import de.miraculixx.kpaper.extensions.bukkit.ComponentExtensionsKt;
import de.miraculixx.kpaper.localization.Config;
import de.miraculixx.kpaper.localization.LocalizationKt;
import de.miraculixx.kpaper.main.KPaperConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\u0010\u0006\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/miraculixx/kpaper/localization/Localization;", "", "folder", "Ljava/io/File;", "active", "", "keys", "", "Lkotlin/Pair;", "Ljava/io/InputStream;", "(Ljava/io/File;Ljava/lang/String;Ljava/util/List;)V", "languages", "", "prefix", "Lnet/kyori/adventure/text/Component;", "checkFile", "", "key", "checkFiles", "", "getLoadedKeys", "setLanguage", "KPaper"})
@SourceDebugExtension(value={"SMAP\nLocalization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Localization.kt\nde/miraculixx/kpaper/localization/Localization\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Config.kt\nde/miraculixx/kpaper/localization/Config\n*L\n1#1,130:1\n1855#2:131\n1856#2:133\n1855#2:138\n1856#2:145\n1#3:132\n13579#4,2:134\n20#5,2:136\n22#5,6:139\n28#5,2:146\n*S KotlinDebug\n*F\n+ 1 Localization.kt\nde/miraculixx/kpaper/localization/Localization\n*L\n123#1:131\n123#1:133\n113#1:138\n113#1:145\n97#1:134,2\n113#1:136,2\n113#1:139,6\n113#1:146,2\n*E\n"})
public final class Localization {
    @NotNull
    private final File folder;
    @NotNull
    private final List<String> languages;
    @NotNull
    private final Component prefix;

    public Localization(@NotNull File folder, @NotNull String active, @NotNull List<? extends Pair<String, ? extends InputStream>> keys) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)active, (String)"active");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.folder = folder;
        this.languages = new ArrayList();
        this.prefix = KPaperConfiguration.Text.INSTANCE.getPrefix();
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object object = (InputStream)it.getSecond();
            if (object == null) continue;
            byte[] byArray = ((InputStream)object).readAllBytes();
            object = byArray;
            if (byArray == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readAllBytes()");
            byte[] bytes = byArray;
            boolean bl2 = false;
            FilesKt.writeBytes((File)new File(this.folder.getPath() + "/" + it.getFirst() + ".yml"), (byte[])bytes);
        }
        this.checkFiles();
        this.setLanguage(active);
    }

    @NotNull
    public final List<String> getLoadedKeys() {
        return this.languages;
    }

    public final boolean setLanguage(@NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (LocalizationKt.access$getLocalization$p().get(key) != null || this.checkFile(key)) {
            LocalizationKt.access$setDefaultLocale$p(key);
            GeneralExtensionsKt.getConsole().sendMessage(ComponentExtensionsKt.plus(ComponentExtensionsKt.plus(this.prefix, ComponentExtensionsKt.cmp$default("Changed default language to ", null, false, false, false, false, 62, null)), ComponentExtensionsKt.cmp$default(key, KPaperConfiguration.Text.INSTANCE.getHighlightColor(), false, false, false, false, 60, null)));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkFiles() {
        block1: {
            this.languages.clear();
            File[] fileArray = this.folder.listFiles();
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String key = FilesKt.getNameWithoutExtension((File)it);
                if (!this.checkFile(key)) continue;
                this.languages.add(key);
                GeneralExtensionsKt.getConsole().sendMessage(ComponentExtensionsKt.plus(ComponentExtensionsKt.plus(this.prefix, ComponentExtensionsKt.cmp$default("Loaded language ", null, false, false, false, false, 62, null)), ComponentExtensionsKt.cmp$default(key, KPaperConfiguration.Text.INSTANCE.getHighlightColor(), false, false, false, false, 60, null)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkFile(String key) {
        String string;
        Config config;
        block4: {
            void this_$iv;
            File file = new File(this.folder.getPath() + "/" + key + ".yml");
            if (!file.exists()) {
                GeneralExtensionsKt.getConsole().sendMessage(ComponentExtensionsKt.plus(this.prefix, ComponentExtensionsKt.cmp$default("LANG - " + key + " file not exist", null, false, false, false, false, 62, null)));
                return false;
            }
            Config config2 = config = new Config(new FileInputStream(file), key, file);
            String key$iv = "version";
            boolean $i$f$get = false;
            Object route$iv = null;
            route$iv = this_$iv.getConfigMap();
            char[] cArray = new char[]{'.'};
            Iterable $this$forEach$iv$iv = StringsKt.split$default((CharSequence)key$iv, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                String it$iv = (String)element$iv$iv;
                boolean bl = false;
                if (route$iv instanceof Map) {
                    route$iv = route$iv.get(it$iv);
                    continue;
                }
                string = null;
                break block4;
            }
            string = route$iv instanceof String ? (String)route$iv : null;
        }
        if (string == null) {
            GeneralExtensionsKt.getConsole().sendMessage(ComponentExtensionsKt.plus(this.prefix, ComponentExtensionsKt.cmp$default("LANG - " + key + " file is not a valid language config", null, false, false, false, false, 62, null)));
            return false;
        }
        LocalizationKt.access$getLocalization$p().put(key, config);
        return true;
    }
}

