/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.nanomessage;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.NanoMessageTokenizer;
import org.milkteamc.autotreechop.libs.tinytranslations.util.compiler.SimpleStringParser;

public class NanoMessageParser
extends SimpleStringParser<NanoMessageTokenizer.Token, NanoMessageTokenizer.TokenValue, String> {
    public static final List<String> PRE = List.of("pre", "nbt", "json", "gson", "legacy");
    public static final String CONTENTS = "CONTENTS";
    public static final String PLACEHOLDER = "PLACEHOLDER";
    public static final String CONTENT_TAG = "CONTENT_TAG";
    public static final String CHOICE_PLACEHOLDER = "CHOICE_PLACEHOLDER";
    public static final String CHOICE_OPTION = "CHOICE_OPTION";
    public static final String TEXT_ELEMENT = "TEXT_ELEMENT";
    public static final String KEY = "KEY";
    public static final String ATTRIBUTES = "ATTRIBUTES";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String OPEN_TAG = "OPEN_TAG";
    public static final String CLOSE_TAG = "CLOSE_TAG";
    public static final String SELF_CLOSING_TAG = "SELF_CLOSING_TAG";
    private static final Iterable<NanoMessageTokenizer.Token> TAG_ATTR_DELIMITER = List.of(NanoMessageTokenizer.TAG_END, NanoMessageTokenizer.TAG_CLOSE);
    private static final Iterable<NanoMessageTokenizer.Token> SELF_CLOSING_ATTR_DELIMITER = List.of(NanoMessageTokenizer.TAG_END);
    private static final Iterable<NanoMessageTokenizer.Token> CHOICE_ATTR_DELIMITER = List.of(NanoMessageTokenizer.PH_CLOSE, NanoMessageTokenizer.CHOICE);
    private static final Iterable<NanoMessageTokenizer.Token> PLACEHOLDER_ATTR_DELIMITER = List.of(NanoMessageTokenizer.PH_CLOSE);

    public NanoMessageParser(List<NanoMessageTokenizer.TokenValue> tokens) {
        super(tokens);
    }

    @Override
    public SimpleStringParser.Node parse() {
        this.parseContents(() -> true);
        return this.buildTree();
    }

    @Override
    public NanoMessageTokenizer.Token getTokenType(NanoMessageTokenizer.TokenValue value) {
        return value == null ? null : value.type();
    }

    private boolean parseContents(Supplier<Boolean> predicate) {
        SimpleStringParser.Marker m = this.mark();
        boolean ret = true;
        while (this.getTokenType() != null && predicate.get().booleanValue()) {
            boolean parsedAnything;
            boolean bl = parsedAnything = this.parseContentTag() || this.parseSelfClosingTag() || this.parseChoice() || this.parsePlaceholder() || this.parseText();
            if (!parsedAnything) {
                this.advance();
            }
            ret = ret && parsedAnything;
        }
        m.done(CONTENTS);
        return ret;
    }

    private boolean parsePlaceholder() {
        SimpleStringParser.Marker m = this.mark();
        if (!this.consumeTokens(NanoMessageTokenizer.PH_OPEN)) {
            return this.fail(m);
        }
        this.consumeWhiteSpaces();
        if (!this.parseKey() || !this.parseAttributes(PLACEHOLDER_ATTR_DELIMITER)) {
            return this.fail(m);
        }
        this.consumeWhiteSpaces();
        if (!this.consumeTokens(NanoMessageTokenizer.PH_CLOSE)) {
            return this.fail(m);
        }
        m.done(PLACEHOLDER);
        return true;
    }

    private boolean parseChoice() {
        SimpleStringParser.Marker m = this.mark();
        if (!this.consumeTokens(NanoMessageTokenizer.PH_OPEN)) {
            return this.fail(m);
        }
        this.consumeWhiteSpaces();
        if (!this.parseKey() || !this.parseAttributes(CHOICE_ATTR_DELIMITER)) {
            return this.fail(m);
        }
        this.consumeWhiteSpaces();
        if (!this.consumeTokens(NanoMessageTokenizer.CHOICE)) {
            return this.fail(m);
        }
        boolean again = true;
        while (again) {
            this.consumeWhiteSpaces();
            SimpleStringParser.Marker opt = this.mark();
            if (!this.parseString() && !this.parseContents(() -> !this.is(NanoMessageTokenizer.SEPARATOR) && !this.is(NanoMessageTokenizer.PH_CLOSE))) {
                return this.fail(m);
            }
            this.consumeWhiteSpaces();
            opt.done(CHOICE_OPTION);
            if (!this.consumeTokens(NanoMessageTokenizer.SEPARATOR)) {
                again = false;
            }
            this.consumeWhiteSpaces();
        }
        if (!this.consumeTokens(NanoMessageTokenizer.PH_CLOSE)) {
            return this.fail(m);
        }
        m.done(CHOICE_PLACEHOLDER);
        return true;
    }

    private boolean parseSelfClosingTag() {
        SimpleStringParser.Marker m = this.mark();
        if (!(this.consumeTokens(NanoMessageTokenizer.TAG_OPEN) && this.parseKey() && this.parseAttributes(SELF_CLOSING_ATTR_DELIMITER))) {
            return this.fail(m);
        }
        if (!this.consumeTokens(NanoMessageTokenizer.TAG_END, NanoMessageTokenizer.TAG_CLOSE)) {
            return this.fail(m);
        }
        m.done(SELF_CLOSING_TAG);
        return true;
    }

    private boolean parseContentTag() {
        SimpleStringParser.Marker m = this.mark();
        String open = this.parseOpenTag();
        if (open == null) {
            return this.fail(m);
        }
        if (PRE.stream().anyMatch(open::equalsIgnoreCase)) {
            this.parsePreContent(open);
        } else {
            this.parseContents(() -> !this.isCloseTag(open));
        }
        this.parseCloseTag(open);
        m.done(CONTENT_TAG);
        return true;
    }

    @Nullable
    private String parseOpenTag() {
        SimpleStringParser.Marker m = this.mark();
        if (!this.consumeTokens(NanoMessageTokenizer.TAG_OPEN)) {
            m.rollback();
            return null;
        }
        String startTag = this.getTokenText();
        if (!(this.parseKey() && this.parseAttributes(TAG_ATTR_DELIMITER) && this.consumeTokens(NanoMessageTokenizer.TAG_CLOSE))) {
            m.rollback();
            return null;
        }
        m.done(OPEN_TAG);
        return startTag;
    }

    private boolean parsePreContent(String open) {
        SimpleStringParser.Marker m = this.mark();
        while (!this.isCloseTag(open) && this.getTokenType() != null) {
            this.advance();
        }
        m.done(TEXT_ELEMENT);
        return true;
    }

    private boolean isCloseTag(String openTag) {
        SimpleStringParser.Marker m = this.mark();
        boolean result = this.consumeTokens(NanoMessageTokenizer.TAG_OPEN, NanoMessageTokenizer.TAG_END) && Objects.equals(this.getTokenText(), openTag) && this.consumeTokens(NanoMessageTokenizer.LIT, NanoMessageTokenizer.TAG_CLOSE);
        m.rollback();
        return result;
    }

    private boolean parseCloseTag(String openTag) {
        SimpleStringParser.Marker m = this.mark();
        if (!this.consumeTokens(NanoMessageTokenizer.TAG_OPEN, NanoMessageTokenizer.TAG_END)) {
            return this.fail(m);
        }
        String endTag = this.getTokenText();
        if (!(this.parseKey() && Objects.equals(openTag, endTag) && this.consumeTokens(NanoMessageTokenizer.TAG_CLOSE))) {
            return this.fail(m);
        }
        m.done(CLOSE_TAG);
        return true;
    }

    private boolean parseText() {
        if (this.getTokenType() == null) {
            return false;
        }
        SimpleStringParser.Marker m = this.mark();
        if (!this.consumeTokens((NanoMessageTokenizer.Token)this.getTokenType())) {
            return this.fail(m);
        }
        m.done(TEXT_ELEMENT);
        return true;
    }

    private boolean parseAttributes(Iterable<NanoMessageTokenizer.Token> delimiter) {
        SimpleStringParser.Marker m = this.mark();
        do {
            this.consumeWhiteSpaces();
            if (!this.consumeTokens(NanoMessageTokenizer.SEPARATOR)) {
                m.done(ATTRIBUTES);
                return true;
            }
            this.consumeWhiteSpaces();
        } while (this.parseAttribute(delimiter));
        return this.fail(m);
    }

    private boolean parseAttribute(Iterable<NanoMessageTokenizer.Token> delimiter) {
        SimpleStringParser.Marker m = this.mark();
        if (this.parseString()) {
            m.done(ATTRIBUTE);
            return true;
        }
        m.rollback();
        m = this.mark();
        int count = 0;
        int lastNonWhiteSpace = 0;
        while (!this.lookAheadIs(count, delimiter) && !this.lookAheadIs(count, NanoMessageTokenizer.SEPARATOR)) {
            NanoMessageTokenizer.Token lookAhead = (NanoMessageTokenizer.Token)this.lookAhead(count);
            if (lookAhead == null) {
                return this.fail(m);
            }
            if (lookAhead != NanoMessageTokenizer.WS) {
                lastNonWhiteSpace = count;
            }
            ++count;
        }
        for (int i = 0; i <= lastNonWhiteSpace; ++i) {
            this.advance();
        }
        m.done(ATTRIBUTE);
        return true;
    }

    private boolean parseKey() {
        SimpleStringParser.Marker m = this.mark();
        if (!this.consumeTokens(NanoMessageTokenizer.LIT)) {
            return this.fail(m);
        }
        m.done(KEY);
        return true;
    }

    private boolean parseString() {
        SimpleStringParser.Marker m = this.mark();
        boolean r = false;
        if (this.consumeTokens(NanoMessageTokenizer.SQUOTE)) {
            while (!this.is(NanoMessageTokenizer.SQUOTE)) {
                this.advance();
                if (this.getTokenType() != null) continue;
                m.rollback();
                return false;
            }
            r = this.consumeTokens(NanoMessageTokenizer.SQUOTE);
        } else if (this.consumeTokens(NanoMessageTokenizer.DQUOTE)) {
            while (!this.is(NanoMessageTokenizer.DQUOTE)) {
                this.advance();
                if (this.getTokenType() != null) continue;
                m.rollback();
                return false;
            }
            r = this.consumeTokens(NanoMessageTokenizer.DQUOTE);
        }
        if (!r) {
            m.rollback();
            return false;
        }
        m.done(TEXT_ELEMENT);
        return true;
    }

    private void consumeWhiteSpaces() {
        while (this.consumeTokens(NanoMessageTokenizer.WS)) {
        }
    }

    private boolean consumeTokens(NanoMessageTokenizer.Token ... types) {
        for (NanoMessageTokenizer.Token type : types) {
            if (!Objects.equals(this.getTokenType(), type)) {
                return false;
            }
            this.advance();
        }
        return true;
    }

    private boolean nextIs(NanoMessageTokenizer.Token type) {
        return Objects.equals(this.lookAhead(1), type);
    }

    private boolean nextIs(Iterable<NanoMessageTokenizer.Token> types) {
        for (NanoMessageTokenizer.Token type : types) {
            if (!this.nextIs(type)) continue;
            return true;
        }
        return false;
    }

    private boolean lookAheadIs(int steps, NanoMessageTokenizer.Token type) {
        return Objects.equals(this.lookAhead(steps), type);
    }

    private boolean lookAheadIs(int steps, Iterable<NanoMessageTokenizer.Token> types) {
        for (NanoMessageTokenizer.Token type : types) {
            if (!this.lookAheadIs(steps, type)) continue;
            return true;
        }
        return false;
    }

    private boolean is(NanoMessageTokenizer.Token type) {
        return Objects.equals(this.getTokenType(), type);
    }

    private boolean is(Iterable<NanoMessageTokenizer.Token> types) {
        for (NanoMessageTokenizer.Token type : types) {
            if (!this.is(type)) continue;
            return true;
        }
        return false;
    }

    private boolean fail(SimpleStringParser.Marker m) {
        m.rollback();
        return false;
    }
}

