/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.storage.properties;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.StorageEntry;

public class PropertiesUtils {
    private static final String SEPARATOR_FORMAT = " = ";
    private static final Pattern COMMENT = Pattern.compile("^[!#].*$");
    private static final Pattern LINE = Pattern.compile("^([a-zA-Z0-9._-]+)( *[:=] *)(.*)$");
    private static final Pattern MULTILINE = Pattern.compile("^.+[^\\\\]+(\\\\\\\\)*\\\\$");

    public static List<StorageEntry> loadProperties(Reader file) throws IOException {
        LinkedList<StorageEntry> entries = new LinkedList<StorageEntry>();
        try (BufferedReader bufferedReader = new BufferedReader(file);){
            String line;
            String key = null;
            boolean lineBroke = false;
            LinkedList<String> comments = new LinkedList<String>();
            LinkedList<String> values = new LinkedList<String>();
            int lineIndex = 0;
            while ((line = bufferedReader.readLine()) != null) {
                String first;
                ++lineIndex;
                if (!lineBroke) {
                    if (line.isEmpty()) {
                        comments.add("");
                        continue;
                    }
                    if (COMMENT.matcher(line).matches()) {
                        comments.add(line.substring(1));
                        continue;
                    }
                }
                if (lineBroke) {
                    lineBroke = MULTILINE.matcher(line).matches();
                    if (lineBroke) {
                        line = line.replaceAll("^(.+)\\\\$", "$1");
                    }
                    values.add(line);
                    if (lineBroke) {
                        continue;
                    }
                } else {
                    Matcher matcher = LINE.matcher(line);
                    if (matcher.matches()) {
                        key = matcher.group(1);
                        String value = matcher.group(3);
                        lineBroke = MULTILINE.matcher(line).matches();
                        if (lineBroke) {
                            value = value.replaceAll("^(.+)\\\\$", "$1");
                        }
                        values.add(value);
                        if (lineBroke) {
                            continue;
                        }
                    } else {
                        throw new IOException("Could not parse line " + (lineIndex - 1) + " of properties file.\n> " + line);
                    }
                }
                Object merged = "";
                if (values.size() > 1) {
                    merged = "\n" + String.join((CharSequence)"\n", values.subList(1, values.size())).stripIndent();
                }
                first = (first = (String)values.get(0)).startsWith("\"") && first.endsWith("\"") ? first.substring(1, first.length() - 1) : first;
                merged = first + (String)merged;
                String comment = comments.isEmpty() ? null : String.join((CharSequence)"\n", comments);
                entries.add(new StorageEntry(key, (String)merged, comment));
                key = null;
                values.clear();
                comments.clear();
            }
        }
        return entries;
    }

    public static void write(Writer writer, List<StorageEntry> entries) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(writer);){
            for (StorageEntry entry : entries) {
                if (entry.comment() != null) {
                    for (String comment : entry.comment().split("(?<!\\\\)\n")) {
                        bufferedWriter.write("#".repeat(comment.isEmpty() ? 0 : 1) + comment + "\n");
                    }
                }
                List<String> values = List.of(entry.value().split("\n"));
                String line = entry.key() + SEPARATOR_FORMAT + values.get(0);
                if (values.size() > 1) {
                    bufferedWriter.write(line + "\\\n");
                    String indent = " ".repeat(entry.key().length() + SEPARATOR_FORMAT.length());
                    for (int i = 1; i < values.size(); ++i) {
                        bufferedWriter.write(indent + values.get(i) + (i == values.size() - 1 ? "\n" : "\\\n"));
                    }
                    continue;
                }
                bufferedWriter.write(line + "\n");
            }
        }
    }
}

