/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.veinminer;

import de.miraculixx.kpaper.event.SingleListener;
import de.miraculixx.kpaper.extensions.GeneralExtensionsKt;
import de.miraculixx.kpaper.main.KPaperConfiguration;
import de.miraculixx.kpaper.main.KSpigotKt;
import de.miraculixx.kpaper.runnables.KPaperRunnablesKt;
import de.miraculixx.veinminer.Veinminer;
import de.miraculixx.veinminer.VeinminerCompatibility;
import de.miraculixx.veinminer.config.ConfigManager;
import de.miraculixx.veinminer.config.data.BlockGroup;
import de.miraculixx.veinminer.config.data.FixedBlockGroup;
import de.miraculixx.veinminer.config.data.VeinminerSettings;
import de.miraculixx.veinminer.networking.PaperNetworking;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004*+,-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u000fH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u00020\u001f*\u00020\u00192\u0006\u0010 \u001a\u00020\bJ\u0014\u0010!\u001a\u00020\"*\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010'\u001a\u00020\"*\u00020\u001dH\u0002J\u0014\u0010(\u001a\u00020\u001f*\u00020\u001d2\u0006\u0010)\u001a\u00020%H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u00a8\u0006."}, d2={"Lde/miraculixx/veinminer/VeinMinerEvent;", "", "<init>", "()V", "cooldown", "", "Ljava/util/UUID;", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "groupedBlocks", "Lde/miraculixx/veinminer/config/data/FixedBlockGroup;", "Lorg/bukkit/NamespacedKey;", "onBlockBreak", "Lde/miraculixx/kpaper/event/SingleListener;", "Lorg/bukkit/event/block/BlockBreakEvent;", "getOnBlockBreak$annotations", "getPreferredToolIcon", "", "type", "Lorg/bukkit/Material;", "allowedToVeinmine", "Lde/miraculixx/veinminer/VeinMinerEvent$VeinmineAction;", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "veinmine", "", "shouldBreak", "triggerBreaking", "", "damageItem", "item", "Lorg/bukkit/inventory/ItemStack;", "amount", "destroy", "getXP", "tool", "VeinminerEvent", "VeinminerDropEvent", "VeinmineAction", "VeinmineBlock", "veinminer-paper"})
@SourceDebugExtension(value={"SMAP\nVeinMinerEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VeinMinerEvent.kt\nde/miraculixx/veinminer/VeinMinerEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Listeners.kt\nde/miraculixx/kpaper/event/ListenersKt\n*L\n1#1,286:1\n1869#2,2:287\n1869#2:292\n1869#2:293\n1869#2,2:294\n1870#2:296\n1870#2:297\n188#3,3:289\n69#4,10:298\n52#4,9:308\n79#4:317\n*S KotlinDebug\n*F\n+ 1 VeinMinerEvent.kt\nde/miraculixx/veinminer/VeinMinerEvent\n*L\n43#1:287,2\n188#1:292\n189#1:293\n190#1:294,2\n189#1:296\n188#1:297\n142#1:289,3\n54#1:298,10\n54#1:308,9\n54#1:317\n*E\n"})
public final class VeinMinerEvent {
    @NotNull
    public static final VeinMinerEvent INSTANCE = new VeinMinerEvent();
    @NotNull
    private static final Set<UUID> cooldown = new LinkedHashSet();
    private static boolean enabled = true;
    @NotNull
    private static final SingleListener<BlockBreakEvent> onBlockBreak;

    private VeinMinerEvent() {
    }

    public final boolean getEnabled() {
        return enabled;
    }

    public final void setEnabled(boolean bl) {
        enabled = bl;
    }

    private final FixedBlockGroup<NamespacedKey> groupedBlocks(NamespacedKey $this$groupedBlocks) {
        Set blocks = new LinkedHashSet();
        Set tools = new LinkedHashSet();
        Iterable $this$forEach$iv = ConfigManager.INSTANCE.getGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockGroup it = (BlockGroup)element$iv;
            boolean bl = false;
            if (!it.getBlocks().contains($this$groupedBlocks)) continue;
            blocks.addAll(it.getBlocks());
            tools.addAll(it.getTools());
        }
        return new FixedBlockGroup<NamespacedKey>(CollectionsKt.toSet((Iterable)blocks), CollectionsKt.toSet((Iterable)tools));
    }

    private static /* synthetic */ void getOnBlockBreak$annotations() {
    }

    @NotNull
    public final String getPreferredToolIcon(@NotNull Material type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Tag.MINEABLE_AXE.isTagged((Keyed)type) ? "axe" : (Tag.MINEABLE_SHOVEL.isTagged((Keyed)type) ? "shovel" : (Tag.MINEABLE_HOE.isTagged((Keyed)type) ? "hoe" : "pickaxe"));
    }

    @Nullable
    public final VeinmineAction allowedToVeinmine(@NotNull Player player, @NotNull Block block) {
        boolean isWhitelisted;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (player.getGameMode() == GameMode.CREATIVE) {
            return null;
        }
        NamespacedKey namespacedKey = block.getType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)namespacedKey, (String)"getKey(...)");
        NamespacedKey material = namespacedKey;
        VeinminerSettings settings = ConfigManager.INSTANCE.getSettings();
        if (settings.getPermissionRestricted() && !player.hasPermission("veinminer.use")) {
            return null;
        }
        boolean hasClientBypass = settings.getClient().getAllBlocks() && PaperNetworking.INSTANCE.getRegisteredPlayers().containsKey(player.getUniqueId());
        FixedBlockGroup<NamespacedKey> blockGroup = this.groupedBlocks(material);
        boolean isGroupBlock = !((Collection)blockGroup.getBlocks()).isEmpty();
        boolean bl = isWhitelisted = isGroupBlock || ConfigManager.INSTANCE.getVeinBlocks().contains(material);
        if (!isWhitelisted && !hasClientBypass) {
            return null;
        }
        if (settings.getMustSneak() && !player.isSneaking()) {
            return null;
        }
        if (cooldown.contains(player.getUniqueId())) {
            return null;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        ItemStack item = itemStack;
        if (settings.getNeedCorrectTool() && (block.getDrops(item).isEmpty() || item.isEmpty())) {
            return null;
        }
        if (isGroupBlock && !blockGroup.getTools().isEmpty() && !blockGroup.getTools().contains(item.getType().getKey())) {
            return null;
        }
        if (Veinminer.Companion.getEnchantmentActive()) {
            boolean bl2;
            block12: {
                Map map = item.getEnchantments();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchantments(...)");
                Map $this$any$iv = map;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)((Enchantment)it.getKey()).getKey(), (Object)Veinminer.Companion.getVEINMINE())) continue;
                        bl2 = true;
                        break block12;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) {
                return null;
            }
        }
        Set blocks = isGroupBlock ? blockGroup.getBlocks() : SetsKt.setOf((Object)material);
        Set set = new LinkedHashSet();
        Location location = block.getLocation().toCenterLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toCenterLocation(...)");
        return new VeinmineAction(block, blocks, item, set, player, location, settings);
    }

    public final int veinmine(@NotNull VeinmineAction $this$veinmine, boolean shouldBreak) {
        Intrinsics.checkNotNullParameter((Object)$this$veinmine, (String)"<this>");
        Queue queue = new LinkedList();
        queue.add(new VeinmineBlock($this$veinmine.getCurrentBlock(), 0));
        while (!((Collection)queue).isEmpty()) {
            int size;
            VeinmineBlock vBlock = (VeinmineBlock)queue.poll();
            Block block = vBlock.getBlock();
            if (!$this$veinmine.getTargetTypes().contains(block.getType().getKey()) || $this$veinmine.getProcessedBlocks().contains(block) || (size = $this$veinmine.getProcessedBlocks().size()) >= $this$veinmine.getSettings().getMaxChain() || $this$veinmine.getSettings().getNeedCorrectTool() && $this$veinmine.getTool().isEmpty()) continue;
            if (shouldBreak) {
                long tickDelay = $this$veinmine.getSettings().getDelay() * vBlock.getDistance();
                if (VeinminerCompatibility.INSTANCE.getRunsAsync()) {
                    if (tickDelay == 0L) {
                        GeneralExtensionsKt.getServer().getRegionScheduler().execute((Plugin)Veinminer.Companion.getINSTANCE(), block.getLocation(), () -> VeinMinerEvent.veinmine$lambda$4($this$veinmine, block));
                    } else {
                        ScheduledTask scheduledTask = GeneralExtensionsKt.getServer().getRegionScheduler().runDelayed((Plugin)Veinminer.Companion.getINSTANCE(), block.getLocation(), arg_0 -> VeinMinerEvent.veinmine$lambda$5($this$veinmine, block, arg_0), tickDelay);
                        Intrinsics.checkNotNull((Object)scheduledTask);
                    }
                } else {
                    KPaperRunnablesKt.taskRunLater((long)tickDelay, (boolean)true, () -> VeinMinerEvent.veinmine$lambda$6($this$veinmine, block));
                }
            }
            $this$veinmine.getProcessedBlocks().add(block);
            int searchRadius = $this$veinmine.getSettings().getSearchRadius();
            Iterable $this$forEach$iv = (Iterable)new IntRange(-searchRadius, searchRadius);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int x = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Iterable $this$forEach$iv2 = (Iterable)new IntRange(-searchRadius, searchRadius);
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    int element$iv2;
                    int y = element$iv2 = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    Iterable $this$forEach$iv3 = (Iterable)new IntRange(-searchRadius, searchRadius);
                    boolean $i$f$forEach3 = false;
                    Iterator iterator3 = $this$forEach$iv3.iterator();
                    while (iterator3.hasNext()) {
                        Block newBlock;
                        int element$iv3;
                        int z = element$iv3 = ((IntIterator)iterator3).nextInt();
                        boolean bl3 = false;
                        if (x == 0 && y == 0 && z == 0) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z), (String)"getBlockAt(...)");
                        queue.add(new VeinmineBlock(newBlock, vBlock.getDistance() + 1));
                    }
                }
            }
        }
        return $this$veinmine.getProcessedBlocks().size();
    }

    private final void triggerBreaking(VeinmineAction $this$triggerBreaking, Block block) {
        if (!VeinminerCompatibility.INSTANCE.getRunsAsync() && $this$triggerBreaking.getSettings().getDelay() != 0 && !$this$triggerBreaking.getTargetTypes().contains(block.getType().getKey())) {
            return;
        }
        VeinminerEvent veinminerEvent = new VeinminerEvent(block, $this$triggerBreaking.getPlayer(), $this$triggerBreaking.getSourceLocation(), this.getXP(block, $this$triggerBreaking.getTool()));
        if (!veinminerEvent.callEvent()) {
            return;
        }
        this.destroy(block);
        if ($this$triggerBreaking.getSettings().getDecreaseDurability()) {
            this.damageItem($this$triggerBreaking.getTool(), 1, $this$triggerBreaking.getPlayer());
        }
    }

    private final boolean damageItem(ItemStack item, int amount, Player player) {
        if (item.isEmpty()) {
            return false;
        }
        if (item.getType().getMaxDurability() == 0 || item.isEmpty()) {
            return false;
        }
        return item.damage(amount, (LivingEntity)player).isEmpty();
    }

    private final void destroy(Block $this$destroy) {
        Location location = $this$destroy.getLocation().toCenterLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toCenterLocation(...)");
        Location center = location;
        $this$destroy.getWorld().playSound(center, $this$destroy.getBlockSoundGroup().getBreakSound(), 1.0f, 1.0f);
        $this$destroy.getWorld().spawnParticle(Particle.BLOCK, center, 20, (Object)$this$destroy.getBlockData());
        $this$destroy.setType(Material.AIR);
    }

    private final int getXP(Block $this$getXP, ItemStack tool) {
        Intrinsics.checkNotNull((Object)$this$getXP, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.block.CraftBlock");
        CraftBlock craftBlock = (CraftBlock)$this$getXP;
        net.minecraft.world.level.block.state.BlockState nmsState = craftBlock.getNMS();
        Intrinsics.checkNotNull((Object)tool, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.inventory.CraftItemStack");
        net.minecraft.world.item.ItemStack nmsItem = ((CraftItemStack)tool).handle;
        return nmsState.getBlock().getExpDrop(nmsState, craftBlock.getHandle().getMinecraftWorld(), craftBlock.getPosition(), nmsItem, true);
    }

    private static final void veinmine$lambda$4(VeinmineAction $this_veinmine, Block $block) {
        INSTANCE.triggerBreaking($this_veinmine, $block);
    }

    private static final void veinmine$lambda$5(VeinmineAction $this_veinmine, Block $block, ScheduledTask it) {
        INSTANCE.triggerBreaking($this_veinmine, $block);
    }

    private static final Unit veinmine$lambda$6(VeinmineAction $this_veinmine, Block $block) {
        INSTANCE.triggerBreaking($this_veinmine, $block);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Set access$getCooldown$p() {
        return cooldown;
    }

    static {
        EventPriority priority$iv = EventPriority.HIGH;
        boolean ignoreCancelled$iv = KPaperConfiguration.Events.INSTANCE.getIgnoreCancelled();
        boolean register$iv = KPaperConfiguration.Events.INSTANCE.getAutoRegistration();
        boolean $i$f$listen = false;
        SingleListener<BlockBreakEvent> listener$iv = new SingleListener<BlockBreakEvent>(priority$iv, ignoreCancelled$iv){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void onEvent(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                BlockBreakEvent it = (BlockBreakEvent)event;
                boolean bl = false;
                if (!it.isCancelled() && VeinMinerEvent.INSTANCE.getEnabled()) {
                    Player player = it.getPlayer();
                    Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                    Player player2 = player;
                    VeinminerSettings settings = ConfigManager.INSTANCE.getSettings();
                    Block block = it.getBlock();
                    Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
                    Block block2 = block;
                    if (it instanceof VeinminerEvent) {
                        if (((VeinminerEvent)it).isDropItems()) {
                            Location location;
                            ItemStack itemStack = player2.getInventory().getItemInMainHand();
                            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
                            ItemStack tool = itemStack;
                            Collection collection = block2.getDrops(tool, (Entity)player2);
                            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDrops(...)");
                            List drops = CollectionsKt.toMutableList((Collection)collection);
                            BlockState blockState = block2.getState();
                            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
                            VeinminerDropEvent veinminerDropEvent = new VeinminerDropEvent(block2, blockState, player2, drops, ((VeinminerEvent)it).getExpToDrop());
                            Event p0 = (Event)veinminerDropEvent;
                            boolean bl2 = false;
                            p0.callEvent();
                            VeinminerDropEvent dropItemEvent = veinminerDropEvent;
                            if (settings.getMergeItemDrops()) {
                                location = ((VeinminerEvent)it).getSourceLocation();
                            } else {
                                Location location2 = block2.getLocation().toCenterLocation();
                                location = location2;
                                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"toCenterLocation(...)");
                            }
                            Location location3 = location;
                            Iterable $this$forEach$iv = drops;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                ItemStack drop = (ItemStack)element$iv;
                                boolean bl3 = false;
                                block2.getWorld().dropItem(location3, drop);
                            }
                            if (dropItemEvent.getExp() > 0) {
                                ((ExperienceOrb)block2.getWorld().spawn(location3, ExperienceOrb.class)).setExperience(dropItemEvent.getExp());
                            }
                            ((VeinminerEvent)it).setDropItems(false);
                            ((VeinminerEvent)it).setExpToDrop(0);
                        }
                    } else {
                        UUID uUID = player2.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                        UUID uuid = uUID;
                        if (!PaperNetworking.INSTANCE.getRegisteredPlayers().containsKey(uuid) || PaperNetworking.INSTANCE.getReadyToVeinmine().contains(uuid)) {
                            VeinmineAction veinmineAction = VeinMinerEvent.INSTANCE.allowedToVeinmine(player2, block2);
                            if (veinmineAction != null) {
                                VeinmineAction veinmineInfo = veinmineAction;
                                it.setCancelled(true);
                                VeinMinerEvent.INSTANCE.veinmine(veinmineInfo, true);
                                int cooldownTime = settings.getCooldown();
                                if (cooldownTime > 0) {
                                    Set set = VeinMinerEvent.access$getCooldown$p();
                                    UUID uUID2 = player2.getUniqueId();
                                    Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUniqueId(...)");
                                    set.add(uUID2);
                                    BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(cooldownTime, player2, null){
                                        int label;
                                        final /* synthetic */ int $cooldownTime;
                                        final /* synthetic */ Player $player;
                                        {
                                            this.$cooldownTime = $cooldownTime;
                                            this.$player = $player;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        public final Object invokeSuspend(Object var1_1) {
                                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    this.label = 1;
                                                    v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)(this.$cooldownTime * 50), (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                                                    if (v0 == var2_2) {
                                                        return var2_2;
                                                    }
                                                    ** GOTO lbl14
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl14:
                                                    // 2 sources

                                                    VeinMinerEvent.access$getCooldown$p().remove(this.$player.getUniqueId());
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                            }
                        }
                    }
                }
            }
        };
        if (register$iv) {
            SingleListener $this$register$iv$iv = (SingleListener)listener$iv;
            boolean $i$f$register = false;
            GeneralExtensionsKt.getPluginManager().registerEvent(BlockBreakEvent.class, (Listener)$this$register$iv$iv, $this$register$iv$iv.getPriority(), new EventExecutor($this$register$iv$iv){
                final /* synthetic */ SingleListener $this_register;
                {
                    this.$this_register = $receiver;
                }

                public final void execute(@NotNull Listener listener, @NotNull Event event) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)listener, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Event event2 = event;
                        if (!(event2 instanceof BlockBreakEvent)) {
                            event2 = null;
                        }
                        Event event3 = (Event)((BlockBreakEvent)event2);
                        if (event3 == null) break block1;
                        Event event4 = event3;
                        SingleListener singleListener = this.$this_register;
                        Event it = event4;
                        boolean bl = false;
                        singleListener.onEvent(it);
                    }
                }
            }, (Plugin)KSpigotKt.getPluginInstance(), $this$register$iv$iv.getIgnoreCancelled());
        }
        onBlockBreak = (SingleListener)listener$iv;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003J\t\u0010$\u001a\u00020\fH\u00c6\u0003J\t\u0010%\u001a\u00020\u000eH\u00c6\u0003J\t\u0010&\u001a\u00020\u0010H\u00c6\u0003J[\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"Lde/miraculixx/veinminer/VeinMinerEvent$VeinmineAction;", "", "currentBlock", "Lorg/bukkit/block/Block;", "targetTypes", "", "Lorg/bukkit/NamespacedKey;", "tool", "Lorg/bukkit/inventory/ItemStack;", "processedBlocks", "", "player", "Lorg/bukkit/entity/Player;", "sourceLocation", "Lorg/bukkit/Location;", "settings", "Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "<init>", "(Lorg/bukkit/block/Block;Ljava/util/Set;Lorg/bukkit/inventory/ItemStack;Ljava/util/Set;Lorg/bukkit/entity/Player;Lorg/bukkit/Location;Lde/miraculixx/veinminer/config/data/VeinminerSettings;)V", "getCurrentBlock", "()Lorg/bukkit/block/Block;", "getTargetTypes", "()Ljava/util/Set;", "getTool", "()Lorg/bukkit/inventory/ItemStack;", "getProcessedBlocks", "getPlayer", "()Lorg/bukkit/entity/Player;", "getSourceLocation", "()Lorg/bukkit/Location;", "getSettings", "()Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "", "veinminer-paper"})
    public static final class VeinmineAction {
        @NotNull
        private final Block currentBlock;
        @NotNull
        private final Set<NamespacedKey> targetTypes;
        @NotNull
        private final ItemStack tool;
        @NotNull
        private final Set<Block> processedBlocks;
        @NotNull
        private final Player player;
        @NotNull
        private final Location sourceLocation;
        @NotNull
        private final VeinminerSettings settings;

        public VeinmineAction(@NotNull Block currentBlock, @NotNull Set<NamespacedKey> targetTypes, @NotNull ItemStack tool, @NotNull Set<Block> processedBlocks, @NotNull Player player, @NotNull Location sourceLocation, @NotNull VeinminerSettings settings) {
            Intrinsics.checkNotNullParameter((Object)currentBlock, (String)"currentBlock");
            Intrinsics.checkNotNullParameter(targetTypes, (String)"targetTypes");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter(processedBlocks, (String)"processedBlocks");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)sourceLocation, (String)"sourceLocation");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.currentBlock = currentBlock;
            this.targetTypes = targetTypes;
            this.tool = tool;
            this.processedBlocks = processedBlocks;
            this.player = player;
            this.sourceLocation = sourceLocation;
            this.settings = settings;
        }

        @NotNull
        public final Block getCurrentBlock() {
            return this.currentBlock;
        }

        @NotNull
        public final Set<NamespacedKey> getTargetTypes() {
            return this.targetTypes;
        }

        @NotNull
        public final ItemStack getTool() {
            return this.tool;
        }

        @NotNull
        public final Set<Block> getProcessedBlocks() {
            return this.processedBlocks;
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @NotNull
        public final Location getSourceLocation() {
            return this.sourceLocation;
        }

        @NotNull
        public final VeinminerSettings getSettings() {
            return this.settings;
        }

        @NotNull
        public final Block component1() {
            return this.currentBlock;
        }

        @NotNull
        public final Set<NamespacedKey> component2() {
            return this.targetTypes;
        }

        @NotNull
        public final ItemStack component3() {
            return this.tool;
        }

        @NotNull
        public final Set<Block> component4() {
            return this.processedBlocks;
        }

        @NotNull
        public final Player component5() {
            return this.player;
        }

        @NotNull
        public final Location component6() {
            return this.sourceLocation;
        }

        @NotNull
        public final VeinminerSettings component7() {
            return this.settings;
        }

        @NotNull
        public final VeinmineAction copy(@NotNull Block currentBlock, @NotNull Set<NamespacedKey> targetTypes, @NotNull ItemStack tool, @NotNull Set<Block> processedBlocks, @NotNull Player player, @NotNull Location sourceLocation, @NotNull VeinminerSettings settings) {
            Intrinsics.checkNotNullParameter((Object)currentBlock, (String)"currentBlock");
            Intrinsics.checkNotNullParameter(targetTypes, (String)"targetTypes");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter(processedBlocks, (String)"processedBlocks");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)sourceLocation, (String)"sourceLocation");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return new VeinmineAction(currentBlock, targetTypes, tool, processedBlocks, player, sourceLocation, settings);
        }

        public static /* synthetic */ VeinmineAction copy$default(VeinmineAction veinmineAction, Block block, Set set, ItemStack itemStack, Set set2, Player player, Location location, VeinminerSettings veinminerSettings, int n, Object object) {
            if ((n & 1) != 0) {
                block = veinmineAction.currentBlock;
            }
            if ((n & 2) != 0) {
                set = veinmineAction.targetTypes;
            }
            if ((n & 4) != 0) {
                itemStack = veinmineAction.tool;
            }
            if ((n & 8) != 0) {
                set2 = veinmineAction.processedBlocks;
            }
            if ((n & 0x10) != 0) {
                player = veinmineAction.player;
            }
            if ((n & 0x20) != 0) {
                location = veinmineAction.sourceLocation;
            }
            if ((n & 0x40) != 0) {
                veinminerSettings = veinmineAction.settings;
            }
            return veinmineAction.copy(block, set, itemStack, set2, player, location, veinminerSettings);
        }

        @NotNull
        public String toString() {
            return "VeinmineAction(currentBlock=" + this.currentBlock + ", targetTypes=" + this.targetTypes + ", tool=" + this.tool + ", processedBlocks=" + this.processedBlocks + ", player=" + this.player + ", sourceLocation=" + this.sourceLocation + ", settings=" + this.settings + ")";
        }

        public int hashCode() {
            int result = this.currentBlock.hashCode();
            result = result * 31 + ((Object)this.targetTypes).hashCode();
            result = result * 31 + this.tool.hashCode();
            result = result * 31 + ((Object)this.processedBlocks).hashCode();
            result = result * 31 + this.player.hashCode();
            result = result * 31 + this.sourceLocation.hashCode();
            result = result * 31 + this.settings.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VeinmineAction)) {
                return false;
            }
            VeinmineAction veinmineAction = (VeinmineAction)other;
            if (!Intrinsics.areEqual((Object)this.currentBlock, (Object)veinmineAction.currentBlock)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.targetTypes, veinmineAction.targetTypes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tool, (Object)veinmineAction.tool)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.processedBlocks, veinmineAction.processedBlocks)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.player, (Object)veinmineAction.player)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sourceLocation, (Object)veinmineAction.sourceLocation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.settings, (Object)veinmineAction.settings);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lde/miraculixx/veinminer/VeinMinerEvent$VeinmineBlock;", "", "block", "Lorg/bukkit/block/Block;", "distance", "", "<init>", "(Lorg/bukkit/block/Block;I)V", "getBlock", "()Lorg/bukkit/block/Block;", "getDistance", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "veinminer-paper"})
    public static final class VeinmineBlock {
        @NotNull
        private final Block block;
        private final int distance;

        public VeinmineBlock(@NotNull Block block, int distance) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.block = block;
            this.distance = distance;
        }

        @NotNull
        public final Block getBlock() {
            return this.block;
        }

        public final int getDistance() {
            return this.distance;
        }

        @NotNull
        public final Block component1() {
            return this.block;
        }

        public final int component2() {
            return this.distance;
        }

        @NotNull
        public final VeinmineBlock copy(@NotNull Block block, int distance) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return new VeinmineBlock(block, distance);
        }

        public static /* synthetic */ VeinmineBlock copy$default(VeinmineBlock veinmineBlock, Block block, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                block = veinmineBlock.block;
            }
            if ((n2 & 2) != 0) {
                n = veinmineBlock.distance;
            }
            return veinmineBlock.copy(block, n);
        }

        @NotNull
        public String toString() {
            return "VeinmineBlock(block=" + this.block + ", distance=" + this.distance + ")";
        }

        public int hashCode() {
            int result = this.block.hashCode();
            result = result * 31 + Integer.hashCode(this.distance);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VeinmineBlock)) {
                return false;
            }
            VeinmineBlock veinmineBlock = (VeinmineBlock)other;
            if (!Intrinsics.areEqual((Object)this.block, (Object)veinmineBlock.block)) {
                return false;
            }
            return this.distance == veinmineBlock.distance;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lde/miraculixx/veinminer/VeinMinerEvent$VeinminerDropEvent;", "Lorg/bukkit/event/block/BlockExpEvent;", "block", "Lorg/bukkit/block/Block;", "blockState", "Lorg/bukkit/block/BlockState;", "player", "Lorg/bukkit/entity/Player;", "items", "", "Lorg/bukkit/inventory/ItemStack;", "exp", "", "<init>", "(Lorg/bukkit/block/Block;Lorg/bukkit/block/BlockState;Lorg/bukkit/entity/Player;Ljava/util/List;I)V", "getBlockState", "()Lorg/bukkit/block/BlockState;", "getPlayer", "()Lorg/bukkit/entity/Player;", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "getExp", "()I", "setExp", "(I)V", "veinminer-paper"})
    public static final class VeinminerDropEvent
    extends BlockExpEvent {
        @NotNull
        private final BlockState blockState;
        @NotNull
        private final Player player;
        @NotNull
        private List<ItemStack> items;
        private int exp;

        public VeinminerDropEvent(@NotNull Block block, @NotNull BlockState blockState, @NotNull Player player, @NotNull List<ItemStack> items, int exp) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            super(block, exp);
            this.blockState = blockState;
            this.player = player;
            this.items = items;
            this.exp = exp;
        }

        @NotNull
        public final BlockState getBlockState() {
            return this.blockState;
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @NotNull
        public final List<ItemStack> getItems() {
            return this.items;
        }

        public final void setItems(@NotNull List<ItemStack> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.items = list;
        }

        public final int getExp() {
            return this.exp;
        }

        public final void setExp(int n) {
            this.exp = n;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lde/miraculixx/veinminer/VeinMinerEvent$VeinminerEvent;", "Lorg/bukkit/event/block/BlockBreakEvent;", "block", "Lorg/bukkit/block/Block;", "breaker", "Lorg/bukkit/entity/Player;", "sourceLocation", "Lorg/bukkit/Location;", "exp", "", "<init>", "(Lorg/bukkit/block/Block;Lorg/bukkit/entity/Player;Lorg/bukkit/Location;I)V", "getSourceLocation", "()Lorg/bukkit/Location;", "veinminer-paper"})
    public static final class VeinminerEvent
    extends BlockBreakEvent {
        @NotNull
        private final Location sourceLocation;

        public VeinminerEvent(@NotNull Block block, @NotNull Player breaker, @NotNull Location sourceLocation, int exp) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)breaker, (String)"breaker");
            Intrinsics.checkNotNullParameter((Object)sourceLocation, (String)"sourceLocation");
            super(block, breaker);
            this.sourceLocation = sourceLocation;
            this.setExpToDrop(exp);
        }

        @NotNull
        public final Location getSourceLocation() {
            return this.sourceLocation;
        }
    }
}

