/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.veinminer.networking;

import de.miraculixx.kpaper.event.SingleListener;
import de.miraculixx.kpaper.extensions.GeneralExtensionsKt;
import de.miraculixx.kpaper.main.KPaperConfiguration;
import de.miraculixx.kpaper.main.KSpigotKt;
import de.miraculixx.veinminer.VeinMinerEvent;
import de.miraculixx.veinminer.Veinminer;
import de.miraculixx.veinminer.config.ConfigManager;
import de.miraculixx.veinminer.config.data.BlockPosition;
import de.miraculixx.veinminer.config.data.VeinminerSettings;
import de.miraculixx.veinminer.config.network.BlockHighlighting;
import de.miraculixx.veinminer.config.network.JoinInformation;
import de.miraculixx.veinminer.config.network.KeyPress;
import de.miraculixx.veinminer.config.network.RequestBlockVein;
import de.miraculixx.veinminer.config.network.ServerConfiguration;
import de.miraculixx.veinminer.config.utils.GlobalsKt;
import de.miraculixx.veinminer.networking.PacketsKt;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.modules.SerializersModule;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ*\u0010\u001b\u001a\u00020\u000f\"\u0006\b\u0000\u0010\u001c\u0018\u0001*\u00020\u00072\u0006\u0010\u001d\u001a\u0002H\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0082\b\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/miraculixx/veinminer/networking/PaperNetworking;", "", "<init>", "()V", "registeredPlayers", "", "Ljava/util/UUID;", "", "getRegisteredPlayers", "()Ljava/util/Map;", "readyToVeinmine", "", "getReadyToVeinmine", "()Ljava/util/Set;", "onJoinPacket", "", "Lkotlin/Unit;", "onPress", "onMine", "onDisconnect", "Lde/miraculixx/kpaper/event/SingleListener;", "Lorg/bukkit/event/player/PlayerQuitEvent;", "sendConfiguration", "player", "Lorg/bukkit/entity/Player;", "settings", "Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "send", "T", "data", "(Ljava/lang/String;Ljava/lang/Object;Lorg/bukkit/entity/Player;)V", "writeVarInt", "outputStream", "Ljava/io/ByteArrayOutputStream;", "value", "", "veinminer-paper"})
@SourceDebugExtension(value={"SMAP\nPaperNetworking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaperNetworking.kt\nde/miraculixx/veinminer/networking/PaperNetworking\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Packets.kt\nde/miraculixx/veinminer/networking/PacketsKt\n+ 4 Listeners.kt\nde/miraculixx/kpaper/event/ListenersKt\n*L\n1#1,115:1\n82#1,4:116\n86#1,16:121\n186#2:120\n186#2:137\n28#3,2:138\n43#3:140\n28#3,2:141\n43#3:143\n28#3,2:144\n43#3:146\n69#4,10:147\n52#4,9:157\n79#4:166\n*S KotlinDebug\n*F\n+ 1 PaperNetworking.kt\nde/miraculixx/veinminer/networking/PaperNetworking\n*L\n75#1:116,4\n75#1:121,16\n75#1:120\n85#1:137\n27#1:138,2\n27#1:140\n39#1:141,2\n39#1:143\n46#1:144,2\n46#1:146\n66#1:147,10\n66#1:157,9\n66#1:166\n*E\n"})
public final class PaperNetworking {
    @NotNull
    public static final PaperNetworking INSTANCE = new PaperNetworking();
    @NotNull
    private static final Map<UUID, String> registeredPlayers = new LinkedHashMap();
    @NotNull
    private static final Set<UUID> readyToVeinmine = new LinkedHashSet();
    @NotNull
    private static final Unit onJoinPacket;
    @NotNull
    private static final Unit onPress;
    @NotNull
    private static final Unit onMine;
    @NotNull
    private static final SingleListener<PlayerQuitEvent> onDisconnect;

    private PaperNetworking() {
    }

    @NotNull
    public final Map<UUID, String> getRegisteredPlayers() {
        return registeredPlayers;
    }

    @NotNull
    public final Set<UUID> getReadyToVeinmine() {
        return readyToVeinmine;
    }

    /*
     * WARNING - void declaration
     */
    public final void sendConfiguration(@NotNull Player player, @NotNull VeinminerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (!registeredPlayers.containsKey(player.getUniqueId())) {
            return;
        }
        ServerConfiguration conf = new ServerConfiguration(settings.getCooldown(), settings.getMustSneak(), false, settings.getClient().getTranslucentBlockHighlight());
        PaperNetworking paperNetworking = this;
        String $this$send$iv = PacketsKt.getPACKET_CONFIGURATION();
        boolean $i$f$send = false;
        try {
            void this_$iv;
            BinaryFormat $this$encodeToByteArray$iv$iv = (BinaryFormat)Cbor.Default;
            boolean $i$f$encodeToByteArray = false;
            $this$encodeToByteArray$iv$iv.getSerializersModule();
            byte[] payload$iv = $this$encodeToByteArray$iv$iv.encodeToByteArray((SerializationStrategy)ServerConfiguration.Companion.serializer(), (Object)conf);
            ByteArrayOutputStream baos$iv = new ByteArrayOutputStream();
            ((PaperNetworking)this_$iv).writeVarInt(baos$iv, payload$iv.length);
            baos$iv.write(payload$iv);
            if (GlobalsKt.getDebug()) {
                Veinminer.Companion.getINSTANCE().getLogger().info("Sending packet " + $this$send$iv + " (" + payload$iv.length + ") to " + player.getName());
            }
            player.sendPluginMessage((Plugin)Veinminer.Companion.getINSTANCE(), $this$send$iv, baos$iv.toByteArray());
        }
        catch (Exception e$iv) {
            Veinminer.Companion.getINSTANCE().getLogger().warning("Failed to encode packet " + $this$send$iv + ": " + e$iv.getMessage());
            e$iv.printStackTrace();
        }
    }

    private final /* synthetic */ <T> void send(String $this$send, T data, Player player) {
        boolean $i$f$send = false;
        try {
            BinaryFormat $this$encodeToByteArray$iv = (BinaryFormat)Cbor.Default;
            boolean $i$f$encodeToByteArray = false;
            SerializersModule serializersModule = $this$encodeToByteArray$iv.getSerializersModule();
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            byte[] payload = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), data);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeVarInt(baos, payload.length);
            baos.write(payload);
            if (GlobalsKt.getDebug()) {
                Veinminer.Companion.getINSTANCE().getLogger().info("Sending packet " + $this$send + " (" + payload.length + ") to " + player.getName());
            }
            player.sendPluginMessage((Plugin)Veinminer.Companion.getINSTANCE(), $this$send, baos.toByteArray());
        }
        catch (Exception e) {
            Veinminer.Companion.getINSTANCE().getLogger().warning("Failed to encode packet " + $this$send + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private final void writeVarInt(ByteArrayOutputStream outputStream, int value) {
        int val1 = value;
        do {
            int temp = val1 & 0x7F;
            if ((val1 >>>= 7) != 0) {
                temp |= 0x80;
            }
            outputStream.write(temp);
        } while (val1 != 0);
    }

    static {
        String packetID$iv = "join";
        boolean $i$f$c2sPacket = false;
        String identifier$iv = "veinminer:" + packetID$iv;
        GeneralExtensionsKt.getServer().getMessenger().registerIncomingPluginChannel((Plugin)Veinminer.Companion.getINSTANCE(), identifier$iv, new PluginMessageListener(identifier$iv){
            final /* synthetic */ String $identifier;
            {
                this.$identifier = $identifier;
            }

            /*
             * WARNING - void declaration
             */
            public final void onPluginMessageReceived(String channel, Player player, byte[] message) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                byte[] payload = ArraysKt.copyOfRange((byte[])message, (int)1, (int)message.length);
                try {
                    BinaryFormat $this$decodeFromByteArray$iv = (BinaryFormat)Cbor.Default;
                    boolean $i$f$decodeFromByteArray = false;
                    $this$decodeFromByteArray$iv.getSerializersModule();
                    Object data = $this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)JoinInformation.Companion.serializer(), payload);
                    JoinInformation joinInformation = (JoinInformation)data;
                    Player player2 = player;
                    boolean bl = false;
                    UUID uUID = player2.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                    UUID uuid = uUID;
                    VeinminerSettings settings = ConfigManager.INSTANCE.getSettings();
                    if (settings.getClient().getAllow()) {
                        void packet;
                        Veinminer.Companion.getINSTANCE().getLogger().info(player2.getName() + " joined with Veinminer version " + packet.getVeinminerClientVersion());
                        PaperNetworking.INSTANCE.getRegisteredPlayers().put(uuid, packet.getVeinminerClientVersion());
                        PaperNetworking.INSTANCE.sendConfiguration(player2, settings);
                    }
                }
                catch (Exception e) {
                    Veinminer.Companion.getINSTANCE().getLogger().warning("Failed to decode packet " + this.$identifier + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        onJoinPacket = Unit.INSTANCE;
        packetID$iv = "key";
        $i$f$c2sPacket = false;
        identifier$iv = "veinminer:" + packetID$iv;
        GeneralExtensionsKt.getServer().getMessenger().registerIncomingPluginChannel((Plugin)Veinminer.Companion.getINSTANCE(), identifier$iv, new PluginMessageListener(identifier$iv){
            final /* synthetic */ String $identifier;
            {
                this.$identifier = $identifier;
            }

            /*
             * WARNING - void declaration
             */
            public final void onPluginMessageReceived(String channel, Player player, byte[] message) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                byte[] payload = ArraysKt.copyOfRange((byte[])message, (int)1, (int)message.length);
                try {
                    void packet;
                    BinaryFormat $this$decodeFromByteArray$iv = (BinaryFormat)Cbor.Default;
                    boolean $i$f$decodeFromByteArray = false;
                    $this$decodeFromByteArray$iv.getSerializersModule();
                    Object data = $this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)KeyPress.Companion.serializer(), payload);
                    KeyPress keyPress = (KeyPress)data;
                    Player player2 = player;
                    boolean bl = false;
                    UUID uUID = player2.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                    UUID uuid = uUID;
                    boolean bl2 = packet.getPressed() ? PaperNetworking.INSTANCE.getReadyToVeinmine().add(uuid) : PaperNetworking.INSTANCE.getReadyToVeinmine().remove(uuid);
                    if (GlobalsKt.getDebug()) {
                        Veinminer.Companion.getINSTANCE().getLogger().info(uuid + " pressed hotkey (" + packet.getPressed() + ")");
                    }
                }
                catch (Exception e) {
                    Veinminer.Companion.getINSTANCE().getLogger().warning("Failed to decode packet " + this.$identifier + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        onPress = Unit.INSTANCE;
        packetID$iv = "mine";
        $i$f$c2sPacket = false;
        identifier$iv = "veinminer:" + packetID$iv;
        GeneralExtensionsKt.getServer().getMessenger().registerIncomingPluginChannel((Plugin)Veinminer.Companion.getINSTANCE(), identifier$iv, new PluginMessageListener(identifier$iv){
            final /* synthetic */ String $identifier;
            {
                this.$identifier = $identifier;
            }

            /*
             * WARNING - void declaration
             */
            public final void onPluginMessageReceived(String channel, Player player, byte[] message) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                byte[] payload = ArraysKt.copyOfRange((byte[])message, (int)1, (int)message.length);
                try {
                    void packet;
                    BinaryFormat $this$decodeFromByteArray$iv = (BinaryFormat)Cbor.Default;
                    boolean $i$f$decodeFromByteArray = false;
                    $this$decodeFromByteArray$iv.getSerializersModule();
                    Object data = $this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)RequestBlockVein.Companion.serializer(), payload);
                    RequestBlockVein requestBlockVein = (RequestBlockVein)data;
                    Player player2 = player;
                    boolean bl = false;
                    UUID uUID = player2.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                    UUID uuid = uUID;
                    if (GlobalsKt.getDebug()) {
                        Veinminer.Companion.getINSTANCE().getLogger().info(uuid + " requested to veinmine block at " + packet.getBlockPosition());
                    }
                    BlockPosition position = packet.getBlockPosition();
                    Block block = player2.getWorld().getBlockAt(position.getX(), position.getY(), position.getZ());
                    Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlockAt(...)");
                    Block block2 = block;
                    VeinMinerEvent.VeinmineAction veinminerAction = VeinMinerEvent.INSTANCE.allowedToVeinmine(player2, block2);
                    if (veinminerAction == null) {
                        void $this$send$iv;
                        PaperNetworking paperNetworking = PaperNetworking.INSTANCE;
                        String string = PacketsKt.getPACKET_HIGHLIGHT();
                        BlockHighlighting data$iv = new BlockHighlighting(false, "", CollectionsKt.emptyList());
                        boolean $i$f$send = false;
                        try {
                            void this_$iv;
                            BinaryFormat $this$encodeToByteArray$iv$iv = (BinaryFormat)Cbor.Default;
                            boolean $i$f$encodeToByteArray = false;
                            $this$encodeToByteArray$iv$iv.getSerializersModule();
                            byte[] payload$iv = $this$encodeToByteArray$iv$iv.encodeToByteArray((SerializationStrategy)BlockHighlighting.Companion.serializer(), (Object)data$iv);
                            ByteArrayOutputStream baos$iv = new ByteArrayOutputStream();
                            PaperNetworking.access$writeVarInt((PaperNetworking)this_$iv, baos$iv, payload$iv.length);
                            baos$iv.write(payload$iv);
                            if (GlobalsKt.getDebug()) {
                                Veinminer.Companion.getINSTANCE().getLogger().info("Sending packet " + (String)$this$send$iv + " (" + payload$iv.length + ") to " + player2.getName());
                            }
                            player2.sendPluginMessage((Plugin)Veinminer.Companion.getINSTANCE(), (String)$this$send$iv, baos$iv.toByteArray());
                        }
                        catch (Exception e$iv) {
                            Veinminer.Companion.getINSTANCE().getLogger().warning("Failed to encode packet " + (String)$this$send$iv + ": " + e$iv.getMessage());
                            e$iv.printStackTrace();
                        }
                    } else {
                        void $this$send$iv;
                        void $this$mapTo$iv$iv;
                        VeinMinerEvent.INSTANCE.veinmine(VeinMinerEvent.VeinmineAction.copy$default(veinminerAction, null, null, null, null, null, null, VeinminerSettings.copy$default(veinminerAction.getSettings(), 0, false, 0, 0, false, 0, false, false, false, false, null, 2043, null), 63, null), false);
                        Object $this$map$iv = veinminerAction.getProcessedBlocks();
                        boolean $i$f$map22 = false;
                        Iterable $i$f$send = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Block block3 = (Block)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(new BlockPosition(it.getX(), it.getY(), it.getZ()));
                        }
                        List blocks = (List)destination$iv$iv;
                        $this$map$iv = PaperNetworking.INSTANCE;
                        String $i$f$map22 = PacketsKt.getPACKET_HIGHLIGHT();
                        Material material = block2.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
                        BlockHighlighting data$iv = new BlockHighlighting(true, VeinMinerEvent.INSTANCE.getPreferredToolIcon(material), blocks);
                        boolean $i$f$send2 = false;
                        try {
                            void this_$iv;
                            BinaryFormat $this$encodeToByteArray$iv$iv = (BinaryFormat)Cbor.Default;
                            boolean $i$f$encodeToByteArray = false;
                            $this$encodeToByteArray$iv$iv.getSerializersModule();
                            byte[] payload$iv = $this$encodeToByteArray$iv$iv.encodeToByteArray((SerializationStrategy)BlockHighlighting.Companion.serializer(), (Object)data$iv);
                            ByteArrayOutputStream baos$iv = new ByteArrayOutputStream();
                            PaperNetworking.access$writeVarInt((PaperNetworking)this_$iv, baos$iv, payload$iv.length);
                            baos$iv.write(payload$iv);
                            if (GlobalsKt.getDebug()) {
                                Veinminer.Companion.getINSTANCE().getLogger().info("Sending packet " + (String)$this$send$iv + " (" + payload$iv.length + ") to " + player2.getName());
                            }
                            player2.sendPluginMessage((Plugin)Veinminer.Companion.getINSTANCE(), (String)$this$send$iv, baos$iv.toByteArray());
                        }
                        catch (Exception e$iv) {
                            Veinminer.Companion.getINSTANCE().getLogger().warning("Failed to encode packet " + (String)$this$send$iv + ": " + e$iv.getMessage());
                            e$iv.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    Veinminer.Companion.getINSTANCE().getLogger().warning("Failed to decode packet " + this.$identifier + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        onMine = Unit.INSTANCE;
        EventPriority priority$iv = KPaperConfiguration.Events.INSTANCE.getEventPriority();
        boolean ignoreCancelled$iv = KPaperConfiguration.Events.INSTANCE.getIgnoreCancelled();
        boolean register$iv = KPaperConfiguration.Events.INSTANCE.getAutoRegistration();
        boolean $i$f$listen = false;
        SingleListener<PlayerQuitEvent> listener$iv = new SingleListener<PlayerQuitEvent>(priority$iv, ignoreCancelled$iv){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void onEvent(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PlayerQuitEvent it = (PlayerQuitEvent)event;
                boolean bl = false;
                UUID uUID = it.getPlayer().getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                UUID uuid = uUID;
                PaperNetworking.INSTANCE.getRegisteredPlayers().remove(uuid);
                PaperNetworking.INSTANCE.getReadyToVeinmine().remove(uuid);
            }
        };
        if (register$iv) {
            SingleListener $this$register$iv$iv = (SingleListener)listener$iv;
            boolean $i$f$register = false;
            GeneralExtensionsKt.getPluginManager().registerEvent(PlayerQuitEvent.class, (Listener)$this$register$iv$iv, $this$register$iv$iv.getPriority(), new EventExecutor($this$register$iv$iv){
                final /* synthetic */ SingleListener $this_register;
                {
                    this.$this_register = $receiver;
                }

                public final void execute(@NotNull Listener listener, @NotNull Event event) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)listener, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Event event2 = event;
                        if (!(event2 instanceof PlayerQuitEvent)) {
                            event2 = null;
                        }
                        Event event3 = (Event)((PlayerQuitEvent)event2);
                        if (event3 == null) break block1;
                        Event event4 = event3;
                        SingleListener singleListener = this.$this_register;
                        Event it = event4;
                        boolean bl = false;
                        singleListener.onEvent(it);
                    }
                }
            }, (Plugin)KSpigotKt.getPluginInstance(), $this$register$iv$iv.getIgnoreCancelled());
        }
        onDisconnect = (SingleListener)listener$iv;
    }
}

