/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm;

import io.papermc.asm.ClassInfo;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface ClassInfoProvider {
    public @Nullable ClassInfo info(String var1);

    public static ClassInfoProvider basic() {
        return className -> {
            try {
                Class<?> clazz = Class.forName(className.replace("/", "."));
                return ClassInfo.create(className, clazz.isEnum(), clazz.getSuperclass() == null ? null : clazz.getSuperclass().getName().replace(".", "/"));
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        };
    }

    public static ClassInfoProvider caching(final ClassInfoProvider backing, final boolean cacheMisses, final int cacheSize) {
        return new ClassInfoProvider(){
            private static final ClassInfo NULL_INFO = ClassInfo.create("", false, null);
            private final Map<String, ClassInfo> classInfoCache;
            {
                this.classInfoCache = Collections.synchronizedMap(new LinkedHashMap<String, ClassInfo>(cacheSize, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<String, ClassInfo> eldest) {
                        return this.size() > cacheSize - 1;
                    }
                });
            }

            @Override
            public @Nullable ClassInfo info(String className) {
                @Nullable ClassInfo info = this.classInfoCache.computeIfAbsent(className, cls -> {
                    @Nullable ClassInfo find = backing.info((String)cls);
                    return find == null && cacheMisses ? NULL_INFO : find;
                });
                return info == NULL_INFO ? null : info;
            }
        };
    }
}

