/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.method;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.builder.matcher.TargetedMethodMatcher;
import io.papermc.asm.rules.generate.GeneratedMethodHolder;
import io.papermc.asm.rules.generate.StaticRewriteGeneratedMethodHolder;
import io.papermc.asm.rules.method.MethodRewriteRule;
import io.papermc.asm.rules.method.OwnableMethodRewriteRule;
import io.papermc.asm.util.DescriptorUtils;
import io.papermc.asm.util.OpcodeUtils;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayDeque;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public interface StaticRewrite
extends OwnableMethodRewriteRule.Filtered {
    public static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    public static final String GENERATED_PREFIX = "paperAsmGenerated$";

    public ClassDesc staticRedirectOwner(ClassProcessingContext var1);

    default public MethodTypeDesc transformToRedirectDescriptor(MethodTypeDesc intermediateDescriptor) {
        return intermediateDescriptor;
    }

    default public MethodRewriteRule.Rewrite<GeneratedMethodHolder.MethodCallData> createRewrite(ClassProcessingContext context, MethodTypeDesc intermediateDescriptor, GeneratedMethodHolder.MethodCallData originalCallData) {
        return new MethodRewriteRule.RewriteSingle(OpcodeUtils.staticOp(originalCallData.isInvokeDynamic()), this.staticRedirectOwner(context), originalCallData.name(), this.transformToRedirectDescriptor(intermediateDescriptor), false, originalCallData.isInvokeDynamic());
    }

    default public MethodRewriteRule.Rewrite<GeneratedMethodHolder.ConstructorCallData> createConstructorRewrite(ClassProcessingContext context, MethodTypeDesc intermediateDescriptor, GeneratedMethodHolder.ConstructorCallData originalCallData) {
        String ownerString = DescriptorUtils.toOwner(originalCallData.owner());
        String staticMethodName = "create" + ownerString.substring(ownerString.lastIndexOf(47) + 1);
        return new RewriteConstructor(this.staticRedirectOwner(context), DescriptorUtils.toOwner(originalCallData.owner()), staticMethodName, this.transformToRedirectDescriptor(intermediateDescriptor));
    }

    @Override
    default public @Nullable MethodRewriteRule.Rewrite<?> rewrite(ClassProcessingContext context, boolean isInvokeDynamic, int opcode, ClassDesc owner, String name, MethodTypeDesc descriptor, boolean isInterface) {
        MethodTypeDesc modifiedDescriptor = descriptor;
        if (OpcodeUtils.isVirtual(opcode, isInvokeDynamic) || OpcodeUtils.isInterface(opcode, isInvokeDynamic)) {
            modifiedDescriptor = modifiedDescriptor.insertParameterTypes(0, owner);
        } else {
            if (OpcodeUtils.isSpecial(opcode, isInvokeDynamic)) {
                if (CONSTRUCTOR_METHOD_NAME.equals(name)) {
                    modifiedDescriptor = modifiedDescriptor.changeReturnType(owner);
                    return this.createConstructorRewrite(context, modifiedDescriptor, new GeneratedMethodHolder.ConstructorCallData(opcode, owner, descriptor));
                }
                throw new UnsupportedOperationException("Unhandled static rewrite: " + opcode + " " + owner + " " + name + " " + descriptor);
            }
            if (!OpcodeUtils.isStatic(opcode, isInvokeDynamic)) {
                throw new UnsupportedOperationException("Unhandled static rewrite: " + opcode + " " + owner + " " + name + " " + descriptor);
            }
        }
        return this.createRewrite(context, modifiedDescriptor, new GeneratedMethodHolder.MethodCallData(opcode, owner, name, descriptor, isInvokeDynamic));
    }

    public record RewriteConstructor(ClassDesc staticRedirectOwner, String constructorOwner, String methodName, MethodTypeDesc descriptor, @Nullable MethodRewriteRule.GeneratorInfo<GeneratedMethodHolder.ConstructorCallData> generatorInfo) implements MethodRewriteRule.Rewrite<GeneratedMethodHolder.ConstructorCallData>
    {
        public RewriteConstructor(ClassDesc staticRedirectOwner, String constructorOwner, String methodName, MethodTypeDesc descriptor) {
            this(staticRedirectOwner, constructorOwner, methodName, descriptor, null);
        }

        @Override
        public void apply(MethodVisitor delegate, MethodNode context) {
            boolean lastInsnWasDup = false;
            boolean handled = false;
            ArrayDeque<String> typeStack = new ArrayDeque<String>();
            for (AbstractInsnNode insn = context.instructions.getLast(); insn != null; insn = insn.getPrevious()) {
                if (insn.getOpcode() == 183 && StaticRewrite.CONSTRUCTOR_METHOD_NAME.equals(((MethodInsnNode)insn).name)) {
                    typeStack.push(((MethodInsnNode)insn).owner);
                }
                if (lastInsnWasDup && insn.getOpcode() == 187) {
                    TypeInsnNode newNode = (TypeInsnNode)insn;
                    if (typeStack.isEmpty()) {
                        if (!newNode.desc.equals(this.constructorOwner())) {
                            throw new IllegalStateException("typeStack was empty and the 'new' type didn't match the ctor type");
                        }
                        AbstractInsnNode dup = insn.getNext();
                        context.instructions.remove(insn);
                        context.instructions.remove(dup);
                        handled = true;
                        break;
                    }
                    String top = (String)typeStack.pop();
                    if (!newNode.desc.equals(top)) {
                        throw new IllegalStateException("typeStack top " + top + " didn't match expected " + newNode.desc + " from 'new' node");
                    }
                }
                lastInsnWasDup = insn.getOpcode() == 89;
            }
            if (!handled) {
                throw new IllegalStateException("Didn't find new/dup before invokespecial for ctor");
            }
            delegate.visitMethodInsn(184, DescriptorUtils.toOwner(this.staticRedirectOwner()), this.methodName(), this.descriptor().descriptorString(), false);
        }

        @Override
        public void applyToBootstrapArguments(Object[] arguments) {
            arguments[1] = new Handle(6, DescriptorUtils.toOwner(this.staticRedirectOwner()), this.methodName(), this.descriptor().descriptorString(), false);
            arguments[2] = Type.getMethodType((String)this.descriptor().descriptorString());
        }

        @Override
        public MethodRewriteRule.Rewrite<GeneratedMethodHolder.ConstructorCallData> withNamePrefix(String prefix) {
            return new RewriteConstructor(this.staticRedirectOwner(), this.constructorOwner(), prefix + this.methodName(), this.descriptor(), this.generatorInfo());
        }

        @Override
        public MethodRewriteRule.Rewrite<GeneratedMethodHolder.ConstructorCallData> withGeneratorInfo(GeneratedMethodHolder holder, GeneratedMethodHolder.ConstructorCallData original) {
            return new RewriteConstructor(this.staticRedirectOwner(), this.constructorOwner(), this.methodName(), this.descriptor(), new MethodRewriteRule.GeneratorInfo<GeneratedMethodHolder.ConstructorCallData>(holder, original));
        }

        @Override
        public @Nullable MethodRewriteRule.MethodGenerator createMethodGenerator() {
            if (this.generatorInfo == null) {
                return null;
            }
            GeneratedMethodHolder.ConstructorCallData original = this.generatorInfo.original();
            return factory -> this.generatorInfo.holder().generateConstructor(factory, new GeneratedMethodHolder.MethodCallData(184, this.staticRedirectOwner(), this.methodName(), this.descriptor(), false), original);
        }
    }

    public static interface Generated
    extends StaticRewrite,
    GeneratedMethodHolder {
        public ClassDesc existingType();

        @Override
        public TargetedMethodMatcher methodMatcher();

        @Override
        default public ClassDesc staticRedirectOwner(ClassProcessingContext context) {
            return DescriptorUtils.fromOwner(context.processingClassName());
        }

        @Override
        default public MethodRewriteRule.Rewrite<GeneratedMethodHolder.MethodCallData> createRewrite(ClassProcessingContext context, MethodTypeDesc intermediateDescriptor, GeneratedMethodHolder.MethodCallData originalCallData) {
            return StaticRewrite.super.createRewrite(context, intermediateDescriptor, originalCallData).withNamePrefix(StaticRewrite.GENERATED_PREFIX).withGeneratorInfo(this, originalCallData);
        }

        @Override
        default public MethodRewriteRule.Rewrite<GeneratedMethodHolder.ConstructorCallData> createConstructorRewrite(ClassProcessingContext context, MethodTypeDesc intermediateDescriptor, GeneratedMethodHolder.ConstructorCallData originalCallData) {
            return StaticRewrite.super.createConstructorRewrite(context, intermediateDescriptor, originalCallData).withNamePrefix(StaticRewrite.GENERATED_PREFIX).withGeneratorInfo(this, originalCallData);
        }

        public static interface Return
        extends Generated,
        StaticRewriteGeneratedMethodHolder.Return {
            @Override
            default public MethodTypeDesc transformInvokedDescriptor(MethodTypeDesc original, Void context) {
                return original.changeReturnType(this.existingType());
            }
        }

        public static interface Param
        extends Generated,
        StaticRewriteGeneratedMethodHolder.Param {
            @Override
            default public MethodTypeDesc transformInvokedDescriptor(MethodTypeDesc original, Set<Integer> context) {
                return DescriptorUtils.replaceParameters(original, Predicate.isEqual(this.methodMatcher().targetType()), this.existingType(), context);
            }
        }
    }
}

