/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.attributes;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.function.Function;

public final class ConverterAbstractAttributesRename {
    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractAttributesRename.register(version, 0, renamer);
    }

    public static void register(int version, int versionStep, final Function<String, String> renamer) {
        MCTypeRegistry.DATA_COMPONENTS.addStructureConverter(new DataConverter<MapType, MapType>(version, versionStep){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType attributeModifiers = data.getMap("minecraft:attribute_modifiers");
                if (attributeModifiers == null) {
                    return null;
                }
                ListType modifiers = attributeModifiers.getList("modifiers", ObjectType.MAP);
                if (modifiers == null) {
                    return null;
                }
                int len = modifiers.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    RenameHelper.renameString(modifiers.getMap(i2), "type", renamer);
                }
                return null;
            }
        });
        DataConverter<MapType, MapType> entityConverter = new DataConverter<MapType, MapType>(version, versionStep){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType modifiers = data.getList("attributes", ObjectType.MAP);
                if (modifiers == null) {
                    return null;
                }
                int len = modifiers.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    RenameHelper.renameString(modifiers.getMap(i2), "id", renamer);
                }
                return null;
            }
        };
        MCTypeRegistry.ENTITY.addStructureConverter(entityConverter);
        MCTypeRegistry.PLAYER.addStructureConverter(entityConverter);
    }

    private ConverterAbstractAttributesRename() {
    }
}

