/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.chunk;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.Types;
import ca.spottedleaf.dataconverter.util.NamespaceUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ConverterAddBlendingData
extends DataConverter<MapType, MapType> {
    private static final Set<String> STATUSES_TO_SKIP_BLENDING = new HashSet<String>(Arrays.asList("minecraft:empty", "minecraft:structure_starts", "minecraft:structure_references", "minecraft:biomes"));

    public ConverterAddBlendingData(int toVersion) {
        super(toVersion);
    }

    public ConverterAddBlendingData(int toVersion, int versionStep) {
        super(toVersion, versionStep);
    }

    private static MapType createBlendingData(int height, int minY) {
        MapType ret = Types.NBT.createEmptyMap();
        ret.setInt("min_section", minY >> 4);
        ret.setInt("max_section", minY + height >> 4);
        return ret;
    }

    @Override
    public MapType convert(MapType data, long sourceVersion, long toVersion) {
        String realStatus;
        data.remove("blending_data");
        MapType context = data.getMap("__context");
        if (!"minecraft:overworld".equals(context == null ? null : context.getString("dimension"))) {
            return null;
        }
        String status = NamespaceUtil.correctNamespace(data.getString("Status"));
        if (status == null) {
            return null;
        }
        MapType belowZeroRetrogen = data.getMap("below_zero_retrogen");
        if (!STATUSES_TO_SKIP_BLENDING.contains(status)) {
            data.setMap("blending_data", ConverterAddBlendingData.createBlendingData(384, -64));
        } else if (belowZeroRetrogen != null && !STATUSES_TO_SKIP_BLENDING.contains(realStatus = NamespaceUtil.correctNamespace(belowZeroRetrogen.getString("target_status", "empty")))) {
            data.setMap("blending_data", ConverterAddBlendingData.createBlendingData(256, 0));
        }
        return null;
    }
}

