/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.entity;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.function.Function;

public final class ConverterEntityVariantRename
extends DataConverter<MapType, MapType> {
    private final Function<String, String> renamer;

    public ConverterEntityVariantRename(int toVersion, Function<String, String> renamer) {
        super(toVersion);
        this.renamer = renamer;
    }

    public ConverterEntityVariantRename(int toVersion, int versionStep, Function<String, String> renamer) {
        super(toVersion, versionStep);
        this.renamer = renamer;
    }

    @Override
    public MapType convert(MapType data, long sourceVersion, long toVersion) {
        String variant = data.getString("variant");
        if (variant == null) {
            return null;
        }
        String rename = this.renamer.apply(variant);
        if (rename != null) {
            data.setString("variant", rename);
        }
        return null;
    }
}

