/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.poi;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.function.Predicate;

public final class ConverterPoiDelete
extends DataConverter<MapType, MapType> {
    private final Predicate<String> delete;

    public ConverterPoiDelete(int toVersion, Predicate<String> delete) {
        super(toVersion);
        this.delete = delete;
    }

    public ConverterPoiDelete(int toVersion, int versionStep, Predicate<String> delete) {
        super(toVersion, versionStep);
        this.delete = delete;
    }

    @Override
    public MapType convert(MapType data, long sourceVersion, long toVersion) {
        MapType sections = data.getMap("Sections");
        if (sections == null) {
            return null;
        }
        for (String key : sections.keys()) {
            MapType section = sections.getMap(key);
            ListType records = section.getList("Records", ObjectType.MAP);
            if (records == null) continue;
            int i2 = 0;
            while (i2 < records.size()) {
                MapType record = records.getMap(i2);
                String type = record.getString("type");
                if (type != null && this.delete.test(type)) {
                    records.remove(i2);
                    continue;
                }
                ++i2;
            }
        }
        return null;
    }
}

