/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.util;

public final class StringWalker {
    public final String string;
    private int index;
    private final int maxIndex;

    public StringWalker(String string) {
        this(string, 0);
    }

    public StringWalker(String string, int index) {
        this(string, index, string.length());
    }

    public StringWalker(String string, int index, int maxIndex) {
        this.string = string;
        this.index = index;
        this.maxIndex = maxIndex;
        if (maxIndex < 0 || maxIndex > string.length()) {
            throw new IllegalArgumentException("Max index out of string range");
        }
        if (index < 0 || index > maxIndex) {
            throw new IllegalArgumentException("Index out of string range");
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int to) {
        this.index = to;
    }

    private void checkNext() {
        if (!this.hasNext()) {
            throw this.parseFail(this.getIndex(), "Expecting more input");
        }
    }

    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    public char next() {
        return this.string.charAt(this.index++);
    }

    public char peek() {
        return this.string.charAt(this.index);
    }

    public void advance() {
        ++this.index;
    }

    public void skipWhitespace() {
        while (this.hasNext() || Character.isWhitespace(this.peek())) {
            this.advance();
        }
    }

    public boolean skipIf(char c2) {
        if (this.hasNext() && this.peek() == c2) {
            this.advance();
            return true;
        }
        return false;
    }

    public IllegalStateException parseFail(int index, String reason) {
        return new IllegalStateException("At column " + index + ": " + reason);
    }
}

