/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V1496;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.slf4j.Logger;

public final class V1624 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VERSION = 1624;

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType, MapType>(1624){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                ListType sections = level.getList("Sections", ObjectType.MAP);
                if (sections == null) {
                    return null;
                }
                IntOpenHashSet positionsToLook = new IntOpenHashSet();
                int len = sections.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    TrappedChestSection section = new TrappedChestSection(sections.getMap(i2));
                    if (section.isSkippable()) continue;
                    for (int index = 0; index < 4096; ++index) {
                        if (!section.isTrappedChest(section.getBlock(index))) continue;
                        positionsToLook.add(section.getSectionY() << 12 | index);
                    }
                }
                int chunkX = level.getInt("xPos");
                int chunkZ = level.getInt("zPos");
                ListType tileEntities = level.getList("TileEntities", ObjectType.MAP);
                if (tileEntities != null) {
                    int len2 = tileEntities.size();
                    for (int i3 = 0; i3 < len2; ++i3) {
                        int z2;
                        int y2;
                        MapType tile = tileEntities.getMap(i3);
                        int x2 = tile.getInt("x");
                        int index = V1496.getIndex(x2 - (chunkX << 4), y2 = tile.getInt("y"), (z2 = tile.getInt("z")) - (chunkZ << 4));
                        if (!positionsToLook.contains(index)) continue;
                        String id = tile.getString("id");
                        if (!"minecraft:chest".equals(id)) {
                            LOGGER.warn("Block Entity ({},{},{}) was expected to be a chest (V1624)", new Object[]{x2, y2, z2});
                        }
                        tile.setString("id", "minecraft:trapped_chest");
                    }
                }
                return null;
            }
        });
    }

    private V1624() {
    }

    public static final class TrappedChestSection
    extends V1496.Section {
        private IntOpenHashSet chestIds;

        public TrappedChestSection(MapType section) {
            super(section);
        }

        @Override
        protected boolean initSkippable() {
            this.chestIds = new IntOpenHashSet();
            for (int i2 = 0; i2 < this.palette.size(); ++i2) {
                MapType blockState = this.palette.getMap(i2);
                String name = blockState.getString("Name");
                if (!"minecraft:trapped_chest".equals(name)) continue;
                this.chestIds.add(i2);
            }
            return this.chestIds.isEmpty();
        }

        public boolean isTrappedChest(int id) {
            return this.chestIds.contains(id);
        }
    }
}

