/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public final class V2550 {
    private static final int VERSION = 2550;
    private static final Map<String, StructureFeatureConfiguration> DEFAULTS = new HashMap<String, StructureFeatureConfiguration>((Map<String, StructureFeatureConfiguration>)ImmutableMap.builder().put((Object)"minecraft:village", (Object)new StructureFeatureConfiguration(32, 8, 10387312)).put((Object)"minecraft:desert_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357617)).put((Object)"minecraft:igloo", (Object)new StructureFeatureConfiguration(32, 8, 14357618)).put((Object)"minecraft:jungle_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357619)).put((Object)"minecraft:swamp_hut", (Object)new StructureFeatureConfiguration(32, 8, 14357620)).put((Object)"minecraft:pillager_outpost", (Object)new StructureFeatureConfiguration(32, 8, 165745296)).put((Object)"minecraft:monument", (Object)new StructureFeatureConfiguration(32, 5, 10387313)).put((Object)"minecraft:endcity", (Object)new StructureFeatureConfiguration(20, 11, 10387313)).put((Object)"minecraft:mansion", (Object)new StructureFeatureConfiguration(80, 20, 10387319)).build());

    public static void register() {
        MCTypeRegistry.WORLD_GEN_SETTINGS.addStructureConverter(new DataConverter<MapType, MapType>(2550){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType generator;
                String legacyCustomOptions;
                long seed = data.getLong("RandomSeed");
                String generatorName = data.getString("generatorName");
                if (generatorName != null) {
                    generatorName = generatorName.toLowerCase(Locale.ROOT);
                }
                if ((legacyCustomOptions = data.getString("legacy_custom_options")) == null) {
                    legacyCustomOptions = "customized".equals(generatorName) ? data.getString("generatorOptions") : null;
                }
                boolean caves = false;
                if ("customized".equals(generatorName) || generatorName == null) {
                    generator = V2550.defaultOverworld(seed);
                } else {
                    switch (generatorName) {
                        case "flat": {
                            MapType generatorOptions = data.getMap("generatorOptions");
                            MapType structures = V2550.fixFlatStructures(generatorOptions);
                            MapType settings = Types.NBT.createEmptyMap();
                            generator = Types.NBT.createEmptyMap();
                            generator.setString("type", "minecraft:flat");
                            generator.setMap("settings", settings);
                            settings.setMap("structures", structures);
                            ListType layers = generatorOptions.getList("layers", ObjectType.MAP);
                            if (layers == null) {
                                layers = Types.NBT.createEmptyList();
                                int[] heights = new int[]{1, 2, 1};
                                String[] blocks = new String[]{"minecraft:bedrock", "minecraft:dirt", "minecraft:grass_block"};
                                for (int i2 = 0; i2 < 3; ++i2) {
                                    MapType layer = Types.NBT.createEmptyMap();
                                    layer.setInt("height", heights[i2]);
                                    layer.setString("block", blocks[i2]);
                                    layers.addMap(layer);
                                }
                            }
                            settings.setList("layers", layers);
                            settings.setString("biome", generatorOptions.getString("biome", "minecraft:plains"));
                            break;
                        }
                        case "debug_all_block_states": {
                            generator = Types.NBT.createEmptyMap();
                            generator.setString("type", "minecraft:debug");
                            break;
                        }
                        case "buffet": {
                            MapType biomeSource;
                            String newType;
                            String chunkGeneratorType;
                            MapType generatorOptions = data.getMap("generatorOptions");
                            MapType chunkGenerator = generatorOptions == null ? null : generatorOptions.getMap("chunk_generator");
                            String string = chunkGeneratorType = chunkGenerator == null ? null : chunkGenerator.getString("type");
                            if ("minecraft:caves".equals(chunkGeneratorType)) {
                                newType = "minecraft:caves";
                                caves = true;
                            } else {
                                newType = "minecraft:floating_islands".equals(chunkGeneratorType) ? "minecraft:floating_islands" : "minecraft:overworld";
                            }
                            MapType mapType = biomeSource = generatorOptions == null ? null : generatorOptions.getMap("biome_source");
                            if (biomeSource == null) {
                                biomeSource = Types.NBT.createEmptyMap();
                                biomeSource.setString("type", "minecraft:fixed");
                            }
                            if ("minecraft:fixed".equals(biomeSource.getString("type"))) {
                                MapType options = biomeSource.getMap("options");
                                ListType biomes = options == null ? null : options.getList("biomes", ObjectType.STRING);
                                String biome = biomes == null || biomes.size() == 0 ? "minecraft:ocean" : biomes.getString(0);
                                biomeSource.remove("options");
                                biomeSource.setString("biome", biome);
                            }
                            generator = V2550.noise(seed, newType, biomeSource);
                            break;
                        }
                        default: {
                            boolean defaultGen = generatorName.equals("default");
                            boolean default11Gen = generatorName.equals("default_1_1") || defaultGen && data.getInt("generatorVersion") == 0;
                            boolean amplified = generatorName.equals("amplified");
                            boolean largeBiomes = generatorName.equals("largebiomes");
                            generator = V2550.noise(seed, amplified ? "minecraft:amplified" : "minecraft:overworld", V2550.vanillaBiomeSource(seed, default11Gen, largeBiomes));
                            break;
                        }
                    }
                }
                boolean mapFeatures = data.getBoolean("MapFeatures", true);
                boolean bonusChest = data.getBoolean("BonusChest", false);
                MapType ret = Types.NBT.createEmptyMap();
                ret.setLong("seed", seed);
                ret.setBoolean("generate_features", mapFeatures);
                ret.setBoolean("bonus_chest", bonusChest);
                ret.setMap("dimensions", V2550.vanillaLevels(seed, generator, caves));
                if (legacyCustomOptions != null) {
                    ret.setString("legacy_custom_options", legacyCustomOptions);
                }
                return ret;
            }
        });
    }

    public static MapType noise(long seed, String worldType, MapType biomeSource) {
        MapType ret = Types.NBT.createEmptyMap();
        ret.setString("type", "minecraft:noise");
        ret.setMap("biome_source", biomeSource);
        ret.setLong("seed", seed);
        ret.setString("settings", worldType);
        return ret;
    }

    public static MapType vanillaBiomeSource(long seed, boolean default11Gen, boolean largeBiomes) {
        MapType ret = Types.NBT.createEmptyMap();
        ret.setString("type", "minecraft:vanilla_layered");
        ret.setLong("seed", seed);
        ret.setBoolean("large_biomes", largeBiomes);
        if (default11Gen) {
            ret.setBoolean("legacy_biome_init_layer", default11Gen);
        }
        return ret;
    }

    public static MapType fixFlatStructures(MapType generatorOptions) {
        MapType oldStructures;
        int distance = 32;
        int spread = 3;
        int count = 128;
        boolean stronghold = false;
        HashMap<String, StructureFeatureConfiguration> newStructures = new HashMap<String, StructureFeatureConfiguration>();
        if (generatorOptions == null) {
            stronghold = true;
            newStructures.put("minecraft:village", DEFAULTS.get("minecraft:village"));
        }
        MapType mapType = oldStructures = generatorOptions == null ? null : generatorOptions.getMap("structures");
        if (oldStructures != null) {
            for (String structureName : oldStructures.keys()) {
                MapType structureValues = oldStructures.getMap(structureName);
                if (structureValues == null) continue;
                for (String structureValueKey : structureValues.keys()) {
                    String structureValue = structureValues.getString(structureValueKey);
                    if ("stronghold".equals(structureName)) {
                        stronghold = true;
                        switch (structureValueKey) {
                            case "distance": {
                                distance = V2550.getInt(structureValue, distance, 1);
                                break;
                            }
                            case "spread": {
                                spread = V2550.getInt(structureValue, spread, 1);
                                break;
                            }
                            case "count": {
                                count = V2550.getInt(structureValue, count, 1);
                            }
                        }
                        continue;
                    }
                    switch (structureValueKey) {
                        case "distance": {
                            switch (structureName) {
                                case "village": {
                                    V2550.setSpacing(newStructures, "minecraft:village", structureValue, 9);
                                    break;
                                }
                                case "biome_1": {
                                    V2550.setSpacing(newStructures, "minecraft:desert_pyramid", structureValue, 9);
                                    V2550.setSpacing(newStructures, "minecraft:igloo", structureValue, 9);
                                    V2550.setSpacing(newStructures, "minecraft:jungle_pyramid", structureValue, 9);
                                    V2550.setSpacing(newStructures, "minecraft:swamp_hut", structureValue, 9);
                                    V2550.setSpacing(newStructures, "minecraft:pillager_outpost", structureValue, 9);
                                    break;
                                }
                                case "endcity": {
                                    V2550.setSpacing(newStructures, "minecraft:endcity", structureValue, 1);
                                    break;
                                }
                                case "mansion": {
                                    V2550.setSpacing(newStructures, "minecraft:mansion", structureValue, 1);
                                    break;
                                }
                            }
                        }
                        case "separation": {
                            if (!"oceanmonument".equals(structureName)) break;
                            StructureFeatureConfiguration structure = newStructures.getOrDefault("minecraft:monument", DEFAULTS.get("minecraft:monument"));
                            int newSpacing = V2550.getInt(structureValue, structure.separation, 1);
                            newStructures.put("minecraft:monument", new StructureFeatureConfiguration(newSpacing, structure.separation, structure.salt));
                            break;
                        }
                        case "spacing": {
                            if (!"oceanmonument".equals(structureName)) break;
                            V2550.setSpacing(newStructures, "minecraft:monument", structureValue, 1);
                        }
                    }
                }
            }
        }
        MapType ret = Types.NBT.createEmptyMap();
        MapType structuresSerialized = Types.NBT.createEmptyMap();
        ret.setMap("structures", structuresSerialized);
        for (String key : newStructures.keySet()) {
            structuresSerialized.setMap(key, ((StructureFeatureConfiguration)newStructures.get(key)).serialize());
        }
        if (stronghold) {
            MapType strongholdData = Types.NBT.createEmptyMap();
            ret.setMap("stronghold", strongholdData);
            strongholdData.setInt("distance", distance);
            strongholdData.setInt("spread", spread);
            strongholdData.setInt("count", count);
        }
        return ret;
    }

    public static MapType vanillaLevels(long seed, MapType generator, boolean caves) {
        MapType ret = Types.NBT.createEmptyMap();
        MapType overworld = Types.NBT.createEmptyMap();
        MapType nether = Types.NBT.createEmptyMap();
        MapType end = Types.NBT.createEmptyMap();
        ret.setMap("minecraft:overworld", overworld);
        ret.setMap("minecraft:the_nether", nether);
        ret.setMap("minecraft:the_end", end);
        overworld.setString("type", caves ? "minecraft:overworld_caves" : "minecraft:overworld");
        overworld.setMap("generator", generator);
        nether.setString("type", "minecraft:the_nether");
        MapType netherBiomeSource = Types.NBT.createEmptyMap();
        netherBiomeSource.setString("type", "minecraft:multi_noise");
        netherBiomeSource.setLong("seed", seed);
        netherBiomeSource.setString("preset", "minecraft:nether");
        nether.setMap("generator", V2550.noise(seed, "minecraft:nether", netherBiomeSource));
        end.setString("type", "minecraft:the_end");
        MapType endBiomeSource = Types.NBT.createEmptyMap();
        endBiomeSource.setString("type", "minecraft:the_end");
        endBiomeSource.setLong("seed", seed);
        end.setMap("generator", V2550.noise(seed, "minecraft:end", endBiomeSource));
        return ret;
    }

    public static MapType defaultOverworld(long seed) {
        return V2550.noise(seed, "minecraft:overworld", V2550.vanillaBiomeSource(seed, false, false));
    }

    private static int getInt(String value, int dfl) {
        return NumberUtils.toInt((String)value, (int)dfl);
    }

    private static int getInt(String value, int dfl, int minVal) {
        return Math.max(minVal, V2550.getInt(value, dfl));
    }

    private static void setSpacing(Map<String, StructureFeatureConfiguration> structures, String structureName, String value, int minVal) {
        StructureFeatureConfiguration structure = structures.getOrDefault(structureName, DEFAULTS.get(structureName));
        int newSpacing = V2550.getInt(value, structure.spacing, minVal);
        structures.put(structureName, new StructureFeatureConfiguration(newSpacing, structure.separation, structure.salt));
    }

    private V2550() {
    }

    private record StructureFeatureConfiguration(int spacing, int separation, int salt) {
        public MapType serialize() {
            MapType ret = Types.NBT.createEmptyMap();
            ret.setInt("spacing", this.spacing);
            ret.setInt("separation", this.separation);
            ret.setInt("salt", this.salt);
            return ret;
        }
    }
}

