/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V2551 {
    private static final int VERSION = 2551;

    public static void register() {
        MCTypeRegistry.WORLD_GEN_SETTINGS.addStructureWalker(2551, (data, fromVersion, toVersion) -> {
            MapType dimensions = data.getMap("dimensions");
            if (dimensions == null) {
                return null;
            }
            for (String dimension : dimensions.keys()) {
                block24: {
                    String type;
                    MapType generator;
                    MapType dimensionData = dimensions.getMap(dimension);
                    if (dimensionData == null || (generator = dimensionData.getMap("generator")) == null || (type = generator.getString("type")) == null) continue;
                    block4 : switch (type) {
                        case "minecraft:flat": {
                            MapType settings = generator.getMap("settings");
                            if (settings == null) break;
                            WalkerUtils.convert(MCTypeRegistry.BIOME, settings, "biome", fromVersion, toVersion);
                            ListType layers = settings.getList("layers", ObjectType.MAP);
                            if (layers == null) break;
                            int len = layers.size();
                            for (int i2 = 0; i2 < len; ++i2) {
                                WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, layers.getMap(i2), "block", fromVersion, toVersion);
                            }
                            break;
                        }
                        case "minecraft:noise": {
                            String biomeSourceType;
                            MapType biomeSource;
                            MapType settings = generator.getMap("settings");
                            if (settings != null) {
                                WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, settings, "default_block", fromVersion, toVersion);
                                WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, settings, "default_fluid", fromVersion, toVersion);
                            }
                            if ((biomeSource = generator.getMap("biome_source")) == null) break;
                            switch (biomeSourceType = biomeSource.getString("type", "")) {
                                case "minecraft:fixed": {
                                    WalkerUtils.convert(MCTypeRegistry.BIOME, biomeSource, "biome", fromVersion, toVersion);
                                    break;
                                }
                                case "minecraft:multi_noise": {
                                    ListType biomes = biomeSource.getList("biomes", ObjectType.MAP);
                                    if (biomes != null) {
                                        int len = biomes.size();
                                        for (int i3 = 0; i3 < len; ++i3) {
                                            WalkerUtils.convert(MCTypeRegistry.BIOME, biomes.getMap(i3), "biome", fromVersion, toVersion);
                                        }
                                        break block4;
                                    }
                                    break block24;
                                }
                                case "minecraft:checkerboard": {
                                    WalkerUtils.convertList(MCTypeRegistry.BIOME, biomeSource, "biomes", fromVersion, toVersion);
                                }
                            }
                            break;
                        }
                    }
                }
            }
            return null;
        });
    }

    private V2551() {
    }
}

