/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.HashSet;
import java.util.Set;

public final class V3322 {
    private static final int VERSION = 3322;
    private static final Set<String> EFFECT_ITEM_TYPES = new HashSet<String>(Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow"));

    private static void updateEffectList(MapType root, String path) {
        if (root == null) {
            return;
        }
        ListType effects = root.getList(path, ObjectType.MAP);
        if (effects == null) {
            return;
        }
        int len = effects.size();
        for (int i2 = 0; i2 < len; ++i2) {
            MapType data = effects.getMap(i2);
            MapType factorData = data.getMap("FactorCalculationData");
            if (factorData == null) continue;
            int timestamp = factorData.getInt("effect_changed_timestamp", -1);
            factorData.remove("effect_changed_timestamp");
            int duration = data.getInt("Duration", -1);
            int ticksActive = timestamp - duration;
            factorData.setInt("ticks_active", ticksActive);
        }
    }

    public static void register() {
        DataConverter<MapType, MapType> entityEffectFix = new DataConverter<MapType, MapType>(3322){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V3322.updateEffectList(data, "Effects");
                V3322.updateEffectList(data, "ActiveEffects");
                V3322.updateEffectList(data, "CustomPotionEffects");
                return null;
            }
        };
        MCTypeRegistry.PLAYER.addStructureConverter(entityEffectFix);
        MCTypeRegistry.ENTITY.addStructureConverter(entityEffectFix);
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType, MapType>(3322){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String id = data.getString("id");
                if (!EFFECT_ITEM_TYPES.contains(id)) {
                    return null;
                }
                V3322.updateEffectList(data.getMap("tag"), "CustomPotionEffects");
                return null;
            }
        });
    }

    private V3322() {
    }
}

