/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.ComponentUtils;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V4054 {
    private static final int VERSION = 4054;

    public static void register() {
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:banner", new DataConverter<MapType, MapType>(4054){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V4054.convertComponents(data.getMap("components"));
                return null;
            }
        });
        MCTypeRegistry.ITEM_STACK.addConverterForId("minecraft:white_banner", new DataConverter<MapType, MapType>(4054){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V4054.convertComponents(data.getMap("components"));
                return null;
            }
        });
    }

    private static void convertComponents(MapType components) {
        if (components == null) {
            return;
        }
        String itemNameKey = ComponentUtils.retrieveTranslationString(components.getString("minecraft:item_name"));
        if (!"block.minecraft.ominous_banner".equals(itemNameKey)) {
            return;
        }
        components.setString("minecraft:rarity", "uncommon");
        components.setString("minecraft:item_name", ComponentUtils.createTranslatableComponent("block.minecraft.ominous_banner"));
    }

    private V4054() {
    }
}

