/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V4176 {
    private static final int VERSION = 4176;

    private static void fixInvalidLock(MapType root, String path) {
        MapType lock = root.getMap(path);
        if (lock == null || lock.size() != 1) {
            return;
        }
        MapType components = lock.getMap("components");
        if (components == null || components.size() != 1 || !"\"\"".equals(components.getString("minecraft:custom_name"))) {
            return;
        }
        root.remove(path);
    }

    public static void register() {
        MCTypeRegistry.TILE_ENTITY.addStructureConverter(new DataConverter<MapType, MapType>(4176){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V4176.fixInvalidLock(data, "lock");
                return null;
            }
        });
        MCTypeRegistry.DATA_COMPONENTS.addStructureConverter(new DataConverter<MapType, MapType>(4176){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V4176.fixInvalidLock(data, "minecraft:lock");
                return null;
            }
        });
    }

    private V4176() {
    }
}

