/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.CopyHelper;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V4309;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.TypeUtil;

public final class V4314 {
    private static final int VERSION = 4314;

    public static void register() {
        DataConverter<MapType, MapType> livingEntityConverter = new DataConverter<MapType, MapType>(4314){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V4309.convertBlockPosition(data, "SleepingX", "SleepingY", "SleepingZ", "sleeping_pos");
                return null;
            }
        };
        MCTypeRegistry.PLAYER.addStructureConverter(livingEntityConverter);
        MCTypeRegistry.PLAYER.addStructureConverter(new DataConverter<MapType, MapType>(4314){

            @Override
            public MapType convert(MapType root, long sourceVersion, long toVersion) {
                MapType netherPos;
                TypeUtil<?> typeUtil = root.getTypeUtil();
                Number spawnX = root.getNumber("SpawnX");
                Number spawnY = root.getNumber("SpawnY");
                Number spawnZ = root.getNumber("SpawnZ");
                if (spawnX != null && spawnY != null && spawnZ != null) {
                    root.remove("SpawnX");
                    root.remove("SpawnY");
                    root.remove("SpawnZ");
                    MapType respawn = typeUtil.createEmptyMap();
                    root.setMap("respawn", respawn);
                    respawn.setInts("pos", V4309.makeBlockPosition(spawnX, spawnY, spawnZ));
                    CopyHelper.move(root, "SpawnAngle", respawn, "angle");
                    CopyHelper.move(root, "SpawnDimension", respawn, "dimension");
                    CopyHelper.move(root, "SpawnForced", respawn, "forced");
                }
                if ((netherPos = root.getMap("enteredNetherPosition")) != null) {
                    root.remove("enteredNetherPosition");
                    ListType newPos = typeUtil.createEmptyList();
                    root.setList("entered_nether_pos", newPos);
                    newPos.addDouble(netherPos.getDouble("x", 0.0));
                    newPos.addDouble(netherPos.getDouble("y", 0.0));
                    newPos.addDouble(netherPos.getDouble("z", 0.0));
                }
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addStructureConverter(livingEntityConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:vex", new DataConverter<MapType, MapType>(4314){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V4309.convertBlockPosition(data, "BoundX", "BoundY", "BoundZ", "bound_pos");
                RenameHelper.renameSingle(data, "LifeTicks", "life_ticks");
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:phantom", new DataConverter<MapType, MapType>(4314){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V4309.convertBlockPosition(data, "AX", "AY", "AZ", "anchor_pos");
                RenameHelper.renameSingle(data, "Size", "size");
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:turtle", new DataConverter<MapType, MapType>(4314){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                data.remove("TravelPosX");
                data.remove("TravelPosY");
                data.remove("TravelPosZ");
                V4309.convertBlockPosition(data, "HomePosX", "HomePosY", "HomePosZ", "home_pos");
                RenameHelper.renameSingle(data, "HasEgg", "has_egg");
                return null;
            }
        });
        DataConverter<MapType, MapType> attachedBlockConverter = new DataConverter<MapType, MapType>(4314){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V4309.convertBlockPosition(data, "TileX", "TileY", "TileZ", "block_pos");
                return null;
            }
        };
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:item_frame", attachedBlockConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:glow_item_frame", attachedBlockConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:painting", attachedBlockConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:leash_knot", attachedBlockConverter);
    }

    private V4314() {
    }
}

