/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V4548 {
    private static final int VERSION = 4548;

    public static void register() {
        MCTypeRegistry.LEVEL.addStructureConverter(new DataConverter<MapType, MapType>(4548){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                int x2 = data.getInt("SpawnX");
                int y2 = data.getInt("SpawnY");
                int z2 = data.getInt("SpawnZ");
                float yaw = data.getFloat("SpawnAngle");
                data.remove("SpawnX");
                data.remove("SpawnY");
                data.remove("SpawnZ");
                data.remove("SpawnAngle");
                MapType spawn = data.getTypeUtil().createEmptyMap();
                data.setMap("spawn", spawn);
                spawn.setString("dimension", "minecraft:overworld");
                spawn.setInts("pos", new int[]{x2, y2, z2});
                spawn.setFloat("yaw", yaw);
                spawn.setFloat("pitch", 0.0f);
                return null;
            }
        });
        MCTypeRegistry.PLAYER.addStructureConverter(new DataConverter<MapType, MapType>(4548){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType respawn = data.getMap("respawn");
                if (respawn == null) {
                    return null;
                }
                String dimension = respawn.getString("dimension");
                float yaw = respawn.getFloat("angle");
                respawn.remove("angle");
                respawn.setFloat("yaw", yaw);
                respawn.setFloat("pitch", 0.0f);
                if (dimension == null) {
                    respawn.setString("dimension", "minecraft:overworld");
                }
                return null;
            }
        });
    }

    private V4548() {
    }
}

