/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.json;

import ca.spottedleaf.dataconverter.minecraft.converters.helpers.CopyHelper;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.json.JsonListType;
import ca.spottedleaf.dataconverter.types.json.JsonMapType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.Map;

public final class JsonTypeUtil
implements TypeUtil<JsonElement> {
    private final boolean compressed;

    public JsonTypeUtil(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public ListType createEmptyList() {
        return new JsonListType(this.compressed);
    }

    @Override
    public MapType createEmptyMap() {
        return new JsonMapType(this.compressed);
    }

    @Override
    public Object convertTo(Object valueGeneric, TypeUtil<?> to) {
        if (valueGeneric == null || valueGeneric instanceof String || valueGeneric instanceof Boolean) {
            return valueGeneric;
        }
        if (valueGeneric instanceof Number) {
            Number number = (Number)valueGeneric;
            if (CopyHelper.sanitizeNumber(number) == null) {
                throw new IllegalStateException("Unknown type: " + String.valueOf(number));
            }
            return number;
        }
        if (valueGeneric instanceof JsonListType) {
            JsonListType listType = (JsonListType)valueGeneric;
            return JsonTypeUtil.convertJson(to, listType.array, this.compressed);
        }
        if (valueGeneric instanceof JsonMapType) {
            JsonMapType mapType = (JsonMapType)valueGeneric;
            return JsonTypeUtil.convertJson(to, mapType.map, this.compressed);
        }
        throw new IllegalStateException("Unknown type: " + String.valueOf(valueGeneric));
    }

    @Override
    public Object convertFromBaseToGeneric(JsonElement input, TypeUtil<?> to) {
        return JsonTypeUtil.convertJsonToGeneric(to, input, this.compressed);
    }

    @Override
    public Object baseToGeneric(JsonElement input) {
        if (input == null) {
            return null;
        }
        if (input instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)input;
            return new JsonMapType(jsonObject, this.compressed);
        }
        if (input instanceof JsonArray) {
            JsonArray array = (JsonArray)input;
            return new JsonListType(array, this.compressed);
        }
        if (input instanceof JsonNull) {
            return null;
        }
        JsonPrimitive primitive = (JsonPrimitive)input;
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            Number number = CopyHelper.sanitizeNumber(primitive.getAsNumber());
            return number != null ? (Number)number : (Number)JsonTypeUtil.convertBDToGeneric(primitive.getAsBigDecimal());
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        throw new IllegalStateException("Unrecognized type " + String.valueOf(input));
    }

    @Override
    public JsonElement genericToBase(Object input) {
        if (input == null) {
            return JsonNull.INSTANCE;
        }
        if (input instanceof JsonMapType) {
            JsonMapType mapType = (JsonMapType)input;
            return mapType.map;
        }
        if (input instanceof JsonListType) {
            JsonListType listType = (JsonListType)input;
            return listType.array;
        }
        if (input instanceof Boolean) {
            Boolean bool = (Boolean)input;
            return new JsonPrimitive(bool);
        }
        if (input instanceof Number) {
            Number number = (Number)input;
            return new JsonPrimitive(number);
        }
        if (input instanceof String) {
            String string = (String)input;
            return new JsonPrimitive(string);
        }
        throw new IllegalStateException("Unrecognized type " + String.valueOf(input));
    }

    private static Number convertBDToGeneric(BigDecimal input) {
        try {
            long l2 = input.longValueExact();
            byte b2 = (byte)l2;
            short s2 = (short)l2;
            int i2 = (int)l2;
            if ((long)b2 == l2) {
                return b2;
            }
            if ((long)s2 == l2) {
                return s2;
            }
            if ((long)i2 == l2) {
                return i2;
            }
            return l2;
        }
        catch (ArithmeticException ex) {
            double d2 = input.doubleValue();
            float f2 = (float)d2;
            return (double)f2 == d2 ? (double)Float.valueOf(f2).floatValue() : Double.valueOf(d2);
        }
    }

    private static Object convertJsonToGeneric(TypeUtil<?> to, JsonElement element, boolean compressed) {
        if (element == null) {
            return null;
        }
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            return JsonTypeUtil.convertJson(to, jsonObject, compressed);
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return JsonTypeUtil.convertJson(to, array, compressed);
        }
        if (element instanceof JsonNull) {
            return null;
        }
        JsonPrimitive primitive = (JsonPrimitive)element;
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            Number number = CopyHelper.sanitizeNumber(primitive.getAsNumber());
            return number != null ? (Number)number : (Number)JsonTypeUtil.convertBDToGeneric(primitive.getAsBigDecimal());
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        throw new IllegalStateException("Unrecognized type " + String.valueOf(element));
    }

    private static MapType convertJson(TypeUtil<?> to, JsonObject json, boolean compressed) {
        MapType ret = to.createEmptyMap();
        for (Map.Entry entry : json.entrySet()) {
            Object obj = JsonTypeUtil.convertJsonToGeneric(to, (JsonElement)entry.getValue(), compressed);
            if (obj == null) continue;
            ret.setGeneric((String)entry.getKey(), obj);
        }
        return ret;
    }

    private static ListType convertJson(TypeUtil<?> to, JsonArray json, boolean compressed) {
        ListType ret = to.createEmptyList();
        int len = json.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ret.addGeneric(JsonTypeUtil.convertJsonToGeneric(to, json.get(i2), compressed));
        }
        return ret;
    }
}

