/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.misc;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.SingleUserAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;

public final class NearbyPlayers {
    private static final NearbyMapType[] MAP_TYPES = NearbyMapType.values();
    public static final int TOTAL_MAP_TYPES = MAP_TYPES.length;
    private static final int GENERAL_AREA_VIEW_DISTANCE = MoonriseConstants.MAX_VIEW_DISTANCE + 1;
    private static final int GENERAL_SMALL_VIEW_DISTANCE = 10;
    private static final int GENERAL_REALLY_SMALL_VIEW_DISTANCE = 3;
    public static final int GENERAL_AREA_VIEW_DISTANCE_BLOCKS = GENERAL_AREA_VIEW_DISTANCE << 4;
    public static final int GENERAL_SMALL_AREA_VIEW_DISTANCE_BLOCKS = 160;
    public static final int GENERAL_REALLY_SMALL_AREA_VIEW_DISTANCE_BLOCKS = 48;
    private final WorldServer world;
    private final Reference2ReferenceOpenHashMap<EntityPlayer, TrackedPlayer[]> players = new Reference2ReferenceOpenHashMap();
    private final Long2ReferenceOpenHashMap<TrackedChunk> byChunk = new Long2ReferenceOpenHashMap();
    private final Long2ReferenceOpenHashMap<ReferenceList<EntityPlayer>>[] directByChunk = new Long2ReferenceOpenHashMap[TOTAL_MAP_TYPES];

    public NearbyPlayers(WorldServer world) {
        for (int i2 = 0; i2 < this.directByChunk.length; ++i2) {
            this.directByChunk[i2] = new Long2ReferenceOpenHashMap();
        }
        this.world = world;
    }

    public void addPlayer(EntityPlayer player) {
        TrackedPlayer[] newTrackers = new TrackedPlayer[TOTAL_MAP_TYPES];
        if (this.players.putIfAbsent((Object)player, (Object)newTrackers) != null) {
            throw new IllegalStateException("Already have player " + String.valueOf(player));
        }
        ChunkCoordIntPair chunk = player.dH();
        for (int i2 = 0; i2 < TOTAL_MAP_TYPES; ++i2) {
            newTrackers[i2] = new TrackedPlayer(player, MAP_TYPES[i2]);
            newTrackers[i2].add(chunk.h, chunk.i, 0);
        }
        this.tickPlayer(player);
    }

    public void removePlayer(EntityPlayer player) {
        TrackedPlayer[] players = (TrackedPlayer[])this.players.remove((Object)player);
        if (players == null) {
            return;
        }
        for (TrackedPlayer tracker : players) {
            tracker.remove();
        }
    }

    public void clear() {
        if (this.players.isEmpty()) {
            return;
        }
        for (EntityPlayer player : new ArrayList(this.players.keySet())) {
            this.removePlayer(player);
        }
    }

    public void tickPlayer(EntityPlayer player) {
        TrackedPlayer[] players = (TrackedPlayer[])this.players.get((Object)player);
        if (players == null) {
            throw new IllegalStateException("Don't have player " + String.valueOf(player));
        }
        ChunkCoordIntPair chunk = player.dH();
        players[NearbyMapType.GENERAL.ordinal()].update(chunk.h, chunk.i, GENERAL_AREA_VIEW_DISTANCE);
        players[NearbyMapType.GENERAL_SMALL.ordinal()].update(chunk.h, chunk.i, 10);
        players[NearbyMapType.GENERAL_REALLY_SMALL.ordinal()].update(chunk.h, chunk.i, 3);
        players[NearbyMapType.TICK_VIEW_DISTANCE.ordinal()].update(chunk.h, chunk.i, PlatformHooks.get().getTickViewDistance(player));
        players[NearbyMapType.VIEW_DISTANCE.ordinal()].update(chunk.h, chunk.i, PlatformHooks.get().getViewDistance(player));
        players[NearbyMapType.SPAWN_RANGE.ordinal()].update(chunk.h, chunk.i, 8);
    }

    public TrackedChunk getChunk(ChunkCoordIntPair pos) {
        return (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(pos));
    }

    public TrackedChunk getChunk(BlockPosition pos) {
        return (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(pos));
    }

    public TrackedChunk getChunk(int chunkX, int chunkZ) {
        return (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public ReferenceList<EntityPlayer> getPlayers(BlockPosition pos, NearbyMapType type) {
        return (ReferenceList)this.directByChunk[type.ordinal()].get(CoordinateUtils.getChunkKey(pos));
    }

    public ReferenceList<EntityPlayer> getPlayers(ChunkCoordIntPair pos, NearbyMapType type) {
        return (ReferenceList)this.directByChunk[type.ordinal()].get(CoordinateUtils.getChunkKey(pos));
    }

    public ReferenceList<EntityPlayer> getPlayersByChunk(int chunkX, int chunkZ, NearbyMapType type) {
        return (ReferenceList)this.directByChunk[type.ordinal()].get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public ReferenceList<EntityPlayer> getPlayersByBlock(int blockX, int blockZ, NearbyMapType type) {
        return (ReferenceList)this.directByChunk[type.ordinal()].get(CoordinateUtils.getChunkKey(blockX >> 4, blockZ >> 4));
    }

    private final class TrackedPlayer
    extends SingleUserAreaMap<EntityPlayer> {
        private final NearbyMapType type;

        public TrackedPlayer(EntityPlayer player, NearbyMapType type) {
            super(player);
            this.type = type;
        }

        @Override
        protected void addCallback(EntityPlayer parameter, int chunkX, int chunkZ) {
            long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
            TrackedChunk chunk = (TrackedChunk)NearbyPlayers.this.byChunk.get(chunkKey);
            NearbyMapType type = this.type;
            if (chunk != null) {
                chunk.addPlayer(parameter, type);
                type.addTo(parameter, NearbyPlayers.this.world, chunkX, chunkZ);
            } else {
                TrackedChunk created = new TrackedChunk(chunkKey, NearbyPlayers.this);
                NearbyPlayers.this.byChunk.put(chunkKey, (Object)created);
                created.addPlayer(parameter, type);
                type.addTo(parameter, NearbyPlayers.this.world, chunkX, chunkZ);
                NearbyPlayers.this.world.moonrise$requestChunkData((long)chunkKey).nearbyPlayers = created;
            }
        }

        @Override
        protected void removeCallback(EntityPlayer parameter, int chunkX, int chunkZ) {
            long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
            TrackedChunk chunk = (TrackedChunk)NearbyPlayers.this.byChunk.get(chunkKey);
            if (chunk == null) {
                throw new IllegalStateException("Chunk should exist at " + String.valueOf(new ChunkCoordIntPair(chunkKey)));
            }
            NearbyMapType type = this.type;
            chunk.removePlayer(parameter, type);
            type.removeFrom(parameter, NearbyPlayers.this.world, chunkX, chunkZ);
            if (chunk.isEmpty()) {
                NearbyPlayers.this.byChunk.remove(chunkKey);
                ChunkData chunkData = NearbyPlayers.this.world.moonrise$releaseChunkData(chunkKey);
                if (chunkData != null) {
                    chunkData.nearbyPlayers = null;
                }
            }
        }
    }

    public static enum NearbyMapType {
        GENERAL,
        GENERAL_SMALL,
        GENERAL_REALLY_SMALL,
        TICK_VIEW_DISTANCE,
        VIEW_DISTANCE,
        SPAWN_RANGE{

            @Override
            void addTo(EntityPlayer player, WorldServer world, int chunkX, int chunkZ) {
                world.moonrise$addPlayerTickingRequest(chunkX, chunkZ);
            }

            @Override
            void removeFrom(EntityPlayer player, WorldServer world, int chunkX, int chunkZ) {
                world.moonrise$removePlayerTickingRequest(chunkX, chunkZ);
            }
        };


        void addTo(EntityPlayer player, WorldServer world, int chunkX, int chunkZ) {
        }

        void removeFrom(EntityPlayer player, WorldServer world, int chunkX, int chunkZ) {
        }
    }

    public static final class TrackedChunk {
        private static final EntityPlayer[] EMPTY_PLAYERS_ARRAY = new EntityPlayer[0];
        private final long chunkKey;
        private final NearbyPlayers nearbyPlayers;
        private final ReferenceList<EntityPlayer>[] players = new ReferenceList[TOTAL_MAP_TYPES];
        private int nonEmptyLists;
        private long updateCount;

        public TrackedChunk(long chunkKey, NearbyPlayers nearbyPlayers) {
            this.chunkKey = chunkKey;
            this.nearbyPlayers = nearbyPlayers;
        }

        public boolean isEmpty() {
            return this.nonEmptyLists == 0;
        }

        public long getUpdateCount() {
            return this.updateCount;
        }

        public ReferenceList<EntityPlayer> getPlayers(NearbyMapType type) {
            return this.players[type.ordinal()];
        }

        public void addPlayer(EntityPlayer player, NearbyMapType type) {
            ++this.updateCount;
            int idx = type.ordinal();
            ReferenceList<EntityPlayer> list = this.players[idx];
            if (list == null) {
                ++this.nonEmptyLists;
                this.players[idx] = new ReferenceList<EntityPlayer>(EMPTY_PLAYERS_ARRAY);
                ReferenceList<EntityPlayer> players = this.players[idx];
                this.nearbyPlayers.directByChunk[idx].put(this.chunkKey, players);
                players.add(player);
                return;
            }
            if (!list.add(player)) {
                throw new IllegalStateException("Already contains player " + String.valueOf(player));
            }
        }

        public void removePlayer(EntityPlayer player, NearbyMapType type) {
            ++this.updateCount;
            int idx = type.ordinal();
            ReferenceList<EntityPlayer> list = this.players[idx];
            if (list == null) {
                throw new IllegalStateException("Does not contain player " + String.valueOf(player));
            }
            if (!list.remove(player)) {
                throw new IllegalStateException("Does not contain player " + String.valueOf(player));
            }
            if (list.size() == 0) {
                this.players[idx] = null;
                this.nearbyPlayers.directByChunk[idx].remove(this.chunkKey);
                --this.nonEmptyLists;
            }
        }
    }
}

