/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.paper;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.paper.util.BaseChunkSystemHooks;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;
import org.spigotmc.TrackingRange;

public final class PaperHooks
extends BaseChunkSystemHooks
implements PlatformHooks {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getBrand() {
        return "Paper";
    }

    @Override
    public int getLightEmission(IBlockData blockState, IBlockAccess world, BlockPosition pos) {
        return blockState.k();
    }

    @Override
    public Predicate<IBlockData> maybeHasLightEmission() {
        return state -> state.k() != 0;
    }

    @Override
    public boolean hasCurrentlyLoadingChunk() {
        return false;
    }

    @Override
    public Chunk getCurrentlyLoadingChunk(GenerationChunkHolder holder) {
        return null;
    }

    @Override
    public void setCurrentlyLoading(GenerationChunkHolder holder, Chunk levelChunk) {
    }

    @Override
    public void chunkFullStatusComplete(Chunk newChunk, ProtoChunk original) {
    }

    @Override
    public boolean allowAsyncTicketUpdates() {
        return true;
    }

    @Override
    public void onChunkHolderTicketChange(WorldServer world, PlayerChunk holder, int oldLevel, int newLevel) {
    }

    @Override
    public void chunkUnloadFromWorld(Chunk chunk) {
    }

    @Override
    public void chunkSyncSave(WorldServer world, IChunkAccess chunk, SerializableChunkData data) {
    }

    @Override
    public void onChunkWatch(WorldServer world, Chunk chunk, EntityPlayer player) {
    }

    @Override
    public void onChunkUnWatch(WorldServer world, ChunkCoordIntPair chunk, EntityPlayer player) {
    }

    @Override
    public void addToGetEntities(World world, Entity entity, AxisAlignedBB boundingBox, Predicate<? super Entity> predicate, List<Entity> into) {
        Collection<EntityComplexPart> parts = world.t();
        if (parts.isEmpty()) {
            return;
        }
        for (EntityComplexPart part : parts) {
            if (part == entity || !part.de().c(boundingBox) || predicate != null && !predicate.test(part)) continue;
            into.add(part);
        }
    }

    @Override
    public <T extends Entity> void addToGetEntities(World world, EntityTypeTest<Entity, T> entityTypeTest, AxisAlignedBB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        if (into.size() >= maxCount) {
            return;
        }
        Collection<EntityComplexPart> parts = world.t();
        if (parts.isEmpty()) {
            return;
        }
        for (EntityComplexPart part : parts) {
            Entity casted;
            if (!part.de().c(boundingBox) || (casted = (Entity)entityTypeTest.a(part)) == null || predicate != null && !predicate.test(casted)) continue;
            into.add(casted);
            if (into.size() < maxCount) continue;
            break;
        }
    }

    @Override
    public void entityMove(Entity entity, long oldSection, long newSection) {
    }

    @Override
    public boolean screenEntity(WorldServer world, Entity entity, boolean fromDisk, boolean event) {
        return true;
    }

    @Override
    public long[] getCounterTypesUncached(TicketType type) {
        LongArrayList ret = new LongArrayList();
        if (type == TicketType.l) {
            ret.add(0L);
        }
        if (type.d()) {
            ret.add(1L);
        }
        return ret.toLongArray();
    }

    @Override
    public boolean configFixMC224294() {
        return true;
    }

    @Override
    public boolean configAutoConfigSendDistance() {
        return GlobalConfiguration.get().chunkLoadingAdvanced.autoConfigSendDistance;
    }

    @Override
    public double configPlayerMaxLoadRate() {
        return GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkLoadRate;
    }

    @Override
    public double configPlayerMaxGenRate() {
        return GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkGenerateRate;
    }

    @Override
    public double configPlayerMaxSendRate() {
        return GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkSendRate;
    }

    @Override
    public int configPlayerMaxConcurrentLoads() {
        return GlobalConfiguration.get().chunkLoadingAdvanced.playerMaxConcurrentChunkLoads;
    }

    @Override
    public int configPlayerMaxConcurrentGens() {
        return GlobalConfiguration.get().chunkLoadingAdvanced.playerMaxConcurrentChunkGenerates;
    }

    @Override
    public long configAutoSaveInterval(WorldServer world) {
        return world.paperConfig().chunks.autoSaveInterval.value();
    }

    @Override
    public int configMaxAutoSavePerTick(WorldServer world) {
        return world.paperConfig().chunks.maxAutoSaveChunksPerTick;
    }

    @Override
    public boolean configFixMC159283() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean forceNoSave(IChunkAccess chunk) {
        if (!(chunk instanceof Chunk)) return false;
        Chunk levelChunk = (Chunk)chunk;
        if (!levelChunk.mustNotSave) return false;
        return true;
    }

    @Override
    public NBTTagCompound convertNBT(DSL.TypeReference type, DataFixer dataFixer, NBTTagCompound nbt, int fromVersion, int toVersion) {
        if (type == DataConverterTypes.c) {
            return MCDataConverter.convertTag(MCTypeRegistry.PLAYER, nbt, fromVersion, toVersion);
        }
        if (type == DataConverterTypes.d) {
            return MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbt, fromVersion, toVersion);
        }
        if (type == DataConverterTypes.g) {
            return MCDataConverter.convertTag(MCTypeRegistry.STRUCTURE, nbt, fromVersion, toVersion);
        }
        if (type == DataConverterTypes.s) {
            return MCDataConverter.convertTag(MCTypeRegistry.POI_CHUNK, nbt, fromVersion, toVersion);
        }
        if (type == DataConverterTypes.t) {
            return MCDataConverter.convertTag(MCTypeRegistry.ENTITY_CHUNK, nbt, fromVersion, toVersion);
        }
        if (type == DataConverterTypes.v) {
            return MCDataConverter.convertTag(MCTypeRegistry.ITEM_STACK, nbt, fromVersion, toVersion);
        }
        if (type == DataConverterTypes.F || type == DataConverterTypes.E) {
            return MCDataConverter.convertTag(MCTypeRegistry.ENTITY, nbt, fromVersion, toVersion);
        }
        return (NBTTagCompound)dataFixer.update(type, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt), fromVersion, toVersion).getValue();
    }

    @Override
    public boolean hasMainChunkLoadHook() {
        return false;
    }

    @Override
    public void mainChunkLoad(IChunkAccess chunk, SerializableChunkData chunkData) {
    }

    @Override
    public List<Entity> modifySavedEntities(WorldServer world, int chunkX, int chunkZ, List<Entity> entities) {
        return entities;
    }

    @Override
    public void unloadEntity(Entity entity) {
        entity.setRemoved(Entity.RemovalReason.c, EntityRemoveEvent.Cause.UNLOAD);
    }

    @Override
    public void postLoadProtoChunk(WorldServer world, ProtoChunk chunk) {
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(chunk.E(), LOGGER);){
            ChunkStatusTasks.postLoadProtoChunk(world, TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)world.L_(), chunk.J()), chunk.f());
        }
    }

    @Override
    public int modifyEntityTrackingRange(Entity entity, int currentRange) {
        return TrackingRange.getEntityTrackingRange(entity, currentRange);
    }

    @Override
    public boolean addTicketForEnderPearls(WorldServer world) {
        return !world.paperConfig().misc.legacyEnderPearlBehavior;
    }
}

