/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.paper.util;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.util.ChunkSystemHooks;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public abstract class BaseChunkSystemHooks
implements ChunkSystemHooks {
    @Override
    public void scheduleChunkTask(WorldServer level, int chunkX, int chunkZ, Runnable run) {
        this.scheduleChunkTask(level, chunkX, chunkZ, run, Priority.NORMAL);
    }

    @Override
    public void scheduleChunkTask(WorldServer level, int chunkX, int chunkZ, Runnable run, Priority priority) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    @Override
    public void scheduleChunkLoad(WorldServer level, int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<IChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public void scheduleChunkLoad(WorldServer level, int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<IChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public void scheduleTickingState(WorldServer level, int chunkX, int chunkZ, FullChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<Chunk> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public List<PlayerChunk> getVisibleChunkHolders(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    @Override
    public List<PlayerChunk> getUpdatingChunkHolders(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    @Override
    public int getVisibleChunkHolderCount(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    @Override
    public int getUpdatingChunkHolderCount(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    @Override
    public boolean hasAnyChunkHolders(WorldServer level) {
        return this.getUpdatingChunkHolderCount(level) != 0;
    }

    @Override
    public void onChunkHolderCreate(WorldServer level, PlayerChunk holder) {
    }

    @Override
    public void onChunkHolderDelete(WorldServer level, PlayerChunk holder) {
    }

    @Override
    public void onChunkPreBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.I()).n().moonrise$setFullChunk(chunk.f().h, chunk.f().i, chunk);
    }

    @Override
    public void onChunkBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.I()).moonrise$getLoadedChunks().add(chunk);
        chunk.loadCallback();
    }

    @Override
    public void onChunkNotBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.I()).moonrise$getLoadedChunks().remove(chunk);
        chunk.unloadCallback();
    }

    @Override
    public void onChunkPostNotBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.I()).n().moonrise$setFullChunk(chunk.f().h, chunk.f().i, null);
    }

    @Override
    public void onChunkTicking(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.I()).moonrise$getTickingChunks().add(chunk);
        if (!chunk.moonrise$isPostProcessingDone()) {
            chunk.a((WorldServer)chunk.I());
        }
        ((WorldServer)chunk.I()).c(chunk);
    }

    @Override
    public void onChunkNotTicking(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.I()).moonrise$getTickingChunks().remove(chunk);
    }

    @Override
    public void onChunkEntityTicking(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.I()).moonrise$getEntityTickingChunks().add(chunk);
        ((WorldServer)chunk.I()).moonrise$markChunkForPlayerTicking(chunk);
    }

    @Override
    public void onChunkNotEntityTicking(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.I()).moonrise$getEntityTickingChunks().remove(chunk);
        ((WorldServer)chunk.I()).moonrise$removeChunkForPlayerTicking(chunk);
    }

    @Override
    public PlayerChunk getUnloadingChunkHolder(WorldServer level, int chunkX, int chunkZ) {
        return null;
    }

    @Override
    public int getSendViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    @Override
    public int getViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPIViewDistance(player);
    }

    @Override
    public int getTickViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    @Override
    public void addPlayerToDistanceMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().addPlayer(player);
    }

    @Override
    public void removePlayerFromDistanceMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().removePlayer(player);
    }

    @Override
    public void updateMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().updatePlayer(player);
    }
}

