/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public final class ChunkSystemConverters {
    private static final int DEFAULT_POI_DATA_VERSION = 1945;
    private static final int DEFAULT_ENTITY_CHUNK_DATA_VERSION = -1;

    private static int getCurrentVersion() {
        return SharedConstants.b().a().b();
    }

    private static int getDataVersion(NBTTagCompound data, int dfl) {
        return data.b("DataVersion", dfl);
    }

    public static NBTTagCompound convertPoiCompoundTag(NBTTagCompound data, WorldServer world) {
        int dataVersion = ChunkSystemConverters.getDataVersion(data, 1945);
        return PlatformHooks.get().convertNBT(DataConverterTypes.s, world.q().aE(), data, dataVersion, ChunkSystemConverters.getCurrentVersion());
    }

    public static NBTTagCompound convertEntityChunkCompoundTag(NBTTagCompound data, WorldServer world) {
        int dataVersion = ChunkSystemConverters.getDataVersion(data, -1);
        return PlatformHooks.get().convertNBT(DataConverterTypes.t, world.q().aE(), data, dataVersion, ChunkSystemConverters.getCurrentVersion());
    }

    private ChunkSystemConverters() {
    }
}

