/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.EntityList;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public final class ChunkEntitySlices {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final int minSection;
    public final int maxSection;
    public final int chunkX;
    public final int chunkZ;
    public final World world;
    private final EntityCollectionBySection allEntities;
    private final EntityCollectionBySection hardCollidingEntities;
    private final Reference2ObjectOpenHashMap<Class<? extends Entity>, EntityCollectionBySection> entitiesByClass;
    private final Reference2ObjectOpenHashMap<EntityTypes<?>, EntityCollectionBySection> entitiesByType;
    private final EntityList entities = new EntityList();
    public FullChunkStatus status;
    public final ChunkData chunkData;
    private boolean isTransient;
    private boolean preventStatusUpdates;

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean value) {
        this.isTransient = value;
    }

    public ChunkEntitySlices(World world, int chunkX, int chunkZ, FullChunkStatus status, ChunkData chunkData, int minSection, int maxSection) {
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.world = world;
        this.allEntities = new EntityCollectionBySection(this);
        this.hardCollidingEntities = new EntityCollectionBySection(this);
        this.entitiesByClass = new Reference2ObjectOpenHashMap();
        this.entitiesByType = new Reference2ObjectOpenHashMap();
        this.status = status;
        this.chunkData = chunkData;
    }

    public static List<Entity> readEntities(WorldServer world, ChunkCoordIntPair pos, NBTTagCompound compoundTag) {
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(IChunkAccess.a(pos), LOGGER);){
            ValueInput valueinput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)world.L_(), compoundTag);
            List list = (List)EntityTypes.a(valueinput.d("Entities"), (World)world, EntitySpawnReason.r).collect(ImmutableList.toImmutableList());
            return list;
        }
    }

    public static void copyEntities(NBTTagCompound from, NBTTagCompound into) {
        if (from == null) {
            return;
        }
        NBTTagList entitiesFrom = from.p("Entities");
        if (entitiesFrom == null || entitiesFrom.isEmpty()) {
            return;
        }
        NBTTagList entitiesInto = into.p("Entities");
        into.a("Entities", entitiesInto);
        entitiesInto.addAll(0, entitiesFrom);
    }

    public static NBTTagCompound saveEntityChunk(List<Entity> entities, ChunkCoordIntPair chunkPos, WorldServer world) {
        return ChunkEntitySlices.saveEntityChunk0(entities, chunkPos, world, false);
    }

    public static NBTTagCompound saveEntityChunk0(List<Entity> entities, ChunkCoordIntPair chunkPos, WorldServer world, boolean force) {
        if (!force && entities.isEmpty()) {
            return null;
        }
        NBTTagList entitiesTag = new NBTTagList();
        HashMap savedEntityCounts = new HashMap();
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(IChunkAccess.a(chunkPos), LOGGER);){
            for (Entity entity : PlatformHooks.get().modifySavedEntities(world, chunkPos.h, chunkPos.i, entities)) {
                EntityTypes<?> entityType = entity.ax();
                int saveLimit = world.paperConfig().chunks.entityPerChunkSaveLimit.getOrDefault(entityType, -1);
                if (saveLimit > -1) {
                    if (savedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) continue;
                    savedEntityCounts.merge(entityType, 1, Integer::sum);
                }
                TagValueOutput savedEntity = TagValueOutput.a(scopedCollector.a(entity.en()), entity.ej());
                try {
                    if (!entity.c(savedEntity)) continue;
                    entitiesTag.add(savedEntity.b());
                }
                catch (Exception ex) {
                    LOGGER.error("Entity type " + String.valueOf(entity.ax()) + " failed to serialize", (Throwable)ex);
                }
            }
        }
        NBTTagCompound ret = GameProfileSerializer.e(new NBTTagCompound());
        ret.a("Entities", entitiesTag);
        ret.a("Position", ChunkCoordIntPair.a, chunkPos);
        return !force && entitiesTag.isEmpty() ? null : ret;
    }

    public NBTTagCompound save() {
        int len = this.entities.size();
        if (len == 0) {
            return null;
        }
        Entity[] rawData = this.entities.getRawData();
        ArrayList<Entity> collectedEntities = new ArrayList<Entity>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            Entity entity = rawData[i2];
            if (!entity.ef()) continue;
            collectedEntities.add(entity);
        }
        if (collectedEntities.isEmpty()) {
            return null;
        }
        return ChunkEntitySlices.saveEntityChunk(collectedEntities, new ChunkCoordIntPair(this.chunkX, this.chunkZ), (WorldServer)this.world);
    }

    public boolean unload() {
        int len = this.entities.size();
        Entity[] collectedEntities = Arrays.copyOf(this.entities.getRawData(), len);
        for (int i2 = 0; i2 < len; ++i2) {
            Entity entity = collectedEntities[i2];
            if (entity.ec() || !entity.ef()) continue;
            PlatformHooks.get().unloadEntity(entity);
            if (!entity.cm()) continue;
            for (Entity passenger : entity.dm()) {
                PlatformHooks.get().unloadEntity(passenger);
            }
        }
        return this.entities.size() != 0;
    }

    public List<Entity> getAllEntities() {
        int len = this.entities.size();
        if (len == 0) {
            return new ArrayList<Entity>();
        }
        Entity[] rawData = this.entities.getRawData();
        ArrayList<Entity> collectedEntities = new ArrayList<Entity>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            collectedEntities.add(rawData[i2]);
        }
        return collectedEntities;
    }

    public boolean isEmpty() {
        return this.entities.size() == 0;
    }

    public void mergeInto(ChunkEntitySlices slices) {
        Entity[] entities = this.entities.getRawData();
        int size = Math.min(entities.length, this.entities.size());
        for (int i2 = 0; i2 < size; ++i2) {
            Entity entity = entities[i2];
            slices.addEntity(entity, entity.moonrise$getSectionY());
        }
    }

    public boolean startPreventingStatusUpdates() {
        boolean ret = this.preventStatusUpdates;
        this.preventStatusUpdates = true;
        return ret;
    }

    public boolean isPreventingStatusUpdates() {
        return this.preventStatusUpdates;
    }

    public void stopPreventingStatusUpdates(boolean prev) {
        this.preventStatusUpdates = prev;
    }

    public void updateStatus(FullChunkStatus status, EntityLookup lookup) {
        this.status = status;
        Entity[] entities = this.entities.getRawData();
        int size = this.entities.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Entity entity = entities[i2];
            Visibility oldVisibility = EntityLookup.getEntityStatus(entity);
            entity.moonrise$setChunkStatus(status);
            Visibility newVisibility = EntityLookup.getEntityStatus(entity);
            lookup.entityStatusChange(entity, this, oldVisibility, newVisibility, false, false, false);
        }
    }

    public boolean addEntity(Entity entity, int chunkSection) {
        if (!this.entities.add(entity)) {
            return false;
        }
        entity.moonrise$setChunkStatus(this.status);
        entity.moonrise$setChunkData(this.chunkData);
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.addEntity(entity, sectionIndex);
        if (entity.moonrise$isHardColliding()) {
            this.hardCollidingEntities.addEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).addEntity(entity, sectionIndex);
        }
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(entity.ax());
        if (byType != null) {
            byType.addEntity(entity, sectionIndex);
        } else {
            byType = new EntityCollectionBySection(this);
            this.entitiesByType.put(entity.ax(), (Object)byType);
            byType.addEntity(entity, sectionIndex);
        }
        return true;
    }

    public boolean removeEntity(Entity entity, int chunkSection) {
        if (!this.entities.remove(entity)) {
            return false;
        }
        entity.moonrise$setChunkStatus(null);
        entity.moonrise$setChunkData(null);
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.removeEntity(entity, sectionIndex);
        if (entity.moonrise$isHardColliding()) {
            this.hardCollidingEntities.removeEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).removeEntity(entity, sectionIndex);
        }
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(entity.ax());
        byType.removeEntity(entity, sectionIndex);
        return true;
    }

    public void getHardCollidingEntities(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate) {
        this.hardCollidingEntities.getEntities(except, box, into, predicate);
    }

    public void getEntities(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate) {
        this.allEntities.getEntities(except, box, into, predicate);
    }

    public boolean getEntities(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate, int maxCount) {
        return this.allEntities.getEntitiesLimited(except, box, into, predicate, maxCount);
    }

    public <T extends Entity> void getEntities(EntityTypes<?> type, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(type);
        if (byType != null) {
            byType.getEntities(null, box, into, predicate);
        }
    }

    public <T extends Entity> boolean getEntities(EntityTypes<?> type, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(type);
        if (byType != null) {
            return byType.getEntitiesLimited(null, box, into, predicate, maxCount);
        }
        return false;
    }

    protected EntityCollectionBySection initClass(Class<? extends Entity> clazz) {
        EntityCollectionBySection ret = new EntityCollectionBySection(this);
        for (int sectionIndex = 0; sectionIndex < this.allEntities.entitiesBySection.length; ++sectionIndex) {
            BasicEntityList<Entity> sectionEntities = this.allEntities.entitiesBySection[sectionIndex];
            if (sectionEntities == null) continue;
            E[] storage = sectionEntities.storage;
            int len = Math.min(storage.length, sectionEntities.size());
            for (int i2 = 0; i2 < len; ++i2) {
                Object entity = storage[i2];
                if (!clazz.isInstance(entity)) continue;
                ret.addEntity((Entity)entity, sectionIndex);
            }
        }
        return ret;
    }

    public <T extends Entity> void getEntities(Class<? extends T> clazz, Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        EntityCollectionBySection collection = (EntityCollectionBySection)this.entitiesByClass.get(clazz);
        if (collection != null) {
            collection.getEntities(except, box, into, predicate);
        } else {
            collection = this.initClass(clazz);
            this.entitiesByClass.put(clazz, (Object)collection);
            collection.getEntities(except, box, into, predicate);
        }
    }

    public <T extends Entity> boolean getEntities(Class<? extends T> clazz, Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        EntityCollectionBySection collection = (EntityCollectionBySection)this.entitiesByClass.get(clazz);
        if (collection != null) {
            return collection.getEntitiesLimited(except, box, into, predicate, maxCount);
        }
        collection = this.initClass(clazz);
        this.entitiesByClass.put(clazz, (Object)collection);
        return collection.getEntitiesLimited(except, box, into, predicate, maxCount);
    }

    private static final class EntityCollectionBySection {
        private final ChunkEntitySlices slices;
        private final BasicEntityList<Entity>[] entitiesBySection;
        private int count;

        public EntityCollectionBySection(ChunkEntitySlices slices) {
            this.slices = slices;
            int sectionCount = slices.maxSection - slices.minSection + 1;
            this.entitiesBySection = new BasicEntityList[sectionCount];
        }

        public void addEntity(Entity entity, int sectionIndex) {
            BasicEntityList<Entity> list = this.entitiesBySection[sectionIndex];
            if (list != null && list.has(entity)) {
                return;
            }
            if (list == null) {
                this.entitiesBySection[sectionIndex] = list = new BasicEntityList();
            }
            list.add(entity);
            ++this.count;
        }

        public void removeEntity(Entity entity, int sectionIndex) {
            BasicEntityList<Entity> list = this.entitiesBySection[sectionIndex];
            if (list == null || !list.remove(entity)) {
                return;
            }
            --this.count;
            if (list.isEmpty()) {
                this.entitiesBySection[sectionIndex] = null;
            }
        }

        public void getEntities(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.slices.minSection;
            int maxSection = this.slices.maxSection;
            int min = MathHelper.a(MathHelper.a(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.a(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || entity == except || !((Entity)entity).de().c(box) || predicate != null && !predicate.test((Entity)entity)) continue;
                    into.add((Entity)entity);
                }
            }
        }

        public boolean getEntitiesLimited(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate, int maxCount) {
            if (this.count == 0) {
                return false;
            }
            int minSection = this.slices.minSection;
            int maxSection = this.slices.maxSection;
            int min = MathHelper.a(MathHelper.a(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.a(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || entity == except || !((Entity)entity).de().c(box) || predicate != null && !predicate.test((Entity)entity)) continue;
                    into.add((Entity)entity);
                    if (into.size() < maxCount) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class BasicEntityList<E extends Entity> {
        private static final Entity[] EMPTY = new Entity[0];
        private static final int DEFAULT_CAPACITY = 4;
        private E[] storage;
        private int size;

        public BasicEntityList() {
            this(0);
        }

        public BasicEntityList(int cap) {
            this.storage = cap <= 0 ? EMPTY : new Entity[cap];
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        private void resize() {
            this.storage = this.storage == EMPTY ? new Entity[4] : (Entity[])Arrays.copyOf(this.storage, this.storage.length * 2);
        }

        public void add(E entity) {
            int idx;
            if ((idx = this.size++) >= this.storage.length) {
                this.resize();
                this.storage[idx] = entity;
            } else {
                this.storage[idx] = entity;
            }
        }

        public int indexOf(E entity) {
            E[] storage = this.storage;
            int len = Math.min(this.storage.length, this.size);
            for (int i2 = 0; i2 < len; ++i2) {
                if (storage[i2] != entity) continue;
                return i2;
            }
            return -1;
        }

        public boolean remove(E entity) {
            int idx = this.indexOf(entity);
            if (idx == -1) {
                return false;
            }
            int size = --this.size;
            E[] storage = this.storage;
            if (idx != size) {
                System.arraycopy(storage, idx + 1, storage, idx, size - idx);
            }
            storage[size] = null;
            return true;
        }

        public boolean has(E entity) {
            return this.indexOf(entity) != -1;
        }
    }
}

