/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling;

import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Priority;
import java.lang.invoke.VarHandle;

public abstract class PriorityHolder {
    protected volatile int priority;
    protected static final VarHandle PRIORITY_HANDLE = ConcurrentUtil.getVarHandle(PriorityHolder.class, (String)"priority", Integer.TYPE);
    protected static final int PRIORITY_SCHEDULED = Integer.MIN_VALUE;
    protected static final int PRIORITY_EXECUTED = 0x40000000;

    protected final int getPriorityVolatile() {
        return PRIORITY_HANDLE.getVolatile(this);
    }

    protected final int compareAndExchangePriorityVolatile(int expect, int update) {
        return PRIORITY_HANDLE.compareAndExchange(this, expect, update);
    }

    protected final int getAndOrPriorityVolatile(int val) {
        return PRIORITY_HANDLE.getAndBitwiseOr(this, val);
    }

    protected final void setPriorityPlain(int val) {
        PRIORITY_HANDLE.set(this, val);
    }

    protected PriorityHolder(Priority priority) {
        if (!Priority.isValidPriority((Priority)priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf(priority));
        }
        this.setPriorityPlain(priority.priority);
    }

    public boolean isScheduled() {
        return (this.getPriorityVolatile() & Integer.MIN_VALUE) != 0;
    }

    public boolean markExecuting() {
        return (this.getAndOrPriorityVolatile(0x40000000) & 0x40000000) == 0;
    }

    public boolean isMarkedExecuted() {
        return (this.getPriorityVolatile() & 0x40000000) != 0;
    }

    public void cancel() {
        if ((this.getAndOrPriorityVolatile(0x40000000) & 0x40000000) != 0) {
            return;
        }
        this.cancelScheduled();
    }

    public void schedule() {
        int priority = this.getPriorityVolatile();
        if ((priority & Integer.MIN_VALUE) != 0) {
            throw new IllegalStateException("schedule() called twice");
        }
        if ((priority & 0x40000000) != 0) {
            return;
        }
        this.scheduleTask(Priority.getPriority((int)priority));
        int failures = 0;
        block0: while (priority != (priority = this.compareAndExchangePriorityVolatile(priority, priority | Integer.MIN_VALUE))) {
            if ((priority & Integer.MIN_VALUE) != 0) {
                throw new IllegalStateException("schedule() called twice");
            }
            if ((priority & 0x40000000) != 0) {
                return;
            }
            this.setPriorityScheduled(Priority.getPriority((int)priority));
            ++failures;
            int i2 = 0;
            while (true) {
                if (i2 >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i2;
            }
            break;
        }
        return;
    }

    public final Priority getPriority() {
        int ret = this.getPriorityVolatile();
        if ((ret & 0x40000000) != 0) {
            return Priority.COMPLETING;
        }
        if ((ret & Integer.MIN_VALUE) != 0) {
            return this.getScheduledPriority();
        }
        return Priority.getPriority((int)ret);
    }

    public final void lowerPriority(Priority priority) {
        if (!Priority.isValidPriority((Priority)priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf(priority));
        }
        int failures = 0;
        int curr = this.getPriorityVolatile();
        block0: while ((curr & 0x40000000) == 0) {
            if ((curr & Integer.MIN_VALUE) != 0) {
                this.lowerPriorityScheduled(priority);
                return;
            }
            if (!priority.isLowerPriority(curr)) {
                return;
            }
            if (curr == (curr = this.compareAndExchangePriorityVolatile(curr, priority.priority))) {
                return;
            }
            ++failures;
            int i2 = 0;
            while (true) {
                if (i2 >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i2;
            }
            break;
        }
        return;
    }

    public final void setPriority(Priority priority) {
        if (!Priority.isValidPriority((Priority)priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf(priority));
        }
        int failures = 0;
        int curr = this.getPriorityVolatile();
        block0: while ((curr & 0x40000000) == 0) {
            if ((curr & Integer.MIN_VALUE) != 0) {
                this.setPriorityScheduled(priority);
                return;
            }
            if (curr == (curr = this.compareAndExchangePriorityVolatile(curr, priority.priority))) {
                return;
            }
            ++failures;
            int i2 = 0;
            while (true) {
                if (i2 >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i2;
            }
            break;
        }
        return;
    }

    public final void raisePriority(Priority priority) {
        if (!Priority.isValidPriority((Priority)priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf(priority));
        }
        int failures = 0;
        int curr = this.getPriorityVolatile();
        block0: while ((curr & 0x40000000) == 0) {
            if ((curr & Integer.MIN_VALUE) != 0) {
                this.raisePriorityScheduled(priority);
                return;
            }
            if (!priority.isHigherPriority(curr)) {
                return;
            }
            if (curr == (curr = this.compareAndExchangePriorityVolatile(curr, priority.priority))) {
                return;
            }
            ++failures;
            int i2 = 0;
            while (true) {
                if (i2 >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i2;
            }
            break;
        }
        return;
    }

    protected abstract void cancelScheduled();

    protected abstract Priority getScheduledPriority();

    protected abstract void scheduleTask(Priority var1);

    protected abstract void lowerPriorityScheduled(Priority var1);

    protected abstract void setPriorityScheduled(Priority var1);

    protected abstract void raisePriorityScheduled(Priority var1);
}

